package com.elitesland.tw.tw5.server.prd.personplan.service.inter;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PmsRelatedHistoryPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.PmsRelatedHistoryQuery;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PmsRelatedHistoryVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;

import java.util.List;


/**
 * 相关方变化历史记录service
 * @author wangxl
 * @date 2024/3/18
 */
public interface PmsRelatedHistoryService {

    /**
     * 分页查询
     *
     * @param query query
     * @return result
     */
    TwOutputUtil<PagingVO<PmsRelatedHistoryVO>> queryPage(PmsRelatedHistoryQuery query);

    /**
     * 列表查询
     *
     * @param query query
     * @return result
     */
    TwOutputUtil<List<PmsRelatedHistoryVO>> queryList(PmsRelatedHistoryQuery query);

    /**
     * count查询
     *
     * @param query query
     * @return result
     */
    TwOutputUtil<Long> queryCount(PmsRelatedHistoryQuery query);

    /**
     * 根据主键获取详情
     *
     * @param id 主键
     * @return result
     */
    TwOutputUtil<PmsRelatedHistoryVO> queryByKey(Long id);

    /**
     * 新增
     *
     * @param payload payload
     * @return result
     */
    TwOutputUtil<PmsRelatedHistoryVO> insert(PmsRelatedHistoryPayload payload);

    /**
     * 修改
     *
     * @param payload payload
     * @return result
     */
    TwOutputUtil<PmsRelatedHistoryVO> update(PmsRelatedHistoryPayload payload);

    /**
     * 动态修改，一般只用在少部分字段修改的场景，比如修改状态
     *
     * @param payload payload
     * @return result
     */
    TwOutputUtil<PmsRelatedHistoryVO> updateDynamic(PmsRelatedHistoryPayload payload);

    /**
     * 逻辑删除
     *
     * @param ids ids
     * @return result
     */
    TwOutputUtil<Long> deleteSoft(List<Long> ids);

}