package com.elitesland.tw.tw5.server.prd.pms.budget.controller;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.budget.payload.PmsWbsBudgetDetailsPayload;
import com.elitesland.tw.tw5.api.prd.pms.budget.query.PmsWbsBudgetDetailsQuery;
import com.elitesland.tw.tw5.api.prd.pms.budget.service.PmsWbsBudgetDetailsService;
import com.elitesland.tw.tw5.api.prd.pms.budget.vo.PmsWbsBudgetDetailsVO;
import com.elitesland.tw.tw5.api.prd.pms.budget.vo.PmsWbsBudgetVO;
import com.elitesland.tw.tw5.server.common.Consts;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 项目/预算/预算明细表
 *
 * @author duwh
 * @date 2024/3/7
 */
@RestController
@RequestMapping(Consts.URI_PREFIX + "/wbsBudgetDetails")
@RequiredArgsConstructor
@Slf4j
@Api(value = "预算明细表", tags = {"预算明细表"})
public class PmsWbsBudgetDetailsController {

    private final PmsWbsBudgetDetailsService service;

    @ApiOperation("预算初始化")
    @PostMapping("/init")
    // // @DuplicateSubmissionPrevention
    public TwOutputUtil<PmsWbsBudgetVO> init(@RequestBody PmsWbsBudgetDetailsPayload payload) {
        // 前端传送过来 wbs的版本信息 || 查询 wbs最新版本信息

        // 创建预算新版本
        // 拷贝预算主表、明细表数据

        // 对比预算明细中老活动数据与新版（临时版未激活最新）活动数据状态差异

        // （激活-变取消）有差异的数据 插入预算释放表

        // 关键日志打印
        log.debug("【PmsWbsBudgetDetailsController.insert】入参：" + payload.toString());
        PmsWbsBudgetVO pmsWbsBudgetVO = service.init(payload);
        return TwOutputUtil.ok(pmsWbsBudgetVO);
    }

    @ApiOperation("预算提交")
    @PostMapping("/submit")
    // // @DuplicateSubmissionPrevention
    public TwOutputUtil<List<PmsWbsBudgetDetailsVO>> submit(@RequestBody List<PmsWbsBudgetDetailsPayload> list) {
        List<PmsWbsBudgetDetailsVO> listResult = service.submit(list);
        return TwOutputUtil.ok(listResult);
    }

    @ApiOperation("预算释放确认")
    @PostMapping("/releaseOk")
    public TwOutputUtil<List<PmsWbsBudgetDetailsVO>> releaseOk(@RequestBody List<Long> id) {
        List<PmsWbsBudgetDetailsVO> listResult = service.releaseOk(id);
        return TwOutputUtil.ok(listResult);
    }

    @ApiOperation("分页查询")
    @GetMapping("/page")
    public TwOutputUtil<PagingVO<PmsWbsBudgetDetailsVO>> page(PmsWbsBudgetDetailsQuery query) {
        PagingVO<PmsWbsBudgetDetailsVO> pagingVO = service.queryPage(query);
        return TwOutputUtil.ok(pagingVO);
    }

    @ApiOperation("列表查询")
    @GetMapping("/list")
    public TwOutputUtil<List<PmsWbsBudgetDetailsVO>> list(PmsWbsBudgetDetailsQuery query) {
        List<PmsWbsBudgetDetailsVO> voList = service.queryList(query);
        return TwOutputUtil.ok(voList);
    }

    @ApiOperation("主键查询")
    @GetMapping("/key")
    public TwOutputUtil<PmsWbsBudgetDetailsVO> queryByKey(Long id) {
        PmsWbsBudgetDetailsVO vo = service.queryByKey(id);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation("新增")
    @PostMapping("/insert")
    // @DuplicateSubmissionPrevention
    public TwOutputUtil<PmsWbsBudgetDetailsVO> insert(@RequestBody PmsWbsBudgetDetailsPayload payload) {
        // 关键日志打印
        log.debug("【PmsWbsBudgetDetailsController.insert】入参：" + payload.toString());
        PmsWbsBudgetDetailsVO vo = service.insert(payload);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation("修改")
    @PostMapping("/update")
    public TwOutputUtil<PmsWbsBudgetDetailsVO> update(@RequestBody PmsWbsBudgetDetailsPayload payload) {
        // 关键日志打印
        log.debug("【PmsWbsBudgetDetailsController.update】入参：" + payload.toString());
        PmsWbsBudgetDetailsVO vo = service.update(payload);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation("批量修改")
    @PostMapping("/updateList")
    public TwOutputUtil updateList(@RequestBody List<PmsWbsBudgetDetailsPayload> payload) {
        service.updateList(payload);
        return TwOutputUtil.ok();
    }

    @ApiOperation("动态修改")
    @PostMapping("/updateDynamic")
    public TwOutputUtil<PmsWbsBudgetDetailsVO> updateDynamic(@RequestBody PmsWbsBudgetDetailsPayload payload) {
        // 关键日志打印
        log.debug("【PmsWbsBudgetDetailsController.updateDynamic】入参：" + payload.toString());
        PmsWbsBudgetDetailsVO vo = service.updateDynamic(payload);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation("删除")
    @PostMapping("/deleteSoft")
    public TwOutputUtil<Long> deleteSoft(@RequestBody List<Long> ids) {
        log.debug("【PmsWbsBudgetDetailsController.deleteSoft】入参：" + ids);
        Long res = service.deleteSoft(ids);
        return TwOutputUtil.ok(res);
    }
}
