package com.elitesland.tw.tw5.server.prd.pms.budget.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.budget.payload.PmsWbsBudgetPayload;
import com.elitesland.tw.tw5.api.prd.pms.budget.query.PmsWbsBudgetQuery;
import com.elitesland.tw.tw5.api.prd.pms.budget.vo.PmsWbsBudgetVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.pms.budget.convert.PmsWbsBudgetConvert;
import com.elitesland.tw.tw5.server.prd.pms.budget.dao.repo.PmsWbsBudgetRepo;
import com.elitesland.tw.tw5.server.prd.pms.budget.model.entity.PmsWbsBudgetDO;
import com.elitesland.tw.tw5.server.prd.pms.budget.model.entity.QPmsWbsBudgetDO;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.util.Collections;
import java.util.List;


/**
 * 预算主表dao
 *
 * @author duwh
 * @date 2024/3/7
 */
@RequiredArgsConstructor
@Component
public class PmsWbsBudgetDao {

    private static final QPmsWbsBudgetDO qdo = QPmsWbsBudgetDO.pmsWbsBudgetDO;
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsWbsBudgetRepo repo;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PmsWbsBudgetVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PmsWbsBudgetVO.class,
            qdo.id,
            qdo.tenantId,
            qdo.belongOrgId,
            qdo.createUserId,
            qdo.creator,
            qdo.createTime,
            qdo.modifyUserId,
            qdo.updater,
            qdo.modifyTime,
            qdo.tenantOrgId,
            qdo.remark,
            qdo.deleteFlag,
            qdo.proId,
            qdo.objectName,
            qdo.objectNo,
            qdo.objectStatus,
            qdo.versionId,
            qdo.versionNo,
            qdo.totalResAmt,
            qdo.totalSettledResAmt,
            qdo.totalOccupiedResAmt,
            qdo.totalRemainingResAmt,
            qdo.totalFeeAmt,
            qdo.totalSettledFeeAmt,
            qdo.totalOccupiedFeeAmt,
            qdo.totalRemainingFeeAmt,
            qdo.effRelateId,
            qdo.procInstId,
            qdo.procInstStatus,
            qdo.submitTime,
            qdo.approvedTime,
            qdo.extString1,
            qdo.extString2,
            qdo.extString3,
            qdo.extString4,
            qdo.extString5
        )).from(qdo);
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<Long> getJpaQuerySelectCount() {
        return jpaQueryFactory.select(qdo.id.count()).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     */
    private void jpaQueryWhere(JPAQuery<?> jpaQuery, PmsWbsBudgetQuery query) {
        if (!ObjectUtils.isEmpty(query.getRemark())) {
            jpaQuery.where(qdo.remark.eq(query.getRemark()));
        }
        if (!ObjectUtils.isEmpty(query.getProId())) {
            jpaQuery.where(qdo.proId.eq(query.getProId()));
        }
        if (!ObjectUtils.isEmpty(query.getObjectName())) {
            jpaQuery.where(qdo.objectName.like(SqlUtil.toSqlLikeString(query.getObjectName())));
        }
        if (!ObjectUtils.isEmpty(query.getObjectNo())) {
            jpaQuery.where(qdo.objectNo.like(SqlUtil.toSqlLikeString(query.getObjectNo())));
        }
        if (!ObjectUtils.isEmpty(query.getObjectStatus())) {
            jpaQuery.where(qdo.objectStatus.eq(query.getObjectStatus()));
        }
        if (!ObjectUtils.isEmpty(query.getVersionId())) {
            jpaQuery.where(qdo.versionId.eq(query.getVersionId()));
        }
        if (!ObjectUtils.isEmpty(query.getVersionNo())) {
            jpaQuery.where(qdo.versionNo.eq(query.getVersionNo()));
        }
        if (!ObjectUtils.isEmpty(query.getTotalResAmt())) {
            jpaQuery.where(qdo.totalResAmt.eq(query.getTotalResAmt()));
        }
        if (!ObjectUtils.isEmpty(query.getTotalSettledResAmt())) {
            jpaQuery.where(qdo.totalSettledResAmt.eq(query.getTotalSettledResAmt()));
        }
        if (!ObjectUtils.isEmpty(query.getTotalOccupiedResAmt())) {
            jpaQuery.where(qdo.totalOccupiedResAmt.eq(query.getTotalOccupiedResAmt()));
        }
        if (!ObjectUtils.isEmpty(query.getTotalRemainingResAmt())) {
            jpaQuery.where(qdo.totalRemainingResAmt.eq(query.getTotalRemainingResAmt()));
        }
        if (!ObjectUtils.isEmpty(query.getTotalFeeAmt())) {
            jpaQuery.where(qdo.totalFeeAmt.eq(query.getTotalFeeAmt()));
        }
        if (!ObjectUtils.isEmpty(query.getTotalSettledFeeAmt())) {
            jpaQuery.where(qdo.totalSettledFeeAmt.eq(query.getTotalSettledFeeAmt()));
        }
        if (!ObjectUtils.isEmpty(query.getTotalOccupiedFeeAmt())) {
            jpaQuery.where(qdo.totalOccupiedFeeAmt.eq(query.getTotalOccupiedFeeAmt()));
        }
        if (!ObjectUtils.isEmpty(query.getTotalRemainingFeeAmt())) {
            jpaQuery.where(qdo.totalRemainingFeeAmt.eq(query.getTotalRemainingFeeAmt()));
        }
        if (!ObjectUtils.isEmpty(query.getEffRelateId())) {
            jpaQuery.where(qdo.effRelateId.eq(query.getEffRelateId()));
        }
        if (!ObjectUtils.isEmpty(query.getProcInstId())) {
            jpaQuery.where(qdo.procInstId.eq(query.getProcInstId()));
        }
        if (!ObjectUtils.isEmpty(query.getProcInstStatus())) {
            jpaQuery.where(qdo.procInstStatus.eq(query.getProcInstStatus()));
        }
        if (!ObjectUtils.isEmpty(query.getSubmitTime())) {
            jpaQuery.where(qdo.submitTime.eq(query.getSubmitTime()));
        }
        if (!ObjectUtils.isEmpty(query.getApprovedTime())) {
            jpaQuery.where(qdo.approvedTime.eq(query.getApprovedTime()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString1())) {
            jpaQuery.where(qdo.extString1.eq(query.getExtString1()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString2())) {
            jpaQuery.where(qdo.extString2.eq(query.getExtString2()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString3())) {
            jpaQuery.where(qdo.extString3.eq(query.getExtString3()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString4())) {
            jpaQuery.where(qdo.extString4.eq(query.getExtString4()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString5())) {
            jpaQuery.where(qdo.extString5.eq(query.getExtString5()));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return result
     */
    public PagingVO<PmsWbsBudgetVO> queryPage(PmsWbsBudgetQuery query) {
        // 查询总行数total
        JPAQuery<Long> jpaQuerySelectCount = getJpaQuerySelectCount();
        jpaQueryWhere(jpaQuerySelectCount, query);
        Long nullAbleCount = jpaQuerySelectCount.fetchOne();
        long count = nullAbleCount == null ? 0 : nullAbleCount;
        // 如果总行数为0则直接返回
        if (count == 0) {
            return PagingVO.<PmsWbsBudgetVO>builder()
                .total(count)
                .records(Collections.emptyList())
                .build();
        }
        JPAQuery<PmsWbsBudgetVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQueryWhere(jpaQuerySelect, query);
        // 动态排序
        jpaQuerySelect.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        SqlUtil.handlePage(jpaQuerySelect, query);
        jpaQuerySelect.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest() .getPageSize());
        return PagingVO.<PmsWbsBudgetVO>builder()
            .total(count)
            .records(jpaQuerySelect.fetch())
            .build();
    }

    /**
     * 查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PmsWbsBudgetVO> queryList(PmsWbsBudgetQuery query) {
        JPAQuery<PmsWbsBudgetVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQueryWhere(jpaQuerySelect, query);
        // 动态排序
        jpaQuerySelect.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuerySelect.fetch();
    }

    /**
     * 查询count
     *
     * @param query 查询参数
     * @return count
     */
    public long queryCount(PmsWbsBudgetQuery query) {
        JPAQuery<Long> jpaQuerySelectCount = getJpaQuerySelectCount();
        jpaQueryWhere(jpaQuerySelectCount, query);
        Long count = jpaQuerySelectCount.fetchOne();
        return count == null ? 0 : count;
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PmsWbsBudgetVO queryByKey(Long id) {
        JPAQuery<PmsWbsBudgetVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }


    /**
     * 按项目idd和版本id获取
     *
     * @param proId     项目id
     * @param versionId 版本id
     * @return {@link PmsWbsBudgetVO}
     */
    public PmsWbsBudgetVO getByProIdAndVersionId(Long proId, Long versionId) {
        JPAQuery<PmsWbsBudgetVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.proId.eq(proId));
        jpaQuery.where(qdo.versionId.eq(versionId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 调用jpa的保存
     *
     * @param payload payload
     * @return 保存后的对象
     */
    public PmsWbsBudgetVO save(PmsWbsBudgetPayload payload) {
        PmsWbsBudgetDO ado = PmsWbsBudgetConvert.INSTANCE.toEntity(payload);
        // 创建单据的时候审计字段会被前端传的值影响，强制清空相关字段
        SqlUtil.clearAuditFields(ado);
        repo.save(ado);
        return PmsWbsBudgetConvert.INSTANCE.toVO(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<PmsWbsBudgetDO> saveAll(List<PmsWbsBudgetDO> dos) {
        // 创建单据的时候审计字段会被前端传的值影响，强制清空相关字段
        SqlUtil.clearAuditFields(dos);
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    public long updateByKeyDynamic(PmsWbsBudgetPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .where(qdo.id.eq(payload.getId()));
        if (payload.getRemark() != null) {
            update.set(qdo.remark, payload.getRemark());
        }
        if (payload.getProId() != null) {
            update.set(qdo.proId, payload.getProId());
        }
        if (payload.getObjectName() != null) {
            update.set(qdo.objectName, payload.getObjectName());
        }
        if (payload.getObjectNo() != null) {
            update.set(qdo.objectNo, payload.getObjectNo());
        }
        if (payload.getObjectStatus() != null) {
            update.set(qdo.objectStatus, payload.getObjectStatus());
        }
        if (payload.getVersionId() != null) {
            update.set(qdo.versionId, payload.getVersionId());
        }
        if (payload.getVersionNo() != null) {
            update.set(qdo.versionNo, payload.getVersionNo());
        }
        if (payload.getTotalResAmt() != null) {
            update.set(qdo.totalResAmt, payload.getTotalResAmt());
        }
        if (payload.getTotalSettledResAmt() != null) {
            update.set(qdo.totalSettledResAmt, payload.getTotalSettledResAmt());
        }
        if (payload.getTotalOccupiedResAmt() != null) {
            update.set(qdo.totalOccupiedResAmt, payload.getTotalOccupiedResAmt());
        }
        if (payload.getTotalRemainingResAmt() != null) {
            update.set(qdo.totalRemainingResAmt, payload.getTotalRemainingResAmt());
        }
        if (payload.getTotalFeeAmt() != null) {
            update.set(qdo.totalFeeAmt, payload.getTotalFeeAmt());
        }
        if (payload.getTotalSettledFeeAmt() != null) {
            update.set(qdo.totalSettledFeeAmt, payload.getTotalSettledFeeAmt());
        }
        if (payload.getTotalOccupiedFeeAmt() != null) {
            update.set(qdo.totalOccupiedFeeAmt, payload.getTotalOccupiedFeeAmt());
        }
        if (payload.getTotalRemainingFeeAmt() != null) {
            update.set(qdo.totalRemainingFeeAmt, payload.getTotalRemainingFeeAmt());
        }
        if (payload.getEffRelateId() != null) {
            update.set(qdo.effRelateId, payload.getEffRelateId());
        }
        if (payload.getProcInstId() != null) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        if (payload.getProcInstStatus() != null) {
            update.set(qdo.procInstStatus, payload.getProcInstStatus());
        }
        if (payload.getSubmitTime() != null) {
            update.set(qdo.submitTime, payload.getSubmitTime());
        }
        if (payload.getApprovedTime() != null) {
            update.set(qdo.approvedTime, payload.getApprovedTime());
        }
        if (payload.getExtString1() != null) {
            update.set(qdo.extString1, payload.getExtString1());
        }
        if (payload.getExtString2() != null) {
            update.set(qdo.extString2, payload.getExtString2());
        }
        if (payload.getExtString3() != null) {
            update.set(qdo.extString3, payload.getExtString3());
        }
        if (payload.getExtString4() != null) {
            update.set(qdo.extString4, payload.getExtString4());
        }
        if (payload.getExtString5() != null) {
            update.set(qdo.extString5, payload.getExtString5());
        }
        // 处理要设置成空的字段(nullField处理)
        SqlUtil.handleNullFieldsUpdate(payload, qdo, update);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        return update.execute();
    }

}
