package com.elitesland.tw.tw5.server.prd.pms.budget.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;


/**
 * 预算明细表DO
 * @author duwh
 * @date 2024-1-18
*/
@Entity
@Table(name = "pms_wbs_budget_details")
@org.hibernate.annotations.Table(appliesTo = "pms_wbs_budget_details", comment = "预算明细表")
@Getter
@Setter
@Where(clause = "delete_flag = 0")
public class PmsWbsBudgetDetailsDO extends BaseModel {

    @Comment("主表 id pms_wbs_budget.id")
    @Column
    private Long budgetId;

    @Comment("wbs 活动主键")
    @Column
    private Long wbsId;

    @Comment("wbs 活动名称（冗余)")
    @Column
    private String wbsName;
    /**
     * wbs编码
     */
    @Comment("wbs编码（冗余)")
    @Column
    private String wbsCode;

    @Comment("wbs 活动状态(冗余)")
    @Column
    private String wbsStatus;

    @Comment("版本 id")
    @Column
    private Long versionId;

    @Comment("版本号")
    @Column
    private Integer versionNo;

    @Comment("项目id")
    @Column
    private Long proId;

    @Comment("有效关联id")
    @Column
    private Long effRelateId;

    @Comment("资源成本")
    @Column
    private BigDecimal resCost;

    @Comment("当前分配预算")
    @Column
    private BigDecimal allocatedResAmt;

    @Comment("剩余")
    @Column
    private BigDecimal remainingResAmt;

    @Comment("已占用")
    @Column
    private BigDecimal occupiedResAmt;

    @Comment("已结算")
    @Column
    private BigDecimal settledResAmt;

    @Comment("变更量")
    @Column
    private BigDecimal changeResAmt;

    @Comment("变更后分配预算")
    @Column
    private BigDecimal changedAllocatedResAmt;

    @Comment("拓展字段1")
    @Column
    private String extString1;

    @Comment("拓展字段2")
    @Column
    private String extString2;

    @Comment("拓展字段3")
    @Column
    private String extString3;

    @Comment("拓展字段4")
    @Column
    private String extString4;

    @Comment("拓展字段5")
    @Column
    private String extString5;

}
