package com.elitesland.tw.tw5.server.prd.pms.budget.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;


/**
 * 预算释放表DO
 * @author duwh
 * @date 2024-1-18
*/
@Entity
@Table(name = "pms_wbs_budget_release")
@org.hibernate.annotations.Table(appliesTo = "pms_wbs_budget_release", comment = "预算释放表")
@Getter
@Setter
@Where(clause = "delete_flag = 0")
public class PmsWbsBudgetReleaseDO extends BaseModel {

    @Comment("wbs 活动主键")
    @Column
    private Long wbsId;
    
    @Comment("版本 id")
    @Column
    private Long versionId;
    
    @Comment("有效关联id")
    @Column
    private Long effRelateId;
    
    @Comment("当前分配预算")
    @Column
    private BigDecimal allocatedResAmtBefore;
    
    @Comment("已结算")
    @Column
    private BigDecimal settledResAmtBefore;
    
    @Comment("已占用")
    @Column
    private BigDecimal occupiedResAmtBefore;
    
    @Comment("剩余")
    @Column
    private BigDecimal remainingResAmtBefore;
    
    @Comment("当前分配预算")
    @Column
    private BigDecimal allocatedResAmtAfter;
    
    @Comment("已结算")
    @Column
    private BigDecimal settledResAmtAfter;
    
    @Comment("已占用")
    @Column
    private BigDecimal occupiedResAmtAfter;
    
    @Comment("剩余")
    @Column
    private BigDecimal remainingResAmtAfter;
    
    @Comment("变更量")
    @Column
    private BigDecimal changeResAmt;
    
    @Comment("确认结算")
    @Column
    private BigDecimal confirmSettledRes;
    
    @Comment("项目id")
    @Column
    private Long proId;
    
}