package com.elitesland.tw.tw5.server.prd.pms.budget.service.impl;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.budget.payload.PmsWbsBudgetReleasePayload;
import com.elitesland.tw.tw5.api.prd.pms.budget.query.PmsWbsBudgetReleaseQuery;
import com.elitesland.tw.tw5.api.prd.pms.budget.service.PmsWbsBudgetReleaseService;
import com.elitesland.tw.tw5.api.prd.pms.budget.vo.PmsWbsBudgetReleaseVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.pms.budget.dao.PmsWbsBudgetReleaseDao;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


/**
 * 预算释放表service impl
 *
 * @author duwh
 * @date 2024/3/7
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class PmsWbsBudgetReleaseServiceImpl implements PmsWbsBudgetReleaseService {

    private final PmsWbsBudgetReleaseDao dao;

    @Override
    public PagingVO<PmsWbsBudgetReleaseVO> queryPage(PmsWbsBudgetReleaseQuery query) {
        PagingVO<PmsWbsBudgetReleaseVO> pageVO = dao.queryPage(query);
        translate(pageVO.getRecords());
        return pageVO;
    }

    @Override
    public List<PmsWbsBudgetReleaseVO> queryList(PmsWbsBudgetReleaseQuery query) {
        List<PmsWbsBudgetReleaseVO> listVO = dao.queryList(query);
        translate(listVO);
        return listVO;
    }

    @Override
    public long queryCount(PmsWbsBudgetReleaseQuery query) {
        return dao.queryCount(query);
    }

    @Override
    public PmsWbsBudgetReleaseVO queryByKey(Long id) {
        if (null == id) {
            return null;
        }
        PmsWbsBudgetReleaseVO vo = dao.queryByKey(id);
        Assert.notNull(vo, "查询的数据不存在");
        translate(List.of(vo));
        return vo;
    }

    @Override
    @Transactional
    public PmsWbsBudgetReleaseVO insert(PmsWbsBudgetReleasePayload payload) {
        // 检查数据局
        checkData(payload);
        // 保存数据
        PmsWbsBudgetReleaseVO save = dao.save(payload);
        // todo 开启工作流
        // startWorkFlow(ado);
        return queryByKey(save.getId());
    }

    @Override
    @Transactional
    public PmsWbsBudgetReleaseVO update(PmsWbsBudgetReleasePayload payload) {
        Assert.notNull(payload.getId(), "id不能为空");
        // 检查数据局
        checkData(payload);
        // 保存数据
        PmsWbsBudgetReleaseVO save = dao.save(payload);
        return queryByKey(save.getId());
    }

    @Override
    @Transactional
    public PmsWbsBudgetReleaseVO updateDynamic(PmsWbsBudgetReleasePayload payload) {
        Assert.notNull(payload.getId(), "id不能为空");
        // 检查数据局
        checkData(payload);
        // 保存数据
        dao.updateByKeyDynamic(payload);
        return queryByKey(payload.getId());
    }

    @Override
    @Transactional
    public Long deleteSoft(List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            throw  TwException.error("","ids参数不能为空");
        }
        return dao.deleteSoft(ids);
    }

    @Override
    public List<PmsWbsBudgetReleaseVO> insertAll(List<PmsWbsBudgetReleasePayload> releasePayloadList) {
        List<PmsWbsBudgetReleaseVO> list = new ArrayList<>();
        if (!CollectionUtils.isEmpty(releasePayloadList)) {
            releasePayloadList.forEach(releasePayload -> {
                PmsWbsBudgetReleaseVO insert = insert(releasePayload);
                list.add(insert);
            });
        }
        return list;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsWbsBudgetReleaseVO updatePro(PmsWbsBudgetReleasePayload payload) {
        //仅接收这几个值 {"confirmSettledRes":1.5,"changeResAmt":9.5,"id":"801135106168265723"}
        /**
         * 输入确认结算金额（合法区间[0, 已占用预算]），会即时计算 释放值 =（释放前）剩余预算 + ((释放前)已占用预算 - 确认结算）点击「确定」后，刷新“释放后”分组列的数据：
         * (释放后)分配预算 = (释放后)已结算
         * (释放后)已结算 =（释放前)已结算 + 确认结算
         * 释放值 =（释放前）剩余预算 + ((释放前)已占用预算 - 确认结算）
         * 另外还有两个数据要算，没展示出来：
         * (释放后) 已占用 = 0
         * (释放后) 剩余 = 0
         *
         */
        Long id = payload.getId();
        Assert.notNull(id, "id不能为空");
        PmsWbsBudgetReleaseVO pmsWbsBudgetReleaseVO = queryByKey(id);

        PmsWbsBudgetReleasePayload updatedPayload = new PmsWbsBudgetReleasePayload();

        BigDecimal confirmSettledRes = payload.getConfirmSettledRes() == null ? BigDecimal.ZERO : payload.getConfirmSettledRes();
        updatedPayload.setConfirmSettledRes(confirmSettledRes);
        BigDecimal settledResAmtBefore = pmsWbsBudgetReleaseVO.getSettledResAmtBefore() == null ? BigDecimal.ZERO : pmsWbsBudgetReleaseVO.getSettledResAmtBefore();
        updatedPayload.setId(id);
        BigDecimal settledResAmtAfter = settledResAmtBefore.add(confirmSettledRes);
        updatedPayload.setSettledResAmtAfter(settledResAmtAfter);
        updatedPayload.setAllocatedResAmtAfter(settledResAmtAfter);
        //前端已算好！！！ 释放值 =（释放前）剩余预算 + ((释放前)已占用预算 - 确认结算）
        updatedPayload.setOccupiedResAmtAfter(BigDecimal.ZERO);
        updatedPayload.setRemainingResAmtAfter(BigDecimal.ZERO);
        BigDecimal changeResAmt = payload.getChangeResAmt() == null ? BigDecimal.ZERO : payload.getChangeResAmt();
        updatedPayload.setChangeResAmt(changeResAmt);
        dao.updateByKeyDynamic(updatedPayload);
        return queryByKey(id);
    }


    /**
     * 数据校验
     *
     * @param payload payload
     */
    private void checkData(PmsWbsBudgetReleasePayload payload) {
    }

    /**
     * todo
     *
     * @param vos vos
     */
    private void translate(List<PmsWbsBudgetReleaseVO> vos) {
        vos.forEach(vo -> {
            // todo 翻译vo对象
//            vo.setUserIdDesc("");
        });
    }

}
