package com.elitesland.tw.tw5.server.prd.pms.budget.service.impl;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.service.PersonPlanService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanDtlVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanVO;
import com.elitesland.tw.tw5.api.prd.pms.budget.payload.PmsWbsBudgetPayload;
import com.elitesland.tw.tw5.api.prd.pms.budget.query.PmsWbsBudgetQuery;
import com.elitesland.tw.tw5.api.prd.pms.budget.service.PmsWbsBudgetDetailsService;
import com.elitesland.tw.tw5.api.prd.pms.budget.service.PmsWbsBudgetService;
import com.elitesland.tw.tw5.api.prd.pms.budget.service.PmsWbsBudgetVersionService;
import com.elitesland.tw.tw5.api.prd.pms.budget.vo.PmsWbsBudgetVO;
import com.elitesland.tw.tw5.api.prd.pms.budget.vo.PmsWbsBudgetVersionVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectWbsResourceService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.pms.budget.dao.PmsWbsBudgetDao;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


/**
 * 预算主表service impl
 *
 * @author duwh
 * @date 2024/3/7
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class PmsWbsBudgetServiceImpl implements PmsWbsBudgetService {

    private final PmsWbsBudgetDao dao;
    private final PmsWbsBudgetVersionService pmsWbsBudgetVersionService;
    @Resource
    private PersonPlanService personPlanService;

    @Override
    public PagingVO<PmsWbsBudgetVO> queryPage(PmsWbsBudgetQuery query) {
        PagingVO<PmsWbsBudgetVO> pageVO = dao.queryPage(query);
        translate(pageVO.getRecords());
        return pageVO;
    }

    @Override
    public List<PmsWbsBudgetVO> queryList(PmsWbsBudgetQuery query) {
        List<PmsWbsBudgetVO> listVO = dao.queryList(query);
        translate(listVO);
        return listVO;
    }

    @Override
    public long queryCount(PmsWbsBudgetQuery query) {
        return dao.queryCount(query);
    }

    @Override
    public PmsWbsBudgetVO queryByKey(Long id) {
        if (null == id) {
            return null;
        }
        PmsWbsBudgetVO vo = dao.queryByKey(id);
        Assert.notNull(vo, "查询的数据不存在");
        translate(List.of(vo));
        return vo;
    }

    @Override
    @Transactional
    public PmsWbsBudgetVO insert(PmsWbsBudgetPayload payload) {
        // 检查数据局
        checkData(payload);
        // 保存数据
        PmsWbsBudgetVO save = dao.save(payload);
        // todo 开启工作流
        // startWorkFlow(ado);
        // 处理默认值，计算剩余费用
        defaultValueAndCalculate(save);
        // pmsWbsBudgetDetailsService.calculateMainTableInformation(save.getId());
        return queryByKey(save.getId());
    }

    /**
     * 默认值并计算
     *
     * @param save 拯救
     */
    private void defaultValueAndCalculate(PmsWbsBudgetVO save) {
        // 处理默认值，计算剩余费用
        PmsWbsBudgetPayload updatedPayload = new PmsWbsBudgetPayload();
        updatedPayload.setId(save.getId());

        //计算 资源总预算
        BigDecimal totalResAmt = save.getTotalResAmt() == null ? BigDecimal.ZERO : save.getTotalResAmt();
        updatedPayload.setTotalResAmt(totalResAmt);
        BigDecimal totalSettledResAmt = save.getTotalSettledResAmt() == null ? BigDecimal.ZERO : save.getTotalSettledResAmt();
        updatedPayload.setTotalSettledResAmt(totalSettledResAmt);
        BigDecimal totalOccupiedResAmt = save.getTotalOccupiedResAmt() == null ? BigDecimal.ZERO : save.getTotalOccupiedResAmt();
        updatedPayload.setTotalOccupiedResAmt(totalOccupiedResAmt);
        updatedPayload.setTotalRemainingResAmt(totalResAmt.subtract(totalSettledResAmt).subtract(totalOccupiedResAmt));


        // 计算费用
        BigDecimal totalFeeAmt = save.getTotalFeeAmt() == null ? BigDecimal.ZERO : save.getTotalFeeAmt();
        updatedPayload.setTotalFeeAmt(totalFeeAmt);
        BigDecimal totalSettledFeeAmt = save.getTotalSettledFeeAmt() == null ? BigDecimal.ZERO : save.getTotalSettledFeeAmt();
        updatedPayload.setTotalSettledFeeAmt(totalSettledFeeAmt);
        BigDecimal totalOccupiedFeeAmt = save.getTotalOccupiedFeeAmt() == null ? BigDecimal.ZERO : save.getTotalOccupiedFeeAmt();
        updatedPayload.setTotalOccupiedFeeAmt(totalOccupiedFeeAmt);
        updatedPayload.setTotalRemainingFeeAmt(totalFeeAmt.subtract(totalSettledFeeAmt).subtract(totalOccupiedFeeAmt));
        // 保存数据
        dao.updateByKeyDynamic(updatedPayload);
    }

    @Override
    @Transactional
    public PmsWbsBudgetVO update(PmsWbsBudgetPayload payload) {
        Assert.notNull(payload.getId(), "id不能为空");
        // 检查数据局
        checkData(payload);
        // 保存数据
        PmsWbsBudgetVO save = dao.save(payload);
        // 处理默认值，计算剩余费用
        defaultValueAndCalculate(save);
        return queryByKey(save.getId());
    }

    @Override
    @Transactional
    public PmsWbsBudgetVO updateDynamic(PmsWbsBudgetPayload payload) {
        Assert.notNull(payload.getId(), "id不能为空");
        // 检查数据局
        checkData(payload);
        // 保存数据
        dao.updateByKeyDynamic(payload);
        PmsWbsBudgetVO pmsWbsBudgetVO = queryByKey(payload.getId());
        // 处理默认值，计算剩余费用
        defaultValueAndCalculate(pmsWbsBudgetVO);
        return pmsWbsBudgetVO;
    }

    @Override
    @Transactional
    public Long deleteSoft(List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            throw  TwException.error("","ids参数不能为空");
        }
        return dao.deleteSoft(ids);
    }

    @Override
    @Transactional
    public List<PmsWbsBudgetVO> insertAll(List<PmsWbsBudgetPayload> newBudgetList) {
        List<PmsWbsBudgetVO> list = new ArrayList<>();
        if (!CollectionUtils.isEmpty(newBudgetList)) {
            newBudgetList.forEach(item -> {
                PmsWbsBudgetVO wbsBudgetVO = insert(item);
                list.add(wbsBudgetVO);
            });
        }
        return list;
    }

    @Override
    public PmsWbsBudgetVO getByProIdAndVersionId(Long proId, Long versionId) {
        Assert.notNull(proId, "proId不能为空");
        Assert.notNull(versionId, "versionId不能为空");
        PmsWbsBudgetVersionVO versionVO = pmsWbsBudgetVersionService.queryByKey(versionId);
        PmsWbsBudgetVO wbsBudgetCurrentVO = dao.getByProIdAndVersionId(proId, versionId);


        // 获取上个版本
        Integer versionNo = versionVO.getVersionNo();
        if (null != versionVO && versionNo > 0) {
            int lastVersionNo = versionNo - 1;
            PmsWbsBudgetVersionVO lastVersionVO = pmsWbsBudgetVersionService.getProIdAndVersionNo(proId, lastVersionNo);
            PmsWbsBudgetVO wbsBudgetLastVO = dao.getByProIdAndVersionId(proId, lastVersionVO.getId());
            wbsBudgetCurrentVO.setLastBudget(wbsBudgetLastVO);
        }
        // 获取 V0版本
        PmsWbsBudgetVersionVO zerotVersionVO = pmsWbsBudgetVersionService.getProIdAndVersionNo(proId, 0);
        PmsWbsBudgetVO wbsBudgetZeroVO = dao.getByProIdAndVersionId(proId, zerotVersionVO.getId());
        wbsBudgetCurrentVO.setZeroBudget(wbsBudgetZeroVO);
        return wbsBudgetCurrentVO;
    }

    @Override
    @Transactional
    public BigDecimal updateByResPlan(Long proId, Long budgetId) {
        PersonPlanVO resPlan = personPlanService.getByProId(proId);
        if (null == resPlan) {
            return BigDecimal.ZERO;
        }
        List<PersonPlanDtlVO> personPlanDtlVOList = resPlan.getPersonPlanDtlVOList();
        // personPlanDtlVOList  中amt 合计
        BigDecimal totalResAmt = personPlanDtlVOList.stream().map(PersonPlanDtlVO::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add);

        // // 更新到预算主表中
        // PmsWbsBudgetPayload budgetPayload = new PmsWbsBudgetPayload();
        // budgetPayload.setId(budgetId);
        // budgetPayload.setTotalResAmt(totalResAmt);
        // PmsWbsBudgetVO pmsWbsBudgetVO = updateDynamic(budgetPayload);
        return totalResAmt;
    }


    /**
     * 发起工作流
     * @param payload payload
     * @return result
     */
//     private Long startWorkFlow(PmsWbsBudgetPayload payload) {
//         // 发起工作流程
//         HashMap<String, Object> varMaps = new HashMap<>();
//         Assert.notNull(payload.getUserId(), "userId不能为空");
//         // 变更资源审批
//         varMaps.put("Activity_111kevq", payload.getUserId());
//         //发起流程审批
// //        ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
// //                HrBaseEnum.BASE_BU_CHANGE.getCode(),
// //                HrBaseEnum.BASE_BU_CHANGE.getDesc(),
// //                res.getId().toString(), varMaps));
// //        String procInstId = processInfo.getProcInstId();
// //        ProcInstStatus procInstStatus = processInfo.getProcInstStatus();
//         String procInstId = "";
//         // 回写单据的工作流信息
// //        payload.setProcInstId(procInstId);
// //        payload.setProcInstStatus("");
//         Long update = dao.updateByKeyDynamic(payload);
//         return update;
//     }

    /**
     * 数据校验
     *
     * @param payload payload
     */
    private void checkData(PmsWbsBudgetPayload payload) {
    }

    /**
     * todo
     *
     * @param vos vos
     */
    private void translate(List<PmsWbsBudgetVO> vos) {
        vos.forEach(vo -> {
            // todo 翻译vo对象
//            vo.setUserIdDesc("");
        });
    }

}
