package com.elitesland.tw.tw5.server.prd.pms.common.functionEnum;

import lombok.Getter;

/**
 * 预算状态
 */
public enum BudgetStatusEnum {

    CREATE("1", "新建"),
    APPROVING("2", "审批中"),
    APPROVING_EJECTED("3", "驳回"),
    APPROVED("4", "激活（已审批）"),
    CLOSED("9", "关闭"),

    ;

    @Getter
    private final String code;

    /**
     * 描述
     */
    @Getter
    private final String desc;

    BudgetStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static BudgetStatusEnum getByCode(String code) {
        for (BudgetStatusEnum value : BudgetStatusEnum.values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }

}
