package com.elitesland.tw.tw5.server.prd.pms.common.functionEnum;

import lombok.Getter;

/**
 * 项目wbs状态枚举
 *
 * @author carl
 */
public enum ProjectWbsTypeEnum {

    WBS("WBS", "WBS"),
    ACT("ACT", "活动"),
    NET("NET", "网络"),
    MS("MS", "里程碑"),
    ACTG("ACTG", "阶段"),
    ;

    @Getter
    private final String code;

    /**
     * 描述
     */
    @Getter
    private final String desc;

    ProjectWbsTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ProjectWbsTypeEnum getByCode(String code) {
        for (ProjectWbsTypeEnum value : ProjectWbsTypeEnum.values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }
}
