package com.elitesland.tw.tw5.server.prd.pms.controller;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsBudgetPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsBudgetDetailQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsBudgetDetailService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsBudgetDetailVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 预算明细
 *
 * @author xxb
 * @date 2023-07-10
 */
@Api(tags = "预算明细")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/pms/pmsBudgetDetail")
@Slf4j
public class PmsBudgetDetailController {

    private final PmsBudgetDetailService pmsBudgetDetailService;

    /**
     * 通过项目id查询
     *
     * @param projectId 项目id
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/queryByProjectId")
    @ApiOperation("通过项目id查询")
    public TwOutputUtil queryByProjectId(Long projectId) {
        return TwOutputUtil.ok(pmsBudgetDetailService.queryByProject(projectId));
    }

    /**
     * 根据wbsId 查询相应 预算信息
     *
     * @param wbsId 节点主键id
     * @return result
     */
    @GetMapping ("/queryByWbs")
    @ApiOperation("根据wbsId查询相应预算信息")
    public TwOutputUtil queryByWbs(Long projectId,Long wbsId) {
        return TwOutputUtil.ok(pmsBudgetDetailService.queryByWbs(projectId,wbsId));
    }

    /**
     * 根据wbsId 查询相应 预算信息
     *
     * @param projectId 项目id
     * @return result
     */
    @GetMapping ("/queryBudgetStatus")
    @ApiOperation("根据wbsId查询相应预算状态")
    public TwOutputUtil queryBudgetStatus(Long projectId,Long wbsId) {
        return TwOutputUtil.ok(pmsBudgetDetailService.queryProjectBudgetStatus(projectId,wbsId));
    }

    /**
     * 提交预算审批
     *
     * @param projectId
     * @return
     */
    @GetMapping("/submitByProjectId")
    @ApiOperation("提交预算审批")
    public TwOutputUtil submitApprovalProcess(Long projectId) {
        pmsBudgetDetailService.submitApprovalProcess(projectId);
        return TwOutputUtil.ok();
    }

    /**
     * 预算明细-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("预算明细-新增")
    public TwOutputUtil<PmsBudgetDetailVO> insert(@RequestBody PmsBudgetPayload payload) {
        pmsBudgetDetailService.insert(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 预算明细-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("预算明细-主键查询")
    public TwOutputUtil<PmsBudgetDetailVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(pmsBudgetDetailService.queryByKey(key));
    }

    /**
     * 预算明细-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("预算明细-分页")
    public TwOutputUtil<PagingVO<PmsBudgetDetailVO>> paging(PmsBudgetDetailQuery query) {
        return TwOutputUtil.ok(pmsBudgetDetailService.queryPaging(query));
    }

    /**
     * 预算明细-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("预算明细-查询列表")
    public TwOutputUtil<List<PmsBudgetDetailVO>> queryList(PmsBudgetDetailQuery query) {
        return TwOutputUtil.ok(pmsBudgetDetailService.queryListDynamic(query));
    }

    /**
     * 预算明细-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("预算明细-删除")
    public TwOutputUtil deleteSoft(Long budgetId, Long[] keys) {
        pmsBudgetDetailService.deleteSoft(budgetId, Arrays.asList(keys));
        return TwOutputUtil.ok();
    }


}
