package com.elitesland.tw.tw5.server.prd.pms.controller;

import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectCalendarPayload;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectCalendarService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 项目工作日历
 * @date 2023-06-21
 */
@Api(tags = "项目工作日历")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/pms/projectCalendar")
@Slf4j
public class PmsProjectCalendarController {

    private final PmsProjectCalendarService calendarService;

    /**
     * 新增工作日历
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("新增工作日历")
    public TwOutputUtil insert(@RequestBody PmsProjectCalendarPayload payload){
        calendarService.saveData(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 更新工作日历
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("更新工作日历")
    public TwOutputUtil update(@RequestBody PmsProjectCalendarPayload payload){
        if (ObjectUtils.isEmpty(payload.getId())) {
            throw TwException.error("", "主键不存在，请核验！");
        }
        calendarService.saveData(payload);
        return TwOutputUtil.ok();
    }


    /**
     * 查看工作日历
     * @return
     */
    @PostMapping ("/getCarryoverInformation")
    @ApiOperation("查看工作日历")
    public TwOutputUtil getCarryoverInformation(@RequestBody PmsProjectCalendarPayload payload) {
        return TwOutputUtil.ok(calendarService.findBySource(payload));
    }

    /**
     * 恢复默认日历
     *
     * @param keys 主键id
     * @return result
     */
    @GetMapping ("/restoreDefault")
    @ApiOperation("恢复默认日历")
    public TwOutputUtil deleteSoft(Long[] keys) {
        calendarService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
