package com.elitesland.tw.tw5.server.prd.pms.controller;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsRelyTempPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsRelyTempQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsRelyTempVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.pms.service.inf.PmsProjectWbsRelyTempService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 项目wbs前置依赖关系模板
 *
 * @author wangxl
 * @date 2024/4/2
 */
@RestController
@RequestMapping("pms/pmsProjectWbsRelyTemp")
@RequiredArgsConstructor
@Slf4j
@Api(value = "项目wbs前置依赖关系模板", tags = {"项目wbs前置依赖关系模板"})
public class PmsProjectWbsRelyTempController {

    private final PmsProjectWbsRelyTempService service;

    @ApiOperation("分页查询")
    @GetMapping("/page")
    public TwOutputUtil<PagingVO<PmsProjectWbsRelyTempVO>> page(PmsProjectWbsRelyTempQuery query) {
        return service.queryPage(query);
    }

    @ApiOperation("列表查询")
    @GetMapping("/list")
    public TwOutputUtil<List<PmsProjectWbsRelyTempVO>> list(PmsProjectWbsRelyTempQuery query) {
        return service.queryList(query);
    }

    @ApiOperation("主键查询")
    @GetMapping("/key")
    public TwOutputUtil<PmsProjectWbsRelyTempVO> queryByKey(Long id) {
        return service.queryByKey(id);
    }

    @ApiOperation("新增")
    @PostMapping("/insert")
    // @DuplicateSubmissionPrevention
    public TwOutputUtil<PmsProjectWbsRelyTempVO> insert(@RequestBody PmsProjectWbsRelyTempPayload payload) {
        // 关键日志打印
        log.debug("【PmsProjectWbsRelyTempController.insert】入参：" + payload.toString());
        return service.insert(payload);
    }

    @ApiOperation("修改")
    @PostMapping("/update")
    public TwOutputUtil<PmsProjectWbsRelyTempVO> update(@RequestBody PmsProjectWbsRelyTempPayload payload) {
        // 关键日志打印
        log.debug("【PmsProjectWbsRelyTempController.update】入参：" + payload.toString());
        return service.update(payload);
    }

    @ApiOperation("动态修改")
    @PostMapping("/updateDynamic")
    public TwOutputUtil<PmsProjectWbsRelyTempVO> updateDynamic(@RequestBody PmsProjectWbsRelyTempPayload payload) {
        // 关键日志打印
        log.debug("【PmsProjectWbsRelyTempController.updateDynamic】入参：" + payload.toString());
        return service.updateDynamic(payload);
    }

    @ApiOperation("删除")
    @PostMapping("/deleteSoft")
    public TwOutputUtil<Long> deleteSoft(@RequestBody List<Long> ids) {
        log.debug("【PmsProjectWbsRelyTempController.deleteSoft】入参：" + ids);
        return service.deleteSoft(ids);
    }
}