package com.elitesland.tw.tw5.server.prd.pms.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsWbsVersionPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsWbsVersionQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsWbsVersionService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsWbsVersionVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * pms版本表
 *
 * @author wangxl
 * @date 2024/3/4
 */
@RestController
@RequestMapping("/api/pms/pmsWbsVersion")
@RequiredArgsConstructor
@Slf4j
@Api(value = "pms版本表", tags = {"pms版本表"})
public class PmsWbsVersionController {

    private final PmsWbsVersionService service;

    @ApiOperation("分页查询")
    @GetMapping("/page")
    public TwOutputUtil<PagingVO<PmsWbsVersionVO>> page(PmsWbsVersionQuery query) {
        PagingVO<PmsWbsVersionVO> pagingVO = service.queryPage(query);
        return TwOutputUtil.ok(pagingVO);
    }

    @ApiOperation("列表查询")
    @GetMapping("/list")
    public TwOutputUtil<List<PmsWbsVersionVO>> list(PmsWbsVersionQuery query) {
        List<PmsWbsVersionVO> voList = service.queryList(query);
        return TwOutputUtil.ok(voList);
    }

    @ApiOperation("主键查询")
    @GetMapping("/key")
    public TwOutputUtil<PmsWbsVersionVO> queryByKey(Long id) {
        PmsWbsVersionVO vo = service.queryByKey(id);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation("新增")
    @PostMapping("/insert")
//    // @DuplicateSubmissionPrevention
    public TwOutputUtil<PmsWbsVersionVO> insert(@RequestBody PmsWbsVersionPayload payload) {
        // 关键日志打印
        log.debug("【PmsWbsVersionController.insert】入参：" + payload.toString());
        PmsWbsVersionVO vo = service.insert(payload);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation("修改")
    @PostMapping("/update")
    public TwOutputUtil<PmsWbsVersionVO> update(@RequestBody PmsWbsVersionPayload payload) {
        // 关键日志打印
        log.debug("【PmsWbsVersionController.update】入参：" + payload.toString());
        PmsWbsVersionVO vo = service.update(payload);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation("动态修改")
    @PostMapping("/updateDynamic")
    public TwOutputUtil<PmsWbsVersionVO> updateDynamic(@RequestBody PmsWbsVersionPayload payload) {
        // 关键日志打印
        log.debug("【PmsWbsVersionController.updateDynamic】入参：" + payload.toString());
        PmsWbsVersionVO vo = service.updateDynamic(payload);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation("删除")
    @PostMapping("/deleteSoft")
    public TwOutputUtil<Long> deleteSoft(@RequestBody List<Long> ids) {
        log.debug("【PmsWbsVersionController.deleteSoft】入参：" + ids);
        Long res = service.deleteSoft(ids);
        return TwOutputUtil.ok(res);
    }


    @ApiOperation("获取版本号")
    @GetMapping("/getVersion")
    public TwOutputUtil<PmsWbsVersionVO> getVersion(Long proId) {
        PmsWbsVersionVO vo = service.getVersion(proId);
        return TwOutputUtil.ok(vo);
    }


    @ApiOperation("获取版本号-根据状态")
    @GetMapping("/getVersionByState")
    public TwOutputUtil<PmsWbsVersionVO> getVersionByState(Long proId, Integer state) {
        PmsWbsVersionVO vo = service.getVersionByState(proId,state);
        return TwOutputUtil.ok(vo);
    }


}