package com.elitesland.tw.tw5.server.prd.pms.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsInnerProjectApplyPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsInnerProjectApplyQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsInnerProjectApplyVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsInnerProjectApplyDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsInnerProjectApplyDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsInnerProjectApplyRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 内部项目申请
 *
 * @author carl
 * @date 2023-08-23
 */
@Repository
@RequiredArgsConstructor
public class PmsInnerProjectApplyDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final PmsInnerProjectApplyRepo repo;
    private final QPmsInnerProjectApplyDO qdo = QPmsInnerProjectApplyDO.pmsInnerProjectApplyDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PmsInnerProjectApplyVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PmsInnerProjectApplyVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 项目名称
                qdo.projName,
                // 工作类型
                qdo.workType,
                // 项目模板
                qdo.projTempId,
                // 项目id
                qdo.projId,
                // 签约公司
                qdo.ouId,
                // 币种
                qdo.currCode,
                // 预计开始日期
                qdo.startDate,
                // 预计结束日期
                qdo.endDate,
                // 申请单号
                qdo.applyNo,
                // 申请状态
                qdo.apprStatus,
                // 合同id
                qdo.contractId,
                // 申请人
                qdo.applyResId,
                // 申请日期
                qdo.applyDate,
                // 费用承担bu
                qdo.expenseBuId,
                // 交付bu
                qdo.deliBuId,
                // 交付负责人
                qdo.deliResId,
                qdo.superResId,
                // 销售负责人
                qdo.salesmanResId,
                // 项目经理
                qdo.pmResId,
                // 预计总人天
                qdo.totalDays,
                // 预计总当量
                qdo.totalEqva,
                // 当量预估单价
                qdo.eqvaPrice,
                // 费用总预算
                qdo.totalReimbursement,
                // 预算总成本
                qdo.totalCost,
                // 删除标志
                qdo.delFlag,
                //关联项目Id
                qdo.relatedProjId,
                // 关联项目编号
                qdo.relatedProjNo,
                // 产品编号
                qdo.productNo,
                // 研发补贴金额
                qdo.subsidyAmt,
                // 折旧月数
                qdo.depreciationMonths,
                // 折旧开始时间
                qdo.depreciationStartDate,
                // sow节选
                qdo.sowFiles,
                // 预算附件
                qdo.budgetFiles,
                // 流程实例ID
                qdo.procInstId,
                // 研发立项附件
                qdo.researchFiles,
                // 审批状态
                qdo.procInstStatus
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PmsInnerProjectApplyVO> getJpaQueryWhere(PmsInnerProjectApplyQuery query) {
        JPAQuery<PmsInnerProjectApplyVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(PmsInnerProjectApplyQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(PmsInnerProjectApplyQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 项目名称 精确 */
        if (!ObjectUtils.isEmpty(query.getProjName())) {
            list.add(qdo.projName.eq(query.getProjName()));
        }
        /** 工作类型 精确 */
        if (!ObjectUtils.isEmpty(query.getWorkType())) {
            list.add(qdo.workType.eq(query.getWorkType()));
        }
        /** 项目模板 精确 */
        if (!ObjectUtils.isEmpty(query.getProjTempId())) {
            list.add(qdo.projTempId.eq(query.getProjTempId()));
        }
        /** 项目id 精确 */
        if (!ObjectUtils.isEmpty(query.getProjId())) {
            list.add(qdo.projId.eq(query.getProjId()));
        }
        /** 签约公司 精确 */
        if (!ObjectUtils.isEmpty(query.getOuId())) {
            list.add(qdo.ouId.eq(query.getOuId()));
        }
        /** 币种 精确 */
        if (!ObjectUtils.isEmpty(query.getCurrCode())) {
            list.add(qdo.currCode.eq(query.getCurrCode()));
        }
        /** 预计开始日期 精确 */
        if (!ObjectUtils.isEmpty(query.getStartDate())) {
            list.add(qdo.startDate.eq(query.getStartDate()));
        }
        /** 预计结束日期 精确 */
        if (!ObjectUtils.isEmpty(query.getEndDate())) {
            list.add(qdo.endDate.eq(query.getEndDate()));
        }
        /** 申请单号 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyNo())) {
            list.add(qdo.applyNo.eq(query.getApplyNo()));
        }
        /** 申请状态 精确 */
        if (!ObjectUtils.isEmpty(query.getApprStatus())) {
            list.add(qdo.apprStatus.eq(query.getApprStatus()));
        }
        if (!ObjectUtils.isEmpty(query.getProcInstStatus())) {
            list.add(qdo.procInstStatus.eq(query.getProcInstStatus()));
        }
        /** 申请人 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyResId())) {
            list.add(qdo.applyResId.eq(query.getApplyResId()));
        }
        /** 申请日期 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyDate())) {
            list.add(qdo.applyDate.eq(query.getApplyDate()));
        }
        /** 费用承担bu 精确 */
        if (!ObjectUtils.isEmpty(query.getExpenseBuId())) {
            list.add(qdo.expenseBuId.eq(query.getExpenseBuId()));
        }
        /** 交付bu 精确 */
        if (!ObjectUtils.isEmpty(query.getDeliBuId())) {
            list.add(qdo.deliBuId.eq(query.getDeliBuId()));
        }
        /** 交付负责人 精确 */
        if (!ObjectUtils.isEmpty(query.getDeliResId())) {
            list.add(qdo.deliResId.eq(query.getDeliResId()));
        }
        /** 销售负责人 精确 */
        if (!ObjectUtils.isEmpty(query.getSalesmanResId())) {
            list.add(qdo.salesmanResId.eq(query.getSalesmanResId()));
        }
        /** 项目经理 精确 */
        if (!ObjectUtils.isEmpty(query.getPmResId())) {
            list.add(qdo.pmResId.eq(query.getPmResId()));
        }
        /** 预计总人天 精确 */
        if (!ObjectUtils.isEmpty(query.getTotalDays())) {
            list.add(qdo.totalDays.eq(query.getTotalDays()));
        }
        /** 预计总当量 精确 */
        if (!ObjectUtils.isEmpty(query.getTotalEqva())) {
            list.add(qdo.totalEqva.eq(query.getTotalEqva()));
        }
        /** 当量预估单价 精确 */
        if (!ObjectUtils.isEmpty(query.getEqvaPrice())) {
            list.add(qdo.eqvaPrice.eq(query.getEqvaPrice()));
        }
        /** 费用总预算 精确 */
        if (!ObjectUtils.isEmpty(query.getTotalReimbursement())) {
            list.add(qdo.totalReimbursement.eq(query.getTotalReimbursement()));
        }
        /** 预算总成本 精确 */
        if (!ObjectUtils.isEmpty(query.getTotalCost())) {
            list.add(qdo.totalCost.eq(query.getTotalCost()));
        }
        /** 删除标志 精确 */
        if (!ObjectUtils.isEmpty(query.getDelFlag())) {
            list.add(qdo.delFlag.eq(query.getDelFlag()));
        }
        /** 关联项目编号 精确 */
        if (!ObjectUtils.isEmpty(query.getRelatedProjNo())) {
            list.add(qdo.relatedProjNo.eq(query.getRelatedProjNo()));
        }
        /** 产品编号 精确 */
        if (!ObjectUtils.isEmpty(query.getProductNo())) {
            list.add(qdo.productNo.eq(query.getProductNo()));
        }
        /** 研发补贴金额 精确 */
        if (!ObjectUtils.isEmpty(query.getSubsidyAmt())) {
            list.add(qdo.subsidyAmt.eq(query.getSubsidyAmt()));
        }
        /** 折旧月数 精确 */
        if (!ObjectUtils.isEmpty(query.getDepreciationMonths())) {
            list.add(qdo.depreciationMonths.eq(query.getDepreciationMonths()));
        }
        /** 折旧开始时间 精确 */
        if (!ObjectUtils.isEmpty(query.getDepreciationStartDate())) {
            list.add(qdo.depreciationStartDate.eq(query.getDepreciationStartDate()));
        }
        //需要权限
        if (query.getPermissionFlag()) {
            //研发需求：#7514 2.1 内部项目申请列表 -> 除运维管理员外，所有用户仅看自己提交的数据
            list.add(qdo.applyResId.eq(query.getLoginUserId()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PmsInnerProjectApplyVO queryByKey(Long id) {
        JPAQuery<PmsInnerProjectApplyVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    public List<PmsInnerProjectApplyVO> queryListByProjId(List<Long> projIds) {
        JPAQuery<PmsInnerProjectApplyVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.projId.in(projIds));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PmsInnerProjectApplyVO> queryListDynamic(PmsInnerProjectApplyQuery query) {
        JPAQuery<PmsInnerProjectApplyVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PmsInnerProjectApplyVO> queryPaging(PmsInnerProjectApplyQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<PmsInnerProjectApplyVO> jpaQuery = getJpaQueryWhere(query);
        List<PmsInnerProjectApplyVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<PmsInnerProjectApplyVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PmsInnerProjectApplyDO save(PmsInnerProjectApplyDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<PmsInnerProjectApplyDO> saveAll(List<PmsInnerProjectApplyDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(PmsInnerProjectApplyPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 项目名称
        if (payload.getProjName() != null) {
            update.set(qdo.projName, payload.getProjName());
        }
        // 工作类型
        if (payload.getWorkType() != null) {
            update.set(qdo.workType, payload.getWorkType());
        }
        // 项目模板
        if (payload.getProjTempId() != null) {
            update.set(qdo.projTempId, payload.getProjTempId());
        }
        // 项目id
        if (payload.getProjId() != null) {
            update.set(qdo.projId, payload.getProjId());
        }
        // 签约公司
        if (payload.getOuId() != null) {
            update.set(qdo.ouId, payload.getOuId());
        }
        // 币种
        if (payload.getCurrCode() != null) {
            update.set(qdo.currCode, payload.getCurrCode());
        }
        // 预计开始日期
        if (payload.getStartDate() != null) {
            update.set(qdo.startDate, payload.getStartDate());
        }
        // 预计结束日期
        if (payload.getEndDate() != null) {
            update.set(qdo.endDate, payload.getEndDate());
        }
        // 申请单号
        if (payload.getApplyNo() != null) {
            update.set(qdo.applyNo, payload.getApplyNo());
        }
        // 申请状态
        if (payload.getApprStatus() != null) {
            update.set(qdo.apprStatus, payload.getApprStatus());
        }
        // 申请人
        if (payload.getApplyResId() != null) {
            update.set(qdo.applyResId, payload.getApplyResId());
        }
        // 申请日期
        if (payload.getApplyDate() != null) {
            update.set(qdo.applyDate, payload.getApplyDate());
        }
        // 费用承担bu
        if (payload.getExpenseBuId() != null) {
            update.set(qdo.expenseBuId, payload.getExpenseBuId());
        }
        // 交付bu
        if (payload.getDeliBuId() != null) {
            update.set(qdo.deliBuId, payload.getDeliBuId());
        }
        // 交付负责人
        if (payload.getDeliResId() != null) {
            update.set(qdo.deliResId, payload.getDeliResId());
        }
        // 销售负责人
        if (payload.getSalesmanResId() != null) {
            update.set(qdo.salesmanResId, payload.getSalesmanResId());
        }
        // 项目经理
        if (payload.getPmResId() != null) {
            update.set(qdo.pmResId, payload.getPmResId());
        }
        // 预计总人天
        if (payload.getTotalDays() != null) {
            update.set(qdo.totalDays, payload.getTotalDays());
        }
        // 预计总当量
        if (payload.getTotalEqva() != null) {
            update.set(qdo.totalEqva, payload.getTotalEqva());
        }
        // 当量预估单价
        if (payload.getEqvaPrice() != null) {
            update.set(qdo.eqvaPrice, payload.getEqvaPrice());
        }
        // 费用总预算
        if (payload.getTotalReimbursement() != null) {
            update.set(qdo.totalReimbursement, payload.getTotalReimbursement());
        }
        // 预算总成本
        if (payload.getTotalCost() != null) {
            update.set(qdo.totalCost, payload.getTotalCost());
        }
        // 删除标志
        if (payload.getDelFlag() != null) {
            update.set(qdo.delFlag, payload.getDelFlag());
        }
        // 关联项目编号
        if (payload.getRelatedProjNo() != null) {
            update.set(qdo.relatedProjNo, payload.getRelatedProjNo());
        }
        // 产品编号
        if (payload.getProductNo() != null) {
            update.set(qdo.productNo, payload.getProductNo());
        }
        // 研发补贴金额
        if (payload.getSubsidyAmt() != null) {
            update.set(qdo.subsidyAmt, payload.getSubsidyAmt());
        }
        // 折旧月数
        if (payload.getDepreciationMonths() != null) {
            update.set(qdo.depreciationMonths, payload.getDepreciationMonths());
        }
        // 折旧开始时间
        if (payload.getDepreciationStartDate() != null) {
            update.set(qdo.depreciationStartDate, payload.getDepreciationStartDate());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 项目名称
            if (nullFields.contains("projName")) {
                update.setNull(qdo.projName);
            }
            // 工作类型
            if (nullFields.contains("workType")) {
                update.setNull(qdo.workType);
            }
            // 项目模板
            if (nullFields.contains("projTempId")) {
                update.setNull(qdo.projTempId);
            }
            // 项目id
            if (nullFields.contains("projId")) {
                update.setNull(qdo.projId);
            }
            // 签约公司
            if (nullFields.contains("ouId")) {
                update.setNull(qdo.ouId);
            }
            // 币种
            if (nullFields.contains("currCode")) {
                update.setNull(qdo.currCode);
            }
            // 预计开始日期
            if (nullFields.contains("startDate")) {
                update.setNull(qdo.startDate);
            }
            // 预计结束日期
            if (nullFields.contains("endDate")) {
                update.setNull(qdo.endDate);
            }
            // 申请单号
            if (nullFields.contains("applyNo")) {
                update.setNull(qdo.applyNo);
            }
            // 申请状态
            if (nullFields.contains("apprStatus")) {
                update.setNull(qdo.apprStatus);
            }
            // 申请人
            if (nullFields.contains("applyResId")) {
                update.setNull(qdo.applyResId);
            }
            // 申请日期
            if (nullFields.contains("applyDate")) {
                update.setNull(qdo.applyDate);
            }
            // 费用承担bu
            if (nullFields.contains("expenseBuId")) {
                update.setNull(qdo.expenseBuId);
            }
            // 交付bu
            if (nullFields.contains("deliBuId")) {
                update.setNull(qdo.deliBuId);
            }
            // 交付负责人
            if (nullFields.contains("deliResId")) {
                update.setNull(qdo.deliResId);
            }
            // 销售负责人
            if (nullFields.contains("salesmanResId")) {
                update.setNull(qdo.salesmanResId);
            }
            // 项目经理
            if (nullFields.contains("pmResId")) {
                update.setNull(qdo.pmResId);
            }
            // 预计总人天
            if (nullFields.contains("totalDays")) {
                update.setNull(qdo.totalDays);
            }
            // 预计总当量
            if (nullFields.contains("totalEqva")) {
                update.setNull(qdo.totalEqva);
            }
            // 当量预估单价
            if (nullFields.contains("eqvaPrice")) {
                update.setNull(qdo.eqvaPrice);
            }
            // 费用总预算
            if (nullFields.contains("totalReimbursement")) {
                update.setNull(qdo.totalReimbursement);
            }
            // 预算总成本
            if (nullFields.contains("totalCost")) {
                update.setNull(qdo.totalCost);
            }
            // 删除标志
            if (nullFields.contains("delFlag")) {
                update.setNull(qdo.delFlag);
            }
            // 关联项目编号
            if (nullFields.contains("relatedProjNo")) {
                update.setNull(qdo.relatedProjNo);
            }
            // 产品编号
            if (nullFields.contains("productNo")) {
                update.setNull(qdo.productNo);
            }
            // 研发补贴金额
            if (nullFields.contains("subsidyAmt")) {
                update.setNull(qdo.subsidyAmt);
            }
            // 折旧月数
            if (nullFields.contains("depreciationMonths")) {
                update.setNull(qdo.depreciationMonths);
            }
            // 折旧开始时间
            if (nullFields.contains("depreciationStartDate")) {
                update.setNull(qdo.depreciationStartDate);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * @param payload 修改结项报告
     * @return 修改的行数
     */
    @Transactional
    public long updateWorkFlow(PmsInnerProjectApplyPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        if (payload.getApprStatus() != null) {
            update.set(qdo.apprStatus, payload.getApprStatus());
        }
        if (payload.getProcInstStatus() != null) {
            update.set(qdo.procInstStatus, payload.getProcInstStatus());
        }
        if (payload.getSubmitTime() != null) {
            update.set(qdo.submitTime, payload.getSubmitTime());
        }
        if (payload.getApprovedTime() != null) {
            update.set(qdo.approvedTime, payload.getApprovedTime());
        }
        if (payload.getDeleteFlag() != null) {
            update.set(qdo.deleteFlag, payload.getDeleteFlag());
        }
        if (payload.getProcInstId() != null) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            if (nullFields.contains("procInstStatus")) {
                update.setNull(qdo.procInstStatus);
            }
            if (nullFields.contains("procInstId")) {
                update.setNull(qdo.procInstId);
            }
        }
        // 执行修改
        return update.execute();
    }


    /**
     * 添加项目id
     *
     * @param
     * @return 修改的行数
     */
    @Transactional
    public long addProjId(long id, long projId) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(id));
        update.set(qdo.projId, projId);
        // 执行修改
        return update.execute();
    }

    /**
     * 添加合同id
     *
     * @param
     * @return 修改的行数
     */
    @Transactional
    public long addContractId(long id, long contractId) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(id));
        update.set(qdo.contractId, contractId);
        // 执行修改
        return update.execute();
    }

}

