package com.elitesland.tw.tw5.server.prd.pms.dao;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsAcceptPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsAcceptQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsAcceptVO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectWbsAcceptDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectWbsAcceptDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectWbsDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;


/**
 * @author : WWW
 * @date : 2024-2-26
 * @desc : 项目wbs验收标准RepoProc
 */
@Component
public class PmsProjectWbsAcceptDao extends BaseRepoProc<PmsProjectWbsAcceptDO> {

    private static final QPmsProjectWbsAcceptDO qPmsProjectWbsAcceptDO = QPmsProjectWbsAcceptDO.pmsProjectWbsAcceptDO;
    private static final QPmsProjectWbsDO qPmsProjectWbsDO = QPmsProjectWbsDO.pmsProjectWbsDO;


    protected PmsProjectWbsAcceptDao() {

        super(qPmsProjectWbsAcceptDO);

    }


    public PagingVO<PmsProjectWbsAcceptVO> page(PmsProjectWbsAcceptQuery pmsProjectWbsAcceptQuery) {

        JPAQuery<PmsProjectWbsAcceptVO> query =
                select(PmsProjectWbsAcceptVO.class)
                        .where(bulidPredicate(pmsProjectWbsAcceptQuery));
        pmsProjectWbsAcceptQuery.setPaging(query);
        pmsProjectWbsAcceptQuery.fillOrders(query, qPmsProjectWbsAcceptDO);
        return PagingVO.<PmsProjectWbsAcceptVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }


    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(qPmsProjectWbsAcceptDO)
                .set(qPmsProjectWbsAcceptDO.deleteFlag, 1)
                .where(qPmsProjectWbsAcceptDO.id.in(ids))
                .execute();

        return res;

    }


    public PmsProjectWbsAcceptVO get(Long id) {

        PmsProjectWbsAcceptVO pmsProjectWbsAcceptVO = select(PmsProjectWbsAcceptVO.class)
                .where(qPmsProjectWbsAcceptDO.id.eq(id))
                .fetchOne();

        return pmsProjectWbsAcceptVO;

    }


    public List<PmsProjectWbsAcceptVO> getList(PmsProjectWbsAcceptQuery pmsProjectWbsAcceptQuery) {

        List<PmsProjectWbsAcceptVO> res =
                select(PmsProjectWbsAcceptVO.class)
                        .where(bulidPredicate(pmsProjectWbsAcceptQuery))
                        .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                        qPmsProjectWbsAcceptDO.wbsId,
                        qPmsProjectWbsAcceptDO.projectId,
                        qPmsProjectWbsAcceptDO.type,
                        qPmsProjectWbsAcceptDO.content,
                        qPmsProjectWbsAcceptDO.managerUserId,
                        qPmsProjectWbsAcceptDO.remindDay,
                        qPmsProjectWbsAcceptDO.remindChannel,
                        qPmsProjectWbsAcceptDO.id,
                        qPmsProjectWbsAcceptDO.createTime,
                        qPmsProjectWbsAcceptDO.remark,
                        qPmsProjectWbsAcceptDO.effRelateId,
                        qPmsProjectWbsAcceptDO.wbsCode,
                        qPmsProjectWbsAcceptDO.completeContent,
                        qPmsProjectWbsAcceptDO.acceptanceStatus,
                        qPmsProjectWbsAcceptDO.acceptanceInstructions

                )).from(qPmsProjectWbsAcceptDO);

    }

    public List<PmsProjectWbsAcceptVO> listByContent(List<String> contents) {
        if (!CollectionUtils.isEmpty(contents)) {
            List<PmsProjectWbsAcceptVO> res = jpaQueryFactory.select(Projections.bean(PmsProjectWbsAcceptVO.class,
                    qPmsProjectWbsDO.wbsName.as("wbsName"),

                    qPmsProjectWbsAcceptDO.wbsId,
                    qPmsProjectWbsAcceptDO.projectId,
                    qPmsProjectWbsAcceptDO.type,
                    qPmsProjectWbsAcceptDO.content,
                    qPmsProjectWbsAcceptDO.managerUserId,
                    qPmsProjectWbsAcceptDO.remindDay,
                    qPmsProjectWbsAcceptDO.remindChannel,
                    qPmsProjectWbsAcceptDO.id,
                    qPmsProjectWbsAcceptDO.createTime,
                    qPmsProjectWbsAcceptDO.remark,
                    qPmsProjectWbsAcceptDO.effRelateId,
                    qPmsProjectWbsAcceptDO.wbsCode,
                    qPmsProjectWbsAcceptDO.completeContent,
                    qPmsProjectWbsAcceptDO.acceptanceStatus,
                    qPmsProjectWbsAcceptDO.versionNo,
                    qPmsProjectWbsAcceptDO.versionId,
                    qPmsProjectWbsAcceptDO.acceptanceInstructions

                )).from(qPmsProjectWbsAcceptDO)
                .leftJoin(qPmsProjectWbsDO)
                .on(qPmsProjectWbsAcceptDO.wbsId.eq(qPmsProjectWbsDO.id))
                .where(
                    qPmsProjectWbsAcceptDO.type.eq(0)
                        .and(qPmsProjectWbsAcceptDO.content.in(contents))
                )
                .fetch();
            return res;
        }
        return Collections.emptyList();
    }


    private Predicate bulidPredicate(PmsProjectWbsAcceptQuery pmsProjectWbsAcceptQuery) {

        Predicate predicate = PredicateBuilder.builder()
                .andEq(null != pmsProjectWbsAcceptQuery.getWbsId(), qPmsProjectWbsAcceptDO.wbsId, pmsProjectWbsAcceptQuery.getWbsId())
                .andIn(ObjectUtils.isNotEmpty(pmsProjectWbsAcceptQuery.getWbsIdList()), qPmsProjectWbsAcceptDO.wbsId, pmsProjectWbsAcceptQuery.getWbsIdList())
                .andEq(null != pmsProjectWbsAcceptQuery.getProjectId(), qPmsProjectWbsAcceptDO.projectId, pmsProjectWbsAcceptQuery.getProjectId())
                .andEq(null != pmsProjectWbsAcceptQuery.getType(), qPmsProjectWbsAcceptDO.type, pmsProjectWbsAcceptQuery.getType())
                .andEq(StringUtils.isNotBlank(pmsProjectWbsAcceptQuery.getContent()), qPmsProjectWbsAcceptDO.content, pmsProjectWbsAcceptQuery.getContent())
                .andEq(null != pmsProjectWbsAcceptQuery.getManagerUserId(), qPmsProjectWbsAcceptDO.managerUserId, pmsProjectWbsAcceptQuery.getManagerUserId())
                .andEq(null != pmsProjectWbsAcceptQuery.getRemindDay(), qPmsProjectWbsAcceptDO.remindDay, pmsProjectWbsAcceptQuery.getRemindDay())
                .andEq(null != pmsProjectWbsAcceptQuery.getRemindChannel(), qPmsProjectWbsAcceptDO.remindChannel, pmsProjectWbsAcceptQuery.getRemindChannel())
                .andEq(null != pmsProjectWbsAcceptQuery.getVersionNo(), qPmsProjectWbsAcceptDO.versionNo, pmsProjectWbsAcceptQuery.getVersionNo())
                .andEq(null != pmsProjectWbsAcceptQuery.getCompleteContent(), qPmsProjectWbsAcceptDO.completeContent, pmsProjectWbsAcceptQuery.getCompleteContent())
                .andEq(null != pmsProjectWbsAcceptQuery.getAcceptanceStatus(), qPmsProjectWbsAcceptDO.acceptanceStatus, pmsProjectWbsAcceptQuery.getAcceptanceStatus())
                .andEq(null != pmsProjectWbsAcceptQuery.getAcceptanceInstructions(), qPmsProjectWbsAcceptDO.acceptanceInstructions, pmsProjectWbsAcceptQuery.getAcceptanceInstructions())
                .build();

        return predicate;

    }


    private Predicate bulidPredicates(PmsProjectWbsAcceptQuery pmsProjectWbsAcceptQuery) {

        List<Predicate> predicates = new ArrayList<>();
        // wbs主键
        if (null != pmsProjectWbsAcceptQuery.getWbsId()) {
            predicates.add(qPmsProjectWbsAcceptDO.wbsId.eq(pmsProjectWbsAcceptQuery.getWbsId()));
        }
        if (ObjectUtils.isNotEmpty(pmsProjectWbsAcceptQuery.getWbsIdList())) {
            predicates.add(qPmsProjectWbsAcceptDO.wbsId.in(pmsProjectWbsAcceptQuery.getWbsIdList()));
        }
        // 项目id
        if (null != pmsProjectWbsAcceptQuery.getProjectId()) {
            predicates.add(qPmsProjectWbsAcceptDO.projectId.eq(pmsProjectWbsAcceptQuery.getProjectId()));
        }
        // 验收项类型0交付项1自定义
        if (null != pmsProjectWbsAcceptQuery.getType()) {
            predicates.add(qPmsProjectWbsAcceptDO.type.eq(pmsProjectWbsAcceptQuery.getType()));
        }
        // 验收内容
        if (StringUtils.isNotEmpty(pmsProjectWbsAcceptQuery.getContent())) {
            predicates.add(qPmsProjectWbsAcceptDO.content.eq(pmsProjectWbsAcceptQuery.getContent()));
        }
        // 负责人id
        if (null != pmsProjectWbsAcceptQuery.getManagerUserId()) {
            predicates.add(qPmsProjectWbsAcceptDO.managerUserId.eq(pmsProjectWbsAcceptQuery.getManagerUserId()));
        }
        // 提醒计划前n天
        if (null != pmsProjectWbsAcceptQuery.getRemindDay()) {
            predicates.add(qPmsProjectWbsAcceptDO.remindDay.eq(pmsProjectWbsAcceptQuery.getRemindDay()));
        }
        // 提醒途径0企微1站内
        if (null != pmsProjectWbsAcceptQuery.getRemindChannel()) {
            predicates.add(qPmsProjectWbsAcceptDO.remindChannel.eq(pmsProjectWbsAcceptQuery.getRemindChannel()));
        }
        if (null != pmsProjectWbsAcceptQuery.getCompleteContent()) {
            predicates.add(qPmsProjectWbsAcceptDO.completeContent.eq(pmsProjectWbsAcceptQuery.getCompleteContent()));
        }
        if (null != pmsProjectWbsAcceptQuery.getAcceptanceStatus()) {
            predicates.add(qPmsProjectWbsAcceptDO.acceptanceStatus.eq(pmsProjectWbsAcceptQuery.getAcceptanceStatus()));
        }
        if (null != pmsProjectWbsAcceptQuery.getAcceptanceInstructions()) {
            predicates.add(qPmsProjectWbsAcceptDO.acceptanceInstructions.eq(pmsProjectWbsAcceptQuery.getAcceptanceInstructions()));
        }

        Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicate;
    }


    public Long count(PmsProjectWbsAcceptQuery pmsProjectWbsAcceptQuery) {

        long res = select(PmsProjectWbsAcceptVO.class)
                .where(bulidPredicate(pmsProjectWbsAcceptQuery))
                .fetchCount();

        return res;


    }

    public Long update(PmsProjectWbsAcceptPayload pmsProjectWbsAcceptPayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qPmsProjectWbsAcceptDO);

        // wbs主键
        if (null != pmsProjectWbsAcceptPayload.getWbsId()) {
            update.set(qPmsProjectWbsAcceptDO.wbsId, pmsProjectWbsAcceptPayload.getWbsId());
        }
        // 项目id
        if (null != pmsProjectWbsAcceptPayload.getProjectId()) {
            update.set(qPmsProjectWbsAcceptDO.projectId, pmsProjectWbsAcceptPayload.getProjectId());
        }
        // 验收项类型0交付项1自定义
        if (null != pmsProjectWbsAcceptPayload.getType()) {
            update.set(qPmsProjectWbsAcceptDO.type, pmsProjectWbsAcceptPayload.getType());
        }
        // 验收内容
        if (StringUtils.isNotEmpty(pmsProjectWbsAcceptPayload.getContent())) {
            update.set(qPmsProjectWbsAcceptDO.content, pmsProjectWbsAcceptPayload.getContent());
        }
        // 负责人id
        if (null != pmsProjectWbsAcceptPayload.getManagerUserId()) {
            update.set(qPmsProjectWbsAcceptDO.managerUserId, pmsProjectWbsAcceptPayload.getManagerUserId());
        }
        // 提醒计划前n天
        if (null != pmsProjectWbsAcceptPayload.getRemindDay()) {
            update.set(qPmsProjectWbsAcceptDO.remindDay, pmsProjectWbsAcceptPayload.getRemindDay());
        }
        // 提醒途径0企微1站内
        if (null != pmsProjectWbsAcceptPayload.getRemindChannel()) {
            update.set(qPmsProjectWbsAcceptDO.remindChannel, pmsProjectWbsAcceptPayload.getRemindChannel());
        }
        if (null != pmsProjectWbsAcceptPayload.getEffRelateId()) {
            update.set(qPmsProjectWbsAcceptDO.effRelateId, pmsProjectWbsAcceptPayload.getEffRelateId());
        }
        if (null != pmsProjectWbsAcceptPayload.getCompleteContent()) {
            update.set(qPmsProjectWbsAcceptDO.completeContent, pmsProjectWbsAcceptPayload.getCompleteContent());
        }
        if (null != pmsProjectWbsAcceptPayload.getAcceptanceStatus()) {
            update.set(qPmsProjectWbsAcceptDO.acceptanceStatus, pmsProjectWbsAcceptPayload.getAcceptanceStatus());
        }
        if (null != pmsProjectWbsAcceptPayload.getAcceptanceInstructions()) {
            update.set(qPmsProjectWbsAcceptDO.acceptanceInstructions, pmsProjectWbsAcceptPayload.getAcceptanceInstructions());
        }
        long res = update.where(qPmsProjectWbsAcceptDO.id.eq(pmsProjectWbsAcceptPayload.getId()))
                .execute();
        return res;

    }

    public void delByWbsId(List<Long> wbsId) {

        Long res = jpaQueryFactory.update(qPmsProjectWbsAcceptDO)
                .set(qPmsProjectWbsAcceptDO.deleteFlag, 1)
                .where(qPmsProjectWbsAcceptDO.wbsId.in(wbsId))
                .execute();

    }

    public void delByV0(List<Long> acceptDelIds,Long wbsId) {
        Long res = jpaQueryFactory.update(qPmsProjectWbsAcceptDO)
                .set(qPmsProjectWbsAcceptDO.deleteFlag, 1)
                .where(qPmsProjectWbsAcceptDO.id.notIn(acceptDelIds))
                .where(qPmsProjectWbsAcceptDO.versionNo.eq(0))
                .where(qPmsProjectWbsAcceptDO.wbsId.eq(wbsId))
                .execute();

    }
}

