package com.elitesland.tw.tw5.server.prd.pms.deliver.constants;

import lombok.Getter;

/**
 * 统计交付物完成情况，使用饼图根据状态区分为已完成和未完成
 * 已完成
 * 未完成中数据细分为
 * 逾期（统计当前日期以前未完成的数据）
 * 今日需完成（统计当前日期需要完成的数据）
 * 剩余（统计后面将要完成的数据）
 *
 * @author duwh
 * @date 2024/02/02
 */
public enum DeliverItemStatisticsStatusEnum {

    /**
     * 已完成
     */
    OK("OK", "已完成"),
    OVERDUE("OVERDUE", "逾期"),
    TO_BE_COMPLETED_TODAY("TO_BE_COMPLETED_TODAY", "今日需完成"),
    /**
     * 未完成
     */
    SURPLUS("SURPLUS", "剩余"),
    ;

    @Getter
    private final String code;
    @Getter
    private final String desc;

    DeliverItemStatisticsStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

}
