package com.elitesland.tw.tw5.server.prd.pms.deliver.controller;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.excel.ExcelUtil;
import com.elitesland.tw.tw5.server.prd.pms.deliver.convert.PmsDeliverItemRoleConvert;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.query.PmsDeliverItemRoleQuery;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.vo.PmsDeliverItemRoleExcelVO;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.vo.PmsDeliverItemRoleVO;
import com.elitesland.tw.tw5.server.prd.pms.deliver.service.PmsDeliverItemRoleService;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.payload.PmsDeliverItemRolePayload;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 项目/计划/交付项规则
 *
 * @author duwh
 * @date 2024/03/13
 */
@RestController
@RequestMapping("/api/pms/pmsDeliverItemRole")
@RequiredArgsConstructor
@Api(value = "交付项规则", tags = {"交付项规则"})
public class PmsDeliverItemRoleController {

    private final PmsDeliverItemRoleService pmsDeliverItemRoleService;

    @GetMapping("/downloadTemplate")
    @ApiOperation("交付项规则清单模版下载")
    public void downloadTemplate(HttpServletResponse response) {
        ClassPathResource classPathResource = new ClassPathResource("template/pmsDeliverItemTemplate.xlsx");
        try {
            InputStream fis = classPathResource.getInputStream();
            byte[] buffer = new byte[fis.available()];
            fis.read(buffer);
            fis.close();
            ServletOutputStream servletOutputStream = response.getOutputStream();
            response.setContentType("application/vnd.ms-excel");
            String fileName = "上传交付物规则清单-Excel模板-20240221";
            fileName = URLEncoder.encode(fileName, "utf-8");
            response.addHeader("Content-Disposition", "attachment;filename=\""
                + fileName + ".xlsx\"");
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(servletOutputStream);
            bufferedOutputStream.write(buffer);
            bufferedOutputStream.flush();
            servletOutputStream.close();
            bufferedOutputStream.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @PostMapping(value = "/excelImport", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    @ApiOperation("excel导入-交付项规则")
    public TwOutputUtil excelImport(MultipartFile file, Long projectId, Boolean force, HttpServletResponse response) {
        // 校验是否存在数据
        Map<String, Object> resultMap = pmsDeliverItemRoleService.excelImport(file, projectId, force, response);
        //if (resultMap.get("ok").equals("ok")) {
        //    return TwOutputUtil.ok();
        //} else if (resultMap.get("ok").equals("warn")) {
        //    return TwOutputUtil.warn("", "", resultMap);
        //} else {
        //    return TwOutputUtil.error("", "", resultMap);
        //}
        return TwOutputUtil.ok(resultMap);
    }

    @GetMapping("/excelDownload")
    @ApiOperation("交付项规则清单下载")
    public void excelDownload(PmsDeliverItemRoleQuery query, HttpServletResponse response) throws IOException {
        Assert.notNull(query.getProjectId(), "项目主键不能为空");
        List<OrderItem> taskOrderItemList = new ArrayList<>();
        taskOrderItemList.add(OrderItem.asc("createTime"));
        query.setOrders(taskOrderItemList);
        List<PmsDeliverItemRoleVO> vos = pmsDeliverItemRoleService.getList(query);
        //定义文件名称
        String sheetName = "交付项规则清单";
        //获取想要导出的数据

        List<PmsDeliverItemRoleExcelVO> resultList = PmsDeliverItemRoleConvert.INSTANCE.d2eList(vos);
        //对文件名进行固定格式编码
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        //设置请求响应内容类型
        //作用:使客户端浏览器，区分不同种类的数据，并根据不同的MIME调用浏览器内不同的程序嵌入模块来处理相应的数据。
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        //设置请求响应内容编码方式
        response.setCharacterEncoding("utf-8");
        //文件下载，指定默认名
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);

        int k = 0;
        for (PmsDeliverItemRoleExcelVO pmsDeliverItemRoleExcelPayload : resultList) {
            k++;
            pmsDeliverItemRoleExcelPayload.setNo(k);
        }

        final ExcelWriterSheetBuilder sheet = EasyExcel.write(response.getOutputStream(), PmsDeliverItemRoleExcelVO.class)
            .registerWriteHandler(new LongestMatchColumnWidthStyleStrategy())
            .sheet(sheetName);
        // 列
        ExcelUtil.excelHelper(sheet, PmsDeliverItemRoleExcelVO.class, null);
        //写入
        sheet.doWrite(resultList);
    }

    @PostMapping(value = "/updateItemByRole")
    @ApiOperation("根据交付规则更新交付项")
    public TwOutputUtil<Long> updateItemByRole(@RequestParam Long projectId) {
        long count = pmsDeliverItemRoleService.updateItemByRole(projectId);
        return TwOutputUtil.ok(count);
    }

    @GetMapping("get")
    @ApiOperation("详情-交付项规则")
    public TwOutputUtil<PmsDeliverItemRoleVO> get(Long id) {
        PmsDeliverItemRoleVO res = pmsDeliverItemRoleService.get(id);
        return TwOutputUtil.ok(res);
    }


    @PostMapping("save")
    @ApiOperation("新增-交付项规则")
    public TwOutputUtil<Long> save(@RequestBody PmsDeliverItemRolePayload pmsDeliverItemRolePayload) {
        PmsDeliverItemRoleVO res = pmsDeliverItemRoleService.save(pmsDeliverItemRolePayload);
        return TwOutputUtil.ok(res.getId());
    }


    @PostMapping("update")
    @ApiOperation("修改-交付项规则")
    public TwOutputUtil<Long> update(@RequestBody PmsDeliverItemRolePayload pmsDeliverItemRolePayload) {
        Long res = pmsDeliverItemRoleService.update(pmsDeliverItemRolePayload);
        return TwOutputUtil.ok(res);
    }

    @PostMapping("updateNoShowFlag")
    @ApiOperation("修改裁剪状态-交付项规则")
    public TwOutputUtil<Long> updateNoShowFlag(@RequestBody PmsDeliverItemRolePayload pmsDeliverItemRolePayload) {
        Long res = pmsDeliverItemRoleService.updateNoShowFlag(pmsDeliverItemRolePayload);
        return TwOutputUtil.ok(res);
    }

    @PostMapping("updateNoShowFlagList")
    @ApiOperation("批量修改裁剪状态-交付项规则")
    public TwOutputUtil<Long> updateNoShowFlagList(@RequestBody List<PmsDeliverItemRolePayload> list) {
        Long res = pmsDeliverItemRoleService.updateNoShowFlagList(list);
        return TwOutputUtil.ok(res);
    }


    @PostMapping("del")
    @ApiOperation("删除-交付项规则")
    public TwOutputUtil<Long> del(@RequestBody List<Long> ids) {
        Long res = pmsDeliverItemRoleService.del(ids);
        return TwOutputUtil.ok(res);
    }

    @GetMapping("countByProjectId")
    @ApiOperation("根据项目主键统计个数-交付项规则")
    public TwOutputUtil<Long> countByProjectId(@RequestParam Long projectId) {
        PmsDeliverItemRoleQuery pmsDeliverItemRoleQuery = new PmsDeliverItemRoleQuery();
        pmsDeliverItemRoleQuery.setProjectId(projectId);
        long count = pmsDeliverItemRoleService.count(pmsDeliverItemRoleQuery);
        return TwOutputUtil.ok(count);
    }

    @GetMapping("count")
    @ApiOperation("统计个数-交付项规则")
    public TwOutputUtil<Long> count(PmsDeliverItemRoleQuery pmsDeliverItemRoleQuery) {
        long count = pmsDeliverItemRoleService.count(pmsDeliverItemRoleQuery);
        return TwOutputUtil.ok(count);
    }

    @GetMapping("page")
    // @UdcNameClass
    @ApiOperation("分页查询-交付项规则")
    public TwOutputUtil<PagingVO<PmsDeliverItemRoleVO>> page(PmsDeliverItemRoleQuery pmsDeliverItemRoleQuery) {
        Assert.notNull(pmsDeliverItemRoleQuery.getProjectId(), "项目主键不能为空");
        PagingVO<PmsDeliverItemRoleVO> res = pmsDeliverItemRoleService.page(pmsDeliverItemRoleQuery);
        return TwOutputUtil.ok(res);
    }

    @GetMapping("getList")
    @ApiOperation("列表查询-交付项规则")
    public TwOutputUtil<List<PmsDeliverItemRoleVO>> getList(PmsDeliverItemRoleQuery pmsDeliverItemRoleQuery) {
        Assert.notNull(pmsDeliverItemRoleQuery.getProjectId(), "项目主键不能为空");
        List<PmsDeliverItemRoleVO> res = pmsDeliverItemRoleService.getList(pmsDeliverItemRoleQuery);
        return TwOutputUtil.ok(res);
    }


}

