package com.elitesland.tw.tw5.server.prd.pms.deliver.model.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
  * @author : duwh
  * @date : 2024-2-27
  * @desc : 交付项规则
  */
@Data
@ApiModel(description = "交付项规则")
public class PmsDeliverItemRolePayload extends TwCommonPayload {

    /**
     * 项目主键
     */
    @ApiModelProperty("项目主键")
    private Long projectId;

    /**
     * 交付项
     */
    @ApiModelProperty("交付项")
    private String name;

    /**
     * 负责人
     */
    @ApiModelProperty("负责人")
    private Long directorRelatedPartiesId;

    /**
     * 说明
     */
    @ApiModelProperty("说明")
    private String content;

    /**
     * 存储路径
     */
    @ApiModelProperty("存储路径")
    private String savePath;

    /**
     * 是否允许裁剪 0否 1是
     */
    @ApiModelProperty("是否允许裁剪 0否 1是")
    private Boolean showConfigFlag;

    /**
     * 裁剪状态 0未裁剪 1 已裁剪
     */
    @ApiModelProperty("裁剪状态 0未裁剪 1 已裁剪")
    private Boolean noShowFlag;

    /**
     * 排序字段
     */
    @ApiModelProperty("排序字段")
    private Integer sortNo;

    /**
     * 文件夹主键
     */
    @ApiModelProperty("文件夹主键")
    private String itemId;

    /**
     * 库主键
     */
    @ApiModelProperty("库主键")
    private String libraryId;

    /**
     * 创建人（相关方）主键
     */
    @ApiModelProperty("创建人（相关方）主键")
    private Long createRelatedPartiesId;

    /**
     * 创建人（相关方）名称(冗余）
     */
    @ApiModelProperty("创建人（相关方）名称(冗余）")
    private String createRelatedPartiesName;

    /**
     * 扩展字段1
     */
    @ApiModelProperty("扩展字段1")
    private String ext1;

    /**
     * 扩展字段2
     */
    @ApiModelProperty("扩展字段2")
    private String ext2;

    /**
     * 扩展字段3
     */
    @ApiModelProperty("扩展字段3")
    private String ext3;

    /**
     * 扩展字段4
     */
    @ApiModelProperty("扩展字段4")
    private String ext4;

    /**
     * 扩展字段5
     */
    @ApiModelProperty("扩展字段5")
    private String ext5;


}

