package com.elitesland.tw.tw5.server.prd.pms.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;


/**
 * 预算详细明细-科目
 *
 * @author xxb
 * @date 2023-04-24
 */
@Entity
@Table(name = "pms_budget_detail_subject", indexes = {
        @Index(name = "project_index", columnList = "project_id")
})
@org.hibernate.annotations.Table(appliesTo = "pms_budget_detail_subject", comment = "预算详细明细-科目")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsBudgetDetailSubjectDO extends BaseModel implements Serializable  {
    /** 项目id */
    @Comment("项目id")
    @Column(name = "project_id")
    private Long projectId;
    /** 科目主键 */
    @Comment("科目主键")
    @Column()
    private Long subjectId;

    public void copy(PmsBudgetDetailSubjectDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
