package com.elitesland.tw.tw5.server.prd.pms.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 项目经理任务书核对
 *
 * @author carl
 * @date 2023-09-19
 */
@Entity
@Table(name = "pms_ma_check", indexes = {
        @Index(name = "proj_index", columnList = "proj_id"),
        @Index(name = "config_index", columnList = "config_id")
})
@org.hibernate.annotations.Table(appliesTo = "pms_ma_check", comment = "项目经理任务书核对")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsMaCheckDO extends BaseModel implements Serializable {
    /**
     * 配置id
     */
    @Comment("配置id")
    @Column(name = "config_id")
    private Long configId;
    /**
     * 项目id
     */
    @Comment("项目id")
    @Column(name = "proj_id")
    private Long projId;
    /**
     * 完成标识
     */
    @Comment("完成标识")
    @Column()
    private Integer finishFlag;
    /**
     * 完成时间
     */
    @Comment("完成时间")
    @Column()
    private LocalDateTime finishTime;

    public void copy(PmsMaCheckDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
