package com.elitesland.tw.tw5.server.prd.pms.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;


/**
 * 项目结项
 *
 * @author xxb
 * @date 2023-11-27
 */
@Entity
@Table(name = "pms_project_conclusion", indexes = {
        @Index(name = "proj_index", columnList = "proj_id")
})
@org.hibernate.annotations.Table(appliesTo = "pms_project_conclusion", comment = "项目结项")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsProjectConclusionDO extends BaseModel implements Serializable {
    /**
     * 结项编号
     */
    @Comment("结项编号")
    @Column()
    private String conclusionCode;

    /**
     * 异常结项标记
     */
    @Comment("异常结项标记")
    @Column()
    private Integer abnormalFlag;
    /**
     * 结项状态
     */
    @Comment("结项状态")
    @Column()
    private String conclusionStatus;
    /**
     * 审批状态
     */
    @Comment("审批状态")
    @Column()
    private String apprStatus;
    /**
     * 流程实例ID
     */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;
    /**
     * 提交资源userid
     */
    @Comment("提交资源userid")
    @Column()
    private Long applyUserId;
    /**
     * 申请日期
     */
    @Comment("申请日期")
    @Column()
    private LocalDate applyDate;
    /**
     * 结项检查事项
     */
    @Comment("结项检查事项")
    @Column(columnDefinition = "json")
    private String conclusionCheckItems;
    /**
     * 项目id
     */
    @Comment("项目id")
    @Column(name = "proj_id")
    private Long projId;

    @Comment("节点操作详情")
    @Column(columnDefinition = "text")
    private String approvalNodeInfo;

    public void copy(PmsProjectConclusionDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
