package com.elitesland.tw.tw5.server.prd.pms.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

;

/**
 * 项目成员
 *
 * @author xxb
 * @date 2023-08-10
 */
@Entity
@Table(name = "pms_project_members", indexes = {
        @Index(name = "proj_index", columnList = "proj_id")
})
@org.hibernate.annotations.Table(appliesTo = "pms_project_members", comment = "项目成员")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsProjectMembersDO extends BaseModel implements Serializable {
    /**
     * 项目ID
     */
    @Comment("项目ID")
    @Column(name = "proj_id")
    private Long projId;
    /**
     * 角色
     */
    @Comment("角色")
    @Column()
    private String role;
    /**
     * 复合能力ID
     */
    @Comment("复合能力ID")
    @Column()
    private Long capasetLevelId;
    /**
     * 资源id
     */
    @Comment("资源id")
    @Column()
    private Long resId;
    /**
     * 预计开始日期
     */
    @Comment("预计开始日期")
    @Column()
    private LocalDate planStartDate;
    /**
     * 预计结束日期
     */
    @Comment("预计结束日期")
    @Column()
    private LocalDate planEndDate;
    /**
     * 规划当量
     */
    @Comment("规划当量")
    @Column()
    private BigDecimal planEqva;
    /**
     * 工作台默认显示
     */
    @Comment("工作台默认显示")
    @Column()
    private Integer workbenchFlag;
    /**
     * 客户结算价
     */
    @Comment("客户结算价")
    @Column()
    private BigDecimal customerPrice;

    @Comment("任务包ID")
    @Column(name = "task_package_id")
    private Long taskPackageId;

    public void copy(PmsProjectMembersDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
