package com.elitesland.tw.tw5.server.prd.pms.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.tw.tw5.api.common.annotation.FieldCreateLog;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 项目wbs表
 *
 * @author carl
 * @date 2023-04-06
 */
@Entity
@Table(name = "pms_project_wbs", indexes = {
        @Index(name = "project_index", columnList = "project_id")
})
@org.hibernate.annotations.Table(appliesTo = "pms_project_wbs", comment = "项目wbs表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsProjectWbsDO extends BaseModel implements Serializable {
    /**
     * 项目主键
     */
    @Comment("项目主键")
    @Column(name = "project_id")
    private Long projectId;
    /**
     * 父主键
     */
    @Comment("父主键")
    @Column()
    private Long parentId;
    /**
     * wbs描述（名称）
     */

    @Comment("wbs描述（名称）")
    @Column()
    private String wbsName;
    /**
     * wbs类型(WBS,NET,ACT,MS)
     */
    @FieldCreateLog(fieldName = "节点属性")
    @Comment("wbs类型(WBS,NET,ACT,MS)")
    @Column()
    private String wbsType;
    /**
     * wbs编码
     */
    @Comment("wbs编码")
    @Column()
    private String wbsCode;
    /**
     * 父节点
     */
    @Comment("父节点")
    @Column()
    private String parentWbsCode;

    /**
     * node码
     */
    @FieldCreateLog(fieldName = "节点编码")
    @Comment("node码")
    @Column()
    private String nodeCode;

    /**
     * 节点负责人
     */
    @Comment("节点负责人")
    @Column()
    private Long managerUserId;
    /**
     * 成本对象，勾选为1
     */
    @FieldCreateLog(fieldName = "成本对象")
    @Comment("成本对象，勾选为1")
    @Column(columnDefinition = "tinyint DEFAULT 0")
    private Integer subjectDist;
    /**
     * 成本类型
     */
    @FieldCreateLog(fieldName = "成本类型")
    @Comment("成本类型")
    @Column()
    private String costType;
    /**
     * 预计开始时间
     */
    @Comment("预计开始时间")
    @Column()
    private LocalDate preStartDate;
    /**
     * 预计结束时间
     */
    @Comment("预计结束时间")
    @Column()
    private LocalDate preEndDate;
    /**
     * 预计持续时间（天）
     */
    @Comment("预计持续时间（天）")
    @Column()
    private BigDecimal preDurationDay;
    /**
     * 进度(%)
     */
    @Comment("进度(%)")
    @Column()
    private BigDecimal wbsProgress;
    /**
     * 实际开始时间
     */
    @Comment("实际开始时间")
    @Column()
    private LocalDate startDate;
    /**
     * 实际结束时间
     */
    @Comment("实际结束时间")
    @Column()
    private LocalDate endDate;
    /**
     * 实际持续时间（天）
     */
    @FieldCreateLog(fieldName = "实际持续时间（天）")
    @Comment("实际持续时间（天）")
    @Column()
    private BigDecimal durationDay;
    /**
     * 最早开始时间
     */
    @Comment("最早开始时间")
    @Column()
    private LocalDate earlyStartDate;
    /**
     * 最早结束时间
     */
    @Comment("最早结束时间")
    @Column()
    private LocalDate earlyEndDate;
    /**
     * 最晚开始时间
     */
    @Comment("最晚开始时间")
    @Column()
    private LocalDate lateStartDate;
    /**
     * 最晚结束日期
     */
    @Comment("最晚结束日期")
    @Column()
    private LocalDate lateEndDate;
    /**
     * 总浮时
     */
    @Comment("总浮时")
    @Column()
    private BigDecimal totalFloat;
    /**
     * 自由浮时
     */
    @Comment("自由浮时")
    @Column()
    private BigDecimal freeFloat;
    /**
     * 延时
     */
    @Comment("延时")
    @Column()
    private BigDecimal delayLag;
    /**
     * 是否是关键节点0:否，1：是
     */
    @Comment("是否是关键节点0:否，1：是")
    @Column(columnDefinition = "tinyint DEFAULT 0")
    private Integer isKeyNode = 0;
    /**
     * 是否自动排期0：未进行，1：已排期，2：已过期
     */
    @Comment("是否自动排期0：未进行，1：已排期，2：已过期")
    @Column(columnDefinition = "tinyint DEFAULT 0")
    private Integer autoScheduling = 0;

    /**
     * 状态
     */
    @Comment("状态")
    @Column()
    private String wbsStatus;
    /**
     * 已开始状态的数据 当取消的时候 显示标志改为 true
     */
    @Comment("已开始状态的数据 当取消的时候 显示标志改为 true")
    @Column()
    private Boolean cancelShowFlag;
    /**
     * 成本计划，勾选为1
     */
    @FieldCreateLog(fieldName = "成本计划")
    @Comment("成本计划，勾选为1")
    @Column(columnDefinition = "tinyint DEFAULT 0")
    private Integer costPlan = 0;

    /**
     * 开票属性，勾选为1
     */
    @FieldCreateLog(fieldName = "开票属性")
    @Comment("开票属性，勾选为1")
    @Column(columnDefinition = "tinyint DEFAULT 0")
    private Integer invoiceAttr = 0;

    @Override
    public String toString() {
        return "PmsProjectWbsDO{" +
                "wbsName='" + wbsName + '\'' +
                ", preDurationDay=" + preDurationDay +
                ", earlyStartDate=" + earlyStartDate +
                ", earlyEndDate=" + earlyEndDate +
                ", lateStartDate=" + lateStartDate +
                ", lateEndDate=" + lateEndDate +
                ", totalFloat=" + totalFloat +
                ", freeFloat=" + freeFloat +
                ", isKeyNode=" + isKeyNode +
                ", autoScheduling=" + autoScheduling +
                '}';
    }

    /**
     * wbs权重
     */
    @Comment("wbs权重")
    @Column()
    private BigDecimal wbsWeight;

    /**
     * wbs权重设置方式
     */
    @FieldCreateLog(fieldName = "wbs权重设置方式：1为手动设置  0为系统设置")
    @Comment("wbs权重设置方式：1为手动设置  0为系统设置")
    private Integer manualSettingWeight = 0;


    /**
     * 状态
     */
    @Comment("状态 0草稿 1提交")
    @Column()
    private String state;


    /**
     * 版本
     */
    @Comment("版本")
    @Column()
    private Long versionId;


    /**
     * 版本号
     */
    @Comment("版本号")
    @Column()
    private Integer versionNo;


    @Comment("有效关联id")
    @Column
    private Long effRelateId;

    @Comment("预算释放标记 true 已释放  false 未释放（default）")
    @Column
    private Boolean releaseFlag;

    /**
     * 收款计划ID
     */
    @Comment("收款计划ID")
    @Column()
    private Long receivePlanId;

    /**
     * 拨付状态
     */
    @Comment("拨付状态")
    @Column()
    private String allocateStatus;

    @Comment("当量系数")
    @Column()
    private BigDecimal eqvaRate;

    @Comment("规划当量")
    @Column()
    private BigDecimal planEqva;

    @Comment("原始规划当量")
    @Column()
    private BigDecimal originalPlanEqva;

    @Comment("已派发当量")
    @Column()
    private BigDecimal distedEqva;

    @Comment("拨付当量")
    @Column()
    private BigDecimal allocateEqva;

    @Comment("拨付费用")
    @Column()
    private BigDecimal allocateCost;

    /**
     * 明细控制
     */
    @Comment("明细控制 ")
    @Column()
    private Boolean detailControlFlag;

    @Comment("占用当量数")
    @Column()
    private BigDecimal occupyEqva;
    @Comment("已使用当量数")
    @Column()
    private BigDecimal usedEqva;

    @Comment("使用当量占比")
    @Column()
    private BigDecimal usedEqvaProportion;

    @Comment("使用费用占比")
    @Column()
    private BigDecimal usedAmtProportion;

    public void copy(PmsProjectWbsDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
