package com.elitesland.tw.tw5.server.prd.pms.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 项目wbs前置依赖关系
 *
 * @author carl
 * @date 2023-07-19
 */
@Entity
@Table(name = "pms_project_wbs_rely", indexes = {
        @Index(name = "project_index", columnList = "project_id"),
        @Index(name = "wbs_index", columnList = "wbs_id"),
        @Index(name = "wbs_rely_index", columnList = "wbs_rely_id"),
})
@org.hibernate.annotations.Table(appliesTo = "pms_project_wbs_rely", comment = "项目wbs前置依赖关系")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsProjectWbsRelyDO extends BaseModel implements Serializable {
    /**
     * 项目主键
     */
    @Comment("项目主键")
    @Column(name = "project_id")
    private Long projectId;
    /**
     * wbs主键(依赖建立着，后置任务)
     */
    @Comment("wbs主键(依赖建立着，后置任务)")
    @Column(name = "wbs_id")
    private Long wbsId;
    /**
     * wbs名称(依赖建立着，后置任务，冗余字段)
     */
    @Comment("wbs名称(依赖建立着，后置任务，冗余字段)")
    @Column()
    private String wbsName;
    /**
     * wbs主键(依赖前置任务)
     */
    @Comment("wbs主键(依赖前置任务)")
    @Column(name = "wbs_rely_id")
    private Long wbsRelyId;
    /**
     * wbs名称(前置依赖名称，冗余字段）
     */
    @Comment("wbs名称(前置依赖名称，冗余字段）")
    @Column()
    private String wbsRelyName;
    /**
     * 前置类型（FS）
     */
    @Comment("前置类型（FS）")
    @Column()
    private String relyType;
    /**
     * 关系类型（活动ACT，里程碑：MS）
     */
    @Comment("关系类型")
    @Column()
    private String relationType;

    /**
     * 版本
     */
    @Comment("版本")
    @Column()
    private Long versionId;


    /**
     * 版本号
     */
    @Comment("版本号")
    @Column()
    private Integer versionNo;


    @Comment("有效关联id")
    @Column
    private Long effRelateId;


    @Comment("wbs编码")
    @Column
    private String wbsCode;


    public void copy(PmsProjectWbsRelyDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
