package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsBudgetDetailSubjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsBudgetDetailSubjectVO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsBudgetDetailSubjectDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsBudgetDetailSubjectDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsBudgetDetailSubjectRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * 预算详细明细-科目
 *
 * @author xxb
 * @date 2023-04-24
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsBudgetDetailSubjectServiceImpl extends BaseServiceImpl implements PmsBudgetDetailSubjectService {

    private final PmsBudgetDetailSubjectRepo pmsBudgetDetailSubjectRepo;
    private final PmsBudgetDetailSubjectDAO pmsBudgetDetailSubjectDAO;

    @Override
    public List<PmsBudgetDetailSubjectVO> queryByProjectId(Long projectId) {
        return pmsBudgetDetailSubjectDAO.queryByProjectId(projectId);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void insertBacth(Long projectId,List<Long> subjectIdList) {
        pmsBudgetDetailSubjectDAO.deleteByProjectId(projectId);
        List<PmsBudgetDetailSubjectDO> dos = new ArrayList<>();
        subjectIdList.forEach(subjectId -> {
            PmsBudgetDetailSubjectDO subjectDO = new PmsBudgetDetailSubjectDO();
            subjectDO.setProjectId(projectId);
            subjectDO.setSubjectId(subjectId);
            dos.add(subjectDO);
        });
        pmsBudgetDetailSubjectRepo.saveAll(dos);
    }

    @Override
    public long getCountByProjectAndParent(Long projectId, Long subjectParentId) {
        return pmsBudgetDetailSubjectDAO.getCountByProjectAndParent(projectId,subjectParentId);
    }


}
