package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.TaskProVO;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectActListService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsListVO;

import com.elitesland.tw.tw5.server.common.constants.ProjectWbsStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectActListDAO;
import com.elitesland.tw.tw5.server.prd.taskpro.model.query.TaskProQuery;
import com.elitesland.tw.tw5.server.prd.taskpro.service.TaskProService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.List;

/**
 * 活动清单
 *
 * @author duwh
 * @date 2024/03/05
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsProjectActListServiceImpl implements PmsProjectActListService {

    private final PmsProjectActListDAO pmsProjectActListDAO;

    @Resource
    @Lazy
    private TaskProService taskProService;

    @Override
    public PagingVO<PmsProjectWbsListVO> queryPage(PmsProjectWbsQuery query) {
        PagingVO<PmsProjectWbsListVO> page = pmsProjectActListDAO.queryPage(query);
        String wbsStatus = query.getWbsStatusPro();
        page.getRecords().forEach(item -> {
            // 已开始的活动，统计关联任务数量
            if (StringUtils.hasText(wbsStatus) && wbsStatus.equals(ProjectWbsStatusEnum.NOGIONG.getCode())) {
                // 翻译任务数量
                TaskProQuery taskProQuery = new TaskProQuery();
                taskProQuery.setWbsId(item.getId());
                Long taskCount = taskProService.count(taskProQuery);
                item.setTaskNum(taskCount);

                TaskProQuery taskProQuery2 = new TaskProQuery();
                taskProQuery2.setWbsId(item.getId());
                // 只查第一级任务
                taskProQuery2.setParentNullFlag(true);
                List<TaskProVO> taskProVOS = taskProService.queryListDynamic(taskProQuery2);
                if (!CollectionUtils.isEmpty(taskProVOS)) {
                    TaskProVO taskProVO = taskProVOS.get(0);
                    item.setTaskDirectorRelatedPartiesId(taskProVO.getDirectorRelatedPartiesId());
                    item.setTaskDirectorRelatedPartiesName(taskProVO.getDirectorRelatedPartiesName());
                }
            }
        });
        return page;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long updateWbsStatus(Long id, String wbsStatus) {
        return pmsProjectActListDAO.updateWbsStatus(id, wbsStatus);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long updateReleaseFlag(List<Long> idList) {
        return pmsProjectActListDAO.updateReleaseFlag(idList);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long updateReleaseFlagByEffRelateId(List<Long> effRelateIdList) {
        return pmsProjectActListDAO.updateReleaseFlagByEffRelateId(effRelateIdList);
    }

    @Override
    public List<PmsProjectWbsListVO> queryList(PmsProjectWbsQuery pmsProjectWbsQuery) {
        return pmsProjectActListDAO.queryListDynamic(pmsProjectWbsQuery);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long updateWbsStatusByVersionIdAndEffRelateId(Long versionId, Long effRelateId, String wbsStatus) {
        return pmsProjectActListDAO.updateWbsStatusByVersionIdAndEffRelateId(versionId,effRelateId, wbsStatus);
    }

}
