package com.elitesland.tw.tw5.server.prd.pms.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.service.ProRelatedPartiesService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.ProRelatedPartiesVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsAcceptPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsAcceptQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectWbsAcceptService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsAcceptVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsVO;
import com.elitesland.tw.tw5.server.common.constants.ProjectWbsStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectWbsAcceptConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectWbsAcceptDao;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectWbsDAO;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.payload.PmsDeliverItemPayload;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.vo.PmsDeliverItemVO;
import com.elitesland.tw.tw5.server.prd.pms.deliver.service.PmsDeliverItemService;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectWbsAcceptDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectWbsAcceptRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;


/**
 * @author : WWW
 * @date : 2024-2-26
 * @desc : 项目wbs验收标准Service
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class PmsProjectWbsAcceptServiceImpl implements PmsProjectWbsAcceptService {


    private final PmsProjectWbsAcceptDao pmsProjectWbsAcceptDao;

    private final PmsProjectWbsDAO pmsProjectWbsDAO;

    private final PmsProjectWbsAcceptRepo pmsProjectWbsAcceptRepo;

    private final ProRelatedPartiesService proRelatedPartiesService;
    private final PmsDeliverItemService pmsDeliverItemService;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsProjectWbsAcceptVO save(PmsProjectWbsAcceptPayload pmsProjectWbsAcceptPayload) {

        checkData(pmsProjectWbsAcceptPayload);
        PmsProjectWbsAcceptDO pmsProjectWbsAcceptDO = new PmsProjectWbsAcceptDO();
        pmsProjectWbsAcceptDO = PmsProjectWbsAcceptConvert.INSTANCE.p2d(pmsProjectWbsAcceptPayload);
        PmsProjectWbsAcceptDO res = pmsProjectWbsAcceptRepo.save(pmsProjectWbsAcceptDO);
        return PmsProjectWbsAcceptConvert.INSTANCE.d2v(res);

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsProjectWbsAcceptVO updateAll(PmsProjectWbsAcceptPayload pmsProjectWbsAcceptPayload) {

        Assert.notNull(pmsProjectWbsAcceptPayload.getId(), "id is null");
        PmsProjectWbsAcceptVO res = save(pmsProjectWbsAcceptPayload);
        return res;

    }


    @Override
    public PmsProjectWbsAcceptVO get(Long id) {

        if (null == id) {
            return null;
        }
        PmsProjectWbsAcceptVO res = pmsProjectWbsAcceptDao.get(id);
        return res;

    }


    @Override
    public PagingVO<PmsProjectWbsAcceptVO> page(PmsProjectWbsAcceptQuery pmsProjectWbsAcceptQuery) {
        PagingVO<PmsProjectWbsAcceptVO> res = pmsProjectWbsAcceptDao.page(pmsProjectWbsAcceptQuery);
        List<PmsProjectWbsAcceptVO> records = res.getRecords();
        translate(records);
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {

        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = pmsProjectWbsAcceptDao.del(ids);
        return res;

    }

    @Override
    public List<PmsProjectWbsAcceptVO> getList(PmsProjectWbsAcceptQuery pmsProjectWbsAcceptQuery) {

        List<PmsProjectWbsAcceptVO> res = pmsProjectWbsAcceptDao.getList(pmsProjectWbsAcceptQuery);
        translate(res);
        return res;

    }

    @Override
    public List<PmsProjectWbsAcceptVO> listByContentAndTypeEqualZero(List<String> contents) {
        List<PmsProjectWbsAcceptVO> res = pmsProjectWbsAcceptDao.listByContent(contents);
        return res;
    }

    private void translate(List<PmsProjectWbsAcceptVO> res) {
        if (!CollectionUtil.isEmpty(res)) {
            res.forEach(x -> {
                if (null != (x.getManagerUserId())) {
                    ProRelatedPartiesVO proRelatedPartiesVO = proRelatedPartiesService.get(x.getManagerUserId());
                    if (null != proRelatedPartiesVO) {
                        x.setManagerUserName(proRelatedPartiesVO.getName());
                    }
                }
                // 交付项
                if (x.getType() != null && x.getType() == 0) {
                    String content = x.getContent();
                    if (org.springframework.util.StringUtils.hasText(content)) {
                        Long deliverId = Long.valueOf(content);
                        PmsDeliverItemVO pmsDeliverItemVO = pmsDeliverItemService.get(deliverId);
                        if (null != pmsDeliverItemVO) {
                            x.setContentDesc(pmsDeliverItemVO.getName());
                            // LeafName 逗号隔开
//                            String leafName = pmsDeliverItemVO.getFileList().stream().map(file -> file.getLeafName()).collect(Collectors.joining(","));
//                            x.setCompleteContent(leafName);
//                            x.setFileList(pmsDeliverItemVO.getFileList());
                        }
                    }
                }
            });
        }
    }


    /**
     * 数据校验
     *
     * @param pmsProjectWbsAcceptPayload
     */
    private void checkData(PmsProjectWbsAcceptPayload pmsProjectWbsAcceptPayload) {

//        Assert.notEmpty(pmsProjectWbsAcceptPayload.getType(), "类型不能为空");
        Assert.notNull(pmsProjectWbsAcceptPayload.getWbsId(), "wbsid不能为空");
        Assert.notNull(pmsProjectWbsAcceptPayload.getWbsCode(), "wbscode不能为空");
        Assert.notNull(pmsProjectWbsAcceptPayload.getWbsId(), "versionId不能为空");
        Assert.notNull(pmsProjectWbsAcceptPayload.getWbsId(), "versionNo不能为空");

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long update(PmsProjectWbsAcceptPayload pmsProjectWbsAcceptPayload) {
        Assert.notNull(pmsProjectWbsAcceptPayload.getId(), "id不能为空");
        Long res = pmsProjectWbsAcceptDao.update(pmsProjectWbsAcceptPayload);
        return res;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean saveAll(List<PmsProjectWbsAcceptPayload> pmsProjectWbsAcceptPayloadList) {

        //
        if (CollUtil.isEmpty(pmsProjectWbsAcceptPayloadList)) {
            return false;
        }
        Long wbsId = pmsProjectWbsAcceptPayloadList.get(0).getWbsId();
        PmsProjectWbsVO pmsProjectWbsVO = pmsProjectWbsDAO.queryByKey(wbsId);
        if (null == pmsProjectWbsVO) {
            throw new BusinessException("wbsId未找到:" + wbsId);
        }
        pmsProjectWbsAcceptDao.delByWbsId(List.of(wbsId));
        List<PmsProjectWbsAcceptDO> list = new ArrayList<>();
        for (PmsProjectWbsAcceptPayload pmsProjectWbsAcceptPayload : pmsProjectWbsAcceptPayloadList) {

            pmsProjectWbsAcceptPayload.setWbsCode(pmsProjectWbsVO.getWbsCode());
            checkData(pmsProjectWbsAcceptPayload);
            PmsProjectWbsAcceptDO pmsProjectWbsAcceptDO = new PmsProjectWbsAcceptDO();
            pmsProjectWbsAcceptDO = PmsProjectWbsAcceptConvert.INSTANCE.p2d(pmsProjectWbsAcceptPayload);
            list.add(pmsProjectWbsAcceptDO);
        }
        pmsProjectWbsAcceptDao.save(list);
        // 同步更新 交付项中的数据 wbsId wbsName 负责人
        list.stream().filter(x -> x.getType() == 0 && StringUtils.isNotBlank(x.getContent())).forEach(x -> {
            String content = x.getContent();
            Long deliverId = Long.valueOf(content);
            PmsDeliverItemPayload updateDeliverItemPayload = new PmsDeliverItemPayload();
            updateDeliverItemPayload.setId(deliverId);
            updateDeliverItemPayload.setWbsId(wbsId);
            updateDeliverItemPayload.setWbsName(pmsProjectWbsVO.getWbsName());
            updateDeliverItemPayload.setDirectorRelatedPartiesId(x.getManagerUserId());
            pmsDeliverItemService.update(updateDeliverItemPayload);
        });

        // 判断验收结果是否全部通过，点击「确定」后，如果所有验收项的验收结果均为“通过”，那么将里程碑的状态更新为“已完成”、同时记录实际完成的日期。
        updateWbsStatus(wbsId);
        return true;
    }

    /**
     * 更新wbs状态
     * 如果所有验收项的验收结果均为“通过”，那么将里程碑的状态更新为“已完成”、同时记录实际完成的日期。
     *
     * @param wbsId wbs id
     * @return {@link Boolean}
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean updateWbsStatus(Long wbsId) {
        if (null == wbsId) {
            throw new BusinessException("wbsId未找到:" + wbsId);
        }
        PmsProjectWbsVO pmsProjectWbsVO = pmsProjectWbsDAO.queryByKey(wbsId);
        if (null == pmsProjectWbsVO) {
            throw new BusinessException("wbsId未找到:" + wbsId);
        }
        // 判断验收结果是否全部通过，点击「确定」后，如果所有验收项的验收结果均为“通过”，那么将里程碑的状态更新为“已完成”、同时记录实际完成的日期。
        PmsProjectWbsAcceptQuery queryAll = new PmsProjectWbsAcceptQuery();
        queryAll.setWbsId(wbsId);
        Long count = pmsProjectWbsAcceptDao.count(queryAll);

        PmsProjectWbsAcceptQuery queryOk = new PmsProjectWbsAcceptQuery();
        queryOk.setWbsId(wbsId);
        queryOk.setAcceptanceStatus(1);
        Long countOk = pmsProjectWbsAcceptDao.count(queryOk);
        if (count > 0 && countOk.equals(count)) {
            PmsProjectWbsPayload pmsProjectWbsPayload = new PmsProjectWbsPayload();
            pmsProjectWbsPayload.setId(wbsId);
            pmsProjectWbsPayload.setEndDate(LocalDate.now());
            pmsProjectWbsPayload.setWbsStatus(ProjectWbsStatusEnum.FINISHED.getCode());
            pmsProjectWbsDAO.updateByKeyNoVersion(pmsProjectWbsPayload);

            // 同步修改 V0数据状态
            Long effRelateId = pmsProjectWbsVO.getEffRelateId();
            if (null != effRelateId) {
                PmsProjectWbsPayload pmsProjectWbsPayloadV0 = new PmsProjectWbsPayload();
                pmsProjectWbsPayloadV0.setId(effRelateId);
                pmsProjectWbsPayloadV0.setEndDate(LocalDate.now());
                pmsProjectWbsPayloadV0.setWbsStatus(ProjectWbsStatusEnum.FINISHED.getCode());
                pmsProjectWbsDAO.updateByKeyNoVersion(pmsProjectWbsPayloadV0);
            }
        }
        // 初版 验收标准
        Long v0WbsId = pmsProjectWbsVO.getEffRelateId();
        boolean updateV0 = false;

        // 当前版本
        // 若里程碑状态为“已完成”，因计划变更而追加验收项或者在此页面将验收结果回退至“未通过”，里程碑状态将流转回“未完成”，同时更新“实际完成”为空。
        if (pmsProjectWbsVO.getWbsStatus().equals(ProjectWbsStatusEnum.FINISHED.getCode())) {
            Long currentVersionId = pmsProjectWbsVO.getVersionId();

            if (null != v0WbsId) {
                PmsProjectWbsAcceptQuery queryV0 = new PmsProjectWbsAcceptQuery();
                queryV0.setWbsId(v0WbsId);
                //VO版本 id
                // queryV0.setVersionId(currentVersionId);
                Long countV0 = pmsProjectWbsAcceptDao.count(queryV0);

                PmsProjectWbsAcceptQuery queryCurrent = new PmsProjectWbsAcceptQuery();
                queryCurrent.setWbsId(wbsId);
                queryCurrent.setVersionId(currentVersionId);
                Long countCurrent = pmsProjectWbsAcceptDao.count(queryCurrent);

                PmsProjectWbsAcceptQuery queryUnAcceptanceStatus = new PmsProjectWbsAcceptQuery();
                queryUnAcceptanceStatus.setWbsId(wbsId);
                queryUnAcceptanceStatus.setVersionId(currentVersionId);
                queryUnAcceptanceStatus.setAcceptanceStatus(0);
                Long countUnAcceptanceStatus = pmsProjectWbsAcceptDao.count(queryUnAcceptanceStatus);

                if (countCurrent > countV0 || countUnAcceptanceStatus > 0) {
                    pmsProjectWbsDAO.updateWbsStatusAndEndDateIsNull(wbsId, ProjectWbsStatusEnum.NOSTART.getCode());
                    // 同步修改 V0数据状态
                    pmsProjectWbsDAO.updateWbsStatusAndEndDateIsNull(v0WbsId, ProjectWbsStatusEnum.NOSTART.getCode());
                }
            }

        }
        if (null != v0WbsId) {
            PmsProjectWbsVO pmsProjectWbsVOZero = pmsProjectWbsDAO.queryByKey(v0WbsId);
            if (pmsProjectWbsVOZero.getWbsStatus().equals(ProjectWbsStatusEnum.FINISHED.getCode())) {
                Long currentVersionId = pmsProjectWbsVO.getVersionId();
                PmsProjectWbsAcceptQuery queryV0 = new PmsProjectWbsAcceptQuery();
                queryV0.setWbsId(v0WbsId);
                //VO版本 id
                // queryV0.setVersionId(currentVersionId);
                Long countV0 = pmsProjectWbsAcceptDao.count(queryV0);

                PmsProjectWbsAcceptQuery queryCurrent = new PmsProjectWbsAcceptQuery();
                queryCurrent.setWbsId(wbsId);
                queryCurrent.setVersionId(currentVersionId);
                Long countCurrent = pmsProjectWbsAcceptDao.count(queryCurrent);

                PmsProjectWbsAcceptQuery queryUnAcceptanceStatus = new PmsProjectWbsAcceptQuery();
                queryUnAcceptanceStatus.setWbsId(wbsId);
                queryUnAcceptanceStatus.setVersionId(currentVersionId);
                queryUnAcceptanceStatus.setAcceptanceStatus(0);
                Long countUnAcceptanceStatus = pmsProjectWbsAcceptDao.count(queryUnAcceptanceStatus);

                if (countCurrent > countV0 || countUnAcceptanceStatus > 0) {
                    // 同步修改 V0数据状态
                    pmsProjectWbsDAO.updateWbsStatusAndEndDateIsNull(v0WbsId, ProjectWbsStatusEnum.NOSTART.getCode());
                }
            }
        }
        return true;
    }

}

