package com.elitesland.tw.tw5.server.prd.pms.service;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsWbsVersionPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsWbsVersionQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsWbsVersionService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsWbsVersionVO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsWbsVersionDao;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;


/**
 * pms版本表service impl
 *
 * @author wangxl
 * @date 2024/3/4
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class PmsWbsVersionServiceImpl implements PmsWbsVersionService {

    private final PmsWbsVersionDao dao;

    @Override
    public PagingVO<PmsWbsVersionVO> queryPage(PmsWbsVersionQuery query) {
        PagingVO<PmsWbsVersionVO> pageVO = dao.queryPage(query);
        translate(pageVO.getRecords());
        return pageVO;
    }

    @Override
    public List<PmsWbsVersionVO> queryList(PmsWbsVersionQuery query) {
        List<PmsWbsVersionVO> listVO = dao.queryList(query);
        translate(listVO);
        return listVO;
    }

    @Override
    public long queryCount(PmsWbsVersionQuery query) {
        return dao.queryCount(query);
    }

    @Override
    public PmsWbsVersionVO queryByKey(Long id) {
        if (null == id) {
            return null;
        }
        PmsWbsVersionVO vo = dao.queryByKey(id);
        Assert.notNull(vo, "查询的数据不存在");
        translate(List.of(vo));
        return vo;
    }

    @Override
    @Transactional
    public PmsWbsVersionVO insert(PmsWbsVersionPayload payload) {
        // 检查数据局
        checkData(payload);
        // 保存数据
        PmsWbsVersionVO save = dao.save(payload);
        // todo 开启工作流
        // startWorkFlow(ado);
        return queryByKey(save.getId());
    }

    @Override
    @Transactional
    public PmsWbsVersionVO update(PmsWbsVersionPayload payload) {
        Assert.notNull(payload.getId(), "id不能为空");
        // 检查数据局
        checkData(payload);
        // 保存数据
        PmsWbsVersionVO save = dao.save(payload);
        return queryByKey(save.getId());
    }

    @Override
    @Transactional
    public PmsWbsVersionVO updateDynamic(PmsWbsVersionPayload payload) {
        Assert.notNull(payload.getId(), "id不能为空");
        // 检查数据局
        checkData(payload);
        // 保存数据
        dao.updateByKeyDynamic(payload);
        return queryByKey(payload.getId());
    }

    @Override
    @Transactional
    public Long deleteSoft(List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            throw new BusinessException("ids参数不能为空");
        }
        return dao.deleteSoft(ids);
    }


    /**
     * 发起工作流
     *
     * @param payload payload
     * @return result
     */
    private Long startWorkFlow(PmsWbsVersionPayload payload) {
        // 发起工作流程
        HashMap<String, Object> varMaps = new HashMap<>();
//        Assert.notNull(payload.getUserId(), "userId不能为空");
//        // 变更资源审批
//        varMaps.put("Activity_111kevq", payload.getUserId());
        //发起流程审批
//        ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
//                HrBaseEnum.BASE_BU_CHANGE.getCode(),
//                HrBaseEnum.BASE_BU_CHANGE.getDesc(),
//                res.getId().toString(), varMaps));
//        String procInstId = processInfo.getProcInstId();
//        ProcInstStatus procInstStatus = processInfo.getProcInstStatus();
        String procInstId = "";
        // 回写单据的工作流信息
//        payload.setProcInstId(procInstId);
//        payload.setProcInstStatus("");
        Long update = dao.updateByKeyDynamic(payload);
        return update;
    }

    /**
     * 数据校验
     *
     * @param payload payload
     */
    private void checkData(PmsWbsVersionPayload payload) {
    }

    /**
     * todo
     *
     * @param vos vos
     */
    private void translate(List<PmsWbsVersionVO> vos) {
        vos.forEach(vo -> {
            // todo 翻译vo对象
//            vo.setUserIdDesc("");
        });
    }


    @Override
    public PmsWbsVersionVO getVersion(Long proId) {

        // 查询新建状态-> 激活状态的最新一条
        PmsWbsVersionVO pmsWbsVersionVO = dao.getVersion(proId,null);
        if (null != pmsWbsVersionVO) {

            return pmsWbsVersionVO;
        } else {
            // 没有则新建一条V1版本
            PmsWbsVersionPayload payload = new PmsWbsVersionPayload();
            payload.setProId(proId);
            payload.setState(1);
            payload.setStepNum(2);
            payload.setVersionNo(0);

            PmsWbsVersionVO save = dao.save(payload);
            return save;
        }


    }

    @Override
    public PmsWbsVersionVO getVersionByState(Long proId, Integer state) {
        // 默认查询激活状态版本
        if (null == state) {
            state = 3;
        }
        PmsWbsVersionVO pmsWbsVersionVO = dao.getVersion(proId, state);
        return pmsWbsVersionVO;
    }

}