package com.elitesland.tw.tw5.server.prd.pms.service.inf;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsRelyTempPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsRelyTempQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsRelyTempVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;

import java.util.List;


/**
 * 项目wbs前置依赖关系模板service
 * @author wangxl
 * @date 2024/4/2
 */
public interface PmsProjectWbsRelyTempService {

    /**
     * 分页查询
     *
     * @param query query
     * @return result
     */
    TwOutputUtil<PagingVO<PmsProjectWbsRelyTempVO>> queryPage(PmsProjectWbsRelyTempQuery query);

    /**
     * 列表查询
     *
     * @param query query
     * @return result
     */
    TwOutputUtil<List<PmsProjectWbsRelyTempVO>> queryList(PmsProjectWbsRelyTempQuery query);

    /**
     * count查询
     *
     * @param query query
     * @return result
     */
    TwOutputUtil<Long> queryCount(PmsProjectWbsRelyTempQuery query);

    /**
     * 根据主键获取详情
     *
     * @param id 主键
     * @return result
     */
    TwOutputUtil<PmsProjectWbsRelyTempVO> queryByKey(Long id);

    /**
     * 新增
     *
     * @param payload payload
     * @return result
     */
    TwOutputUtil<PmsProjectWbsRelyTempVO> insert(PmsProjectWbsRelyTempPayload payload);

    /**
     * 修改
     *
     * @param payload payload
     * @return result
     */
    TwOutputUtil<PmsProjectWbsRelyTempVO> update(PmsProjectWbsRelyTempPayload payload);

    /**
     * 动态修改，一般只用在少部分字段修改的场景，比如修改状态
     *
     * @param payload payload
     * @return result
     */
    TwOutputUtil<PmsProjectWbsRelyTempVO> updateDynamic(PmsProjectWbsRelyTempPayload payload);

    /**
     * 逻辑删除
     *
     * @param ids ids
     * @return result
     */
    TwOutputUtil<Long> deleteSoft(List<Long> ids);

}