package com.elitesland.tw.tw5.server.prd.pms.service.inf;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsTempBatchPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsTempPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsTempQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsTempVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;

import java.util.List;


/**
 * 项目wbs模板表service
 * @author wangxl
 * @date 2024/4/2
 */
public interface PmsProjectWbsTempService {

    /**
     * 分页查询
     *
     * @param query query
     * @return result
     */
    TwOutputUtil<PagingVO<PmsProjectWbsTempVO>> queryPage(PmsProjectWbsTempQuery query);

    /**
     * 列表查询
     *
     * @param query query
     * @return result
     */
    TwOutputUtil<List<PmsProjectWbsTempVO>> queryList(PmsProjectWbsTempQuery query);

    /**
     * count查询
     *
     * @param query query
     * @return result
     */
    TwOutputUtil<Long> queryCount(PmsProjectWbsTempQuery query);

    /**
     * 根据主键获取详情
     *
     * @param id 主键
     * @return result
     */
    TwOutputUtil<PmsProjectWbsTempVO> queryByKey(Long id);

    /**
     * 新增
     *
     * @param payload payload
     * @return result
     */
    TwOutputUtil<PmsProjectWbsTempVO> insert(PmsProjectWbsTempPayload payload);

    /**
     * 修改
     *
     * @param payload payload
     * @return result
     */
    TwOutputUtil<PmsProjectWbsTempVO> update(PmsProjectWbsTempPayload payload);

    /**
     * 动态修改，一般只用在少部分字段修改的场景，比如修改状态
     *
     * @param payload payload
     * @return result
     */
    TwOutputUtil<PmsProjectWbsTempVO> updateDynamic(PmsProjectWbsTempPayload payload);

    /**
     * 逻辑删除
     *
     * @param ids ids
     * @return result
     */
    TwOutputUtil<Long> deleteSoft(List<Long> ids);

    /**
     * 批量新增
     * @param payload
     * @return
     */
    TwOutputUtil<Boolean> batchInsert(PmsProjectWbsTempBatchPayload payload);

    /**
     * 提交模板
     * @param tempId 模板id
     * @return
     */
    Long submitTemplate(Long tempId);
}