package com.elitesland.tw.tw5.server.prd.pms.stateflow.repo.dao;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.convert.PmsStateFlowVersionConvert;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.entity.PmsStateFlowVersionDO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.entity.QPmsStateFlowVersionDO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.payload.PmsStateFlowVersionPayload;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.query.PmsStateFlowVersionQuery;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.vo.PmsStateFlowVersionVO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.repo.PmsStateFlowVersionRepo;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.util.Collections;
import java.util.List;


/**
 * 状态流版本表dao
 *
 * @author wangxl
 * @date 2024/4/19
 */
@RequiredArgsConstructor
@Component
public class PmsStateFlowVersionDao {

    private static final QPmsStateFlowVersionDO qdo = QPmsStateFlowVersionDO.pmsStateFlowVersionDO;
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsStateFlowVersionRepo repo;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PmsStateFlowVersionVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PmsStateFlowVersionVO.class,
                qdo.id,
                qdo.tenantId,
                qdo.belongOrgId,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                qdo.modifyUserId,
                qdo.updater,
                qdo.modifyTime,
                qdo.tenantOrgId,
                qdo.remark,
                qdo.deleteFlag,
                qdo.versionNo,
                qdo.state,
                qdo.categoryId
        )).from(qdo);
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<Long> getJpaQuerySelectCount() {
        return jpaQueryFactory.select(qdo.id.count()).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     */
    private void jpaQueryWhere(JPAQuery<?> jpaQuery, PmsStateFlowVersionQuery query) {
        if (!ObjectUtils.isEmpty(query.getRemark())) {
            jpaQuery.where(qdo.remark.eq(query.getRemark()));
        }
        if (!ObjectUtils.isEmpty(query.getVersionNo())) {
            jpaQuery.where(qdo.versionNo.eq(query.getVersionNo()));
        }
        if (!ObjectUtils.isEmpty(query.getState())) {
            jpaQuery.where(qdo.state.eq(query.getState()));
        }
        if (!ObjectUtils.isEmpty(query.getCategoryId())) {
            jpaQuery.where(qdo.categoryId.eq(query.getCategoryId()));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return result
     */
    public PagingVO<PmsStateFlowVersionVO> queryPage(PmsStateFlowVersionQuery query) {
        // 查询总行数total
        JPAQuery<Long> jpaQuerySelectCount = getJpaQuerySelectCount();
        jpaQueryWhere(jpaQuerySelectCount, query);
        Long nullAbleCount = jpaQuerySelectCount.fetchOne();
        long count = nullAbleCount == null ? 0 : nullAbleCount;
        // 如果总行数为0则直接返回
        if (count == 0) {
            return PagingVO.<PmsStateFlowVersionVO>builder()
                    .total(count)
                    .records(Collections.emptyList())
                    .build();
        }
        JPAQuery<PmsStateFlowVersionVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQueryWhere(jpaQuerySelect, query);
        // 动态排序
        jpaQuerySelect.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        // 分页
        SqlUtil.handlePage(jpaQuerySelect, query);
        return PagingVO.<PmsStateFlowVersionVO>builder()
                .total(count)
                .records(jpaQuerySelect.fetch())
                .build();
    }

    /**
     * 查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PmsStateFlowVersionVO> queryList(PmsStateFlowVersionQuery query) {
        JPAQuery<PmsStateFlowVersionVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQueryWhere(jpaQuerySelect, query);
        // 动态排序
        jpaQuerySelect.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuerySelect.fetch();
    }

    /**
     * 查询count
     *
     * @param query 查询参数
     * @return count
     */
    public long queryCount(PmsStateFlowVersionQuery query) {
        JPAQuery<Long> jpaQuerySelectCount = getJpaQuerySelectCount();
        jpaQueryWhere(jpaQuerySelectCount, query);
        Long count = jpaQuerySelectCount.fetchOne();
        return count == null ? 0 : count;
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PmsStateFlowVersionVO queryByKey(Long id) {
        JPAQuery<PmsStateFlowVersionVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 调用jpa的保存
     *
     * @param payload payload
     * @return 保存后的对象
     */
    public PmsStateFlowVersionVO save(PmsStateFlowVersionPayload payload) {
        PmsStateFlowVersionDO ado = PmsStateFlowVersionConvert.INSTANCE.toEntity(payload);
        // 创建单据的时候审计字段会被前端传的值影响，强制清空相关字段
        SqlUtil.clearAuditFields(ado);
        repo.save(ado);
        return PmsStateFlowVersionConvert.INSTANCE.toVO(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<PmsStateFlowVersionDO> saveAll(List<PmsStateFlowVersionDO> dos) {
        // 创建单据的时候审计字段会被前端传的值影响，强制清空相关字段
        SqlUtil.clearAuditFields(dos);
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    public long updateByKeyDynamic(PmsStateFlowVersionPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        if (payload.getRemark() != null) {
            update.set(qdo.remark, payload.getRemark());
        }
        if (payload.getVersionNo() != null) {
            update.set(qdo.versionNo, payload.getVersionNo());
        }
        if (payload.getState() != null) {
            update.set(qdo.state, payload.getState());
        }
        if (payload.getCategoryId() != null) {
            update.set(qdo.categoryId, payload.getCategoryId());
        }
        // 处理要设置成空的字段(nullField处理)
        SqlUtil.handleNullFieldsUpdate(payload, qdo, update);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }

    public PmsStateFlowVersionVO getLastVersionNo(Long categoryId, Integer state) {

        JPAQuery<PmsStateFlowVersionVO> jpaQuery = getJpaQuerySelect();
        if (null != state) {
            jpaQuery.where(qdo.state.eq(state));
        }
        PmsStateFlowVersionVO pmsStateFlowVersionVO = jpaQuery.where(qdo.categoryId.eq(categoryId))
                .orderBy(qdo.versionNo.desc())
                .fetchFirst();
        return pmsStateFlowVersionVO;
    }
}
