package com.elitesland.tw.tw5.server.prd.pms.stateflow.repo.dao;


import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.entity.QStateFlowConfigDO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.entity.StateFlowConfigDO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.payload.StateFlowConfigPayload;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.query.StateFlowConfigQuery;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.vo.StateFlowConfigVO;

import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;


/**
 * @author : WWW
 * @date : 2024-1-23
 * @desc : 状态流转配置RepoProc
 */
@Component
public class StateFlowConfigDao extends BaseRepoProc<StateFlowConfigDO> {

    private static final QStateFlowConfigDO qStateFlowConfigDO = QStateFlowConfigDO.stateFlowConfigDO;


    protected StateFlowConfigDao() {

        super(qStateFlowConfigDO);

    }


    public PagingVO<StateFlowConfigVO> page(StateFlowConfigQuery stateFlowConfigQuery) {

        JPAQuery<StateFlowConfigVO> query =
                select(StateFlowConfigVO.class)
                        .where(bulidPredicate(stateFlowConfigQuery));
        stateFlowConfigQuery.setPaging(query);
        stateFlowConfigQuery.fillOrders(query, qStateFlowConfigDO);
        return PagingVO.<StateFlowConfigVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }


    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(qStateFlowConfigDO)
                .set(qStateFlowConfigDO.deleteFlag, 1)
                .where(qStateFlowConfigDO.id.in(ids))
                .execute();

        return res;

    }


    public StateFlowConfigVO get(Long id) {

        StateFlowConfigVO stateFlowConfigVO = select(StateFlowConfigVO.class)
                .where(qStateFlowConfigDO.id.eq(id))
                .fetchOne();

        return stateFlowConfigVO;

    }


    public List<StateFlowConfigVO> getList(StateFlowConfigQuery stateFlowConfigQuery) {

        List<StateFlowConfigVO> res =
                select(StateFlowConfigVO.class)
                        .where(bulidPredicate(stateFlowConfigQuery))
                        .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                        qStateFlowConfigDO.flowId,
                        qStateFlowConfigDO.configFlowId,
                        qStateFlowConfigDO.configFlowCode,
                        qStateFlowConfigDO.state,
                        qStateFlowConfigDO.id,
                        qStateFlowConfigDO.createTime,
                        qStateFlowConfigDO.remark

                )).from(qStateFlowConfigDO);

    }


    private Predicate bulidPredicate(StateFlowConfigQuery stateFlowConfigQuery) {

        Predicate predicate = PredicateBuilder.builder()
                .andEq(null != stateFlowConfigQuery.getFlowId(), qStateFlowConfigDO.flowId, stateFlowConfigQuery.getFlowId())
                .andIn(null != stateFlowConfigQuery.getFlowIds(), qStateFlowConfigDO.flowId, stateFlowConfigQuery.getFlowIds())
                .andEq(null != stateFlowConfigQuery.getConfigFlowId(), qStateFlowConfigDO.configFlowId, stateFlowConfigQuery.getConfigFlowId())
                .andEq(null != stateFlowConfigQuery.getState(), qStateFlowConfigDO.state, stateFlowConfigQuery.getState())
                .build();

        return predicate;

    }


    private Predicate bulidPredicates(StateFlowConfigQuery stateFlowConfigQuery) {

        List<Predicate> predicates = new ArrayList<>();
        // 状态流id
        if (null != stateFlowConfigQuery.getFlowId()) {
            predicates.add(qStateFlowConfigDO.flowId.eq(stateFlowConfigQuery.getFlowId()));
        }
        if (null != stateFlowConfigQuery.getFlowIds()) {
            predicates.add(qStateFlowConfigDO.flowId.in(stateFlowConfigQuery.getFlowIds()));
        }
        // 可流转的流id
        if (null != stateFlowConfigQuery.getConfigFlowId()) {
            predicates.add(qStateFlowConfigDO.configFlowId.eq(stateFlowConfigQuery.getConfigFlowId()));
        }
        // 状态
        if (null != stateFlowConfigQuery.getState()) {
            predicates.add(qStateFlowConfigDO.state.eq(stateFlowConfigQuery.getState()));
        }

        Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicate;
    }


    public Long count(StateFlowConfigQuery stateFlowConfigQuery) {

        long res = select(StateFlowConfigVO.class)
                .where(bulidPredicates(stateFlowConfigQuery))
                .fetchCount();

        return res;


    }

    public Long update(StateFlowConfigPayload stateFlowConfigPayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qStateFlowConfigDO);

        // 状态流id
        if (null != stateFlowConfigPayload.getFlowId()) {
            update.set(qStateFlowConfigDO.flowId, stateFlowConfigPayload.getFlowId());
        }
        // 可流转的流id
        if (null != stateFlowConfigPayload.getConfigFlowId()) {
            update.set(qStateFlowConfigDO.configFlowId, stateFlowConfigPayload.getConfigFlowId());
        }
        // 状态
        if (null != stateFlowConfigPayload.getState()) {
            update.set(qStateFlowConfigDO.state, stateFlowConfigPayload.getState());
        }
        long res = update.where(qStateFlowConfigDO.id.eq(stateFlowConfigPayload.getId()))
                .execute();
        return res;

    }

    public Long delByFlowId(Long flowId) {
        JPAUpdateClause update = jpaQueryFactory.update(qStateFlowConfigDO);
        long res = update.set(qStateFlowConfigDO.deleteFlag, 1)
                .where(qStateFlowConfigDO.flowId.eq(flowId))
                .execute();
        return res;
    }
}

