package com.elitesland.tw.tw5.server.prd.pms.stateflow.repo.dao;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.entity.QPmsStateFlowVersionDO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.entity.QStateFlowDO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.entity.StateFlowDO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.payload.StateFlowPayload;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.query.StateFlowQuery;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.vo.StateFlowVO;

import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;


/**
 * @author : WWW
 * @date : 2024-1-25
 * @desc : 状态流RepoProc
 */
@Component
public class StateFlowDao extends BaseRepoProc<StateFlowDO> {

    private static final QStateFlowDO qStateFlowDO = QStateFlowDO.stateFlowDO;
    private static final QPmsStateFlowVersionDO qPmsStateFlowVersionDO = QPmsStateFlowVersionDO.pmsStateFlowVersionDO;


    protected StateFlowDao() {

        super(qStateFlowDO);

    }


    public PagingVO<StateFlowVO> page(StateFlowQuery stateFlowQuery) {

        JPAQuery<StateFlowVO> query =
                select(StateFlowVO.class)
                        .where(bulidPredicate(stateFlowQuery));
        stateFlowQuery.setPaging(query);
        stateFlowQuery.fillOrders(query, qStateFlowDO);
        return PagingVO.<StateFlowVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }


    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(qStateFlowDO)
                .set(qStateFlowDO.deleteFlag, 1)
                .where(qStateFlowDO.id.in(ids))
                .execute();

        return res;

    }


    public StateFlowVO get(Long id) {

        StateFlowVO stateFlowVO = select(StateFlowVO.class)
                .where(qStateFlowDO.id.eq(id))
                .fetchOne();

        return stateFlowVO;

    }


    public List<StateFlowVO> getList(StateFlowQuery stateFlowQuery) {

        List<StateFlowVO> res =
                select(StateFlowVO.class)
                        .where(bulidPredicate(stateFlowQuery))
                        .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                        qStateFlowDO.name,
                        qStateFlowDO.code,
                        qStateFlowDO.state,
                        qStateFlowDO.defFlag,
                        qStateFlowDO.fontColor,
                        qStateFlowDO.backgroundColor,
                        qStateFlowDO.stageId,
                        qStateFlowDO.type,
                        qStateFlowDO.objId,
                        qStateFlowDO.sort,
                        qStateFlowDO.id,
                        qStateFlowDO.createTime,
                        qStateFlowDO.progressPercentage,
                        qStateFlowDO.versionId,
                        qStateFlowDO.versionNo,
                        qStateFlowDO.effRelateId,
                        qStateFlowDO.remark

                )).from(qStateFlowDO);


    }


    private <T> JPAQuery<T> select2(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                                qStateFlowDO.name,
                                qStateFlowDO.code,
                                qStateFlowDO.state,
                                qStateFlowDO.defFlag,
                                qStateFlowDO.fontColor,
                                qStateFlowDO.backgroundColor,
                                qStateFlowDO.stageId,
                                qStateFlowDO.type,
                                qStateFlowDO.objId,
                                qStateFlowDO.sort,
                                qStateFlowDO.id,
                                qStateFlowDO.createTime,
                                qStateFlowDO.progressPercentage,
                                qStateFlowDO.versionId,
                                qStateFlowDO.versionNo,
                                qStateFlowDO.effRelateId,
                                qStateFlowDO.remark

                        )).from(qStateFlowDO)
                        .leftJoin(qPmsStateFlowVersionDO).on(qStateFlowDO.versionId.eq(qPmsStateFlowVersionDO.id));

    }


    private Predicate bulidPredicate(StateFlowQuery stateFlowQuery) {

        Predicate predicate = PredicateBuilder.builder()
                .andEq(StringUtils.isNotBlank(stateFlowQuery.getName()), qStateFlowDO.name, stateFlowQuery.getName())
                .andEq(null != stateFlowQuery.getState(), qStateFlowDO.state, stateFlowQuery.getState())
                .andEq(null != stateFlowQuery.getCode(), qStateFlowDO.code, stateFlowQuery.getCode())
                .andEq(null != stateFlowQuery.getDefFlag(), qStateFlowDO.defFlag, stateFlowQuery.getDefFlag())
                .andEq(StringUtils.isNotBlank(stateFlowQuery.getFontColor()), qStateFlowDO.fontColor, stateFlowQuery.getFontColor())
                .andEq(StringUtils.isNotBlank(stateFlowQuery.getBackgroundColor()), qStateFlowDO.backgroundColor, stateFlowQuery.getBackgroundColor())
                .andEq(null != stateFlowQuery.getStageId(), qStateFlowDO.stageId, stateFlowQuery.getStageId())
                .andEq(null != stateFlowQuery.getType(), qStateFlowDO.type, stateFlowQuery.getType())
                .andEq(null != stateFlowQuery.getObjId(), qStateFlowDO.objId, stateFlowQuery.getObjId())
                .andEq(null != stateFlowQuery.getVersionId(), qStateFlowDO.versionId, stateFlowQuery.getVersionId())
                .andEq(null != stateFlowQuery.getVersionNo(), qStateFlowDO.versionNo, stateFlowQuery.getVersionNo())
                .andEq(null != stateFlowQuery.getEffRelateId(), qStateFlowDO.effRelateId, stateFlowQuery.getEffRelateId())
                .build();

        return predicate;

    }


    private Predicate bulidPredicates(StateFlowQuery stateFlowQuery) {

        List<Predicate> predicates = new ArrayList<>();
        // 名称
        if (StringUtils.isNotEmpty(stateFlowQuery.getName())) {
            predicates.add(qStateFlowDO.name.eq(stateFlowQuery.getName()));
        }
        if (StringUtils.isNotEmpty(stateFlowQuery.getCode())) {
            predicates.add(qStateFlowDO.code.eq(stateFlowQuery.getCode()));
        }
        // 状态1开始2进行中3结束
        if (null != stateFlowQuery.getState()) {
            predicates.add(qStateFlowDO.state.eq(stateFlowQuery.getState()));
        }
        // 默认标志
        if (null != stateFlowQuery.getDefFlag()) {
            predicates.add(qStateFlowDO.defFlag.eq(stateFlowQuery.getDefFlag()));
        }
        // 字体颜色
        if (StringUtils.isNotEmpty(stateFlowQuery.getFontColor())) {
            predicates.add(qStateFlowDO.fontColor.eq(stateFlowQuery.getFontColor()));
        }
        // 背景色
        if (StringUtils.isNotEmpty(stateFlowQuery.getBackgroundColor())) {
            predicates.add(qStateFlowDO.backgroundColor.eq(stateFlowQuery.getBackgroundColor()));
        }
        // 阶段id
        if (null != stateFlowQuery.getStageId()) {
            predicates.add(qStateFlowDO.stageId.eq(stateFlowQuery.getStageId()));
        }
        // 类型1需求2任务3缺陷
        if (null != stateFlowQuery.getType()) {
            predicates.add(qStateFlowDO.type.eq(stateFlowQuery.getType()));
        }
        // 关联单据主键
        if (null != stateFlowQuery.getObjId()) {
            predicates.add(qStateFlowDO.objId.eq(stateFlowQuery.getObjId()));
        }
        // 版本信息
        if (null != stateFlowQuery.getVersionNo()) {
            predicates.add(qStateFlowDO.versionNo.eq(stateFlowQuery.getVersionNo()));
        }
        if (null != stateFlowQuery.getVersionId()) {
            predicates.add(qStateFlowDO.versionId.eq(stateFlowQuery.getVersionId()));
        }
        if (null != stateFlowQuery.getEffRelateId()) {
            predicates.add(qStateFlowDO.effRelateId.eq(stateFlowQuery.getEffRelateId()));
        }

        Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicate;
    }


    public Long count(StateFlowQuery stateFlowQuery) {

        long res = select(StateFlowVO.class)
                .where(bulidPredicates(stateFlowQuery))
                .fetchCount();

        return res;


    }

    public Long update(StateFlowPayload stateFlowPayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qStateFlowDO);

        // 名称
        if (StringUtils.isNotEmpty(stateFlowPayload.getName())) {
            update.set(qStateFlowDO.name, stateFlowPayload.getName());
        }
        // 状态1开始2进行中3结束
        if (null != stateFlowPayload.getState()) {
            update.set(qStateFlowDO.state, stateFlowPayload.getState());
        }
        // 默认标志
        if (null != stateFlowPayload.getDefFlag()) {
            update.set(qStateFlowDO.defFlag, stateFlowPayload.getDefFlag());
        }
        // 字体颜色
        if (StringUtils.isNotEmpty(stateFlowPayload.getFontColor())) {
            update.set(qStateFlowDO.fontColor, stateFlowPayload.getFontColor());
        }
        // 背景色
        if (StringUtils.isNotEmpty(stateFlowPayload.getBackgroundColor())) {
            update.set(qStateFlowDO.backgroundColor, stateFlowPayload.getBackgroundColor());
        }
        // 阶段id
        if (null != stateFlowPayload.getStageId()) {
            update.set(qStateFlowDO.stageId, stateFlowPayload.getStageId());
        }
        // 类型1需求2任务3缺陷
        if (null != stateFlowPayload.getType()) {
            update.set(qStateFlowDO.type, stateFlowPayload.getType());
        }
        // 排序
        if (null != stateFlowPayload.getSort()) {
            update.set(qStateFlowDO.sort, stateFlowPayload.getSort());
        }
        // 进度百分比
        if (null != stateFlowPayload.getProgressPercentage()) {
            update.set(qStateFlowDO.progressPercentage, stateFlowPayload.getProgressPercentage());
        }
        long res = update.where(qStateFlowDO.id.eq(stateFlowPayload.getId()))
                .execute();
        return res;

    }

    public StateFlowVO getDefStateFlow(StateFlowQuery stateFlowQuery) {

        StateFlowVO res = select2(StateFlowVO.class)
                .where(bulidPredicate(stateFlowQuery))
                .where(qPmsStateFlowVersionDO.state.eq(3))
                .where(qStateFlowDO.code.isNotNull())
                .where(qStateFlowDO.code.ne(""))
                .orderBy(qPmsStateFlowVersionDO.versionNo.desc())
                .orderBy(qStateFlowDO.state.asc())
                .fetchFirst();
        return res;
    }
}

