package com.elitesland.tw.tw5.server.prd.pms.stateflow.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.payload.StateFlowPayload;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.query.StateFlowQuery;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.vo.StateFlowVO;

import java.util.List;


/**
  * @author : WWW
  * @date : 2024-1-23
  * @desc : 状态流Service
  */
public interface StateFlowService {
    
    /**
     * 新增状态流数据
     * @param stateFlowPayload
     * @return
     */
    StateFlowVO save(StateFlowPayload stateFlowPayload);
    
    /**
     * 根据主键更新
     * @param stateFlowPayload
     * @return
     */
    StateFlowVO updateAll(StateFlowPayload stateFlowPayload);
    
    /**
     * 根据主键获取详情
     * @param id
     * @return
     */
    StateFlowVO get(Long id);
    
    /**
     * 分页查询列表
     * @param stateFlowQuery
     * @return
     */
    PagingVO<StateFlowVO> page(StateFlowQuery stateFlowQuery);
    
    /**
     * 根据主键批量删除
     * @param ids
     * @return
     */
    Long del(List<Long> ids);
    
    /**
     * 获取列表查询
     * @param stateFlowQuery
     * @return
     */
    List<StateFlowVO> getList(StateFlowQuery stateFlowQuery);
    
    /**
     * 根据条件修改
     * @param stateFlowPayload
     * @return
     */
    Long update(StateFlowPayload stateFlowPayload);

     /**
      * 获取状态流集合（包含可配置的流）
      * @param stateFlowQuery
      * @return
      */
     List<StateFlowVO> getListByDtl(StateFlowQuery stateFlowQuery);

    /**
     * 获取默认的工作流设置
     * @param stateFlowQuery
     * @return
     */
     StateFlowVO getDefStateFlow(StateFlowQuery stateFlowQuery);


    /**
     * 根据场景id获取默认的工作流设置
     *
     * @param sceneId
     * @return
     */
    StateFlowVO getDefStateFlowByScenId(Long sceneId);

 }

