package com.elitesland.tw.tw5.server.prd.pms.stateflow.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.convert.StateFlowConfigConvert;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.entity.StateFlowConfigDO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.payload.StateFlowConfigPayload;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.query.StateFlowConfigQuery;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.vo.StateFlowConfigVO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.repo.StateFlowConfigRepo;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.repo.dao.StateFlowConfigDao;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.service.StateFlowConfigService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;


/**
 * @author : WWW
 * @date : 2024-1-23
 * @desc : 状态流转配置Service
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class StateFlowConfigServiceImpl implements StateFlowConfigService {


    private final StateFlowConfigDao stateFlowConfigDao;

    private final StateFlowConfigRepo stateFlowConfigRepo;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public StateFlowConfigVO save(StateFlowConfigPayload stateFlowConfigPayload) {

        if (null == stateFlowConfigPayload.getState()) {
            stateFlowConfigPayload.setState(1);
        }
        checkData(stateFlowConfigPayload);
        StateFlowConfigDO stateFlowConfigDO = new StateFlowConfigDO();
        stateFlowConfigDO = StateFlowConfigConvert.INSTANCE.p2d(stateFlowConfigPayload);
        StateFlowConfigDO res = stateFlowConfigRepo.save(stateFlowConfigDO);
        return StateFlowConfigConvert.INSTANCE.d2v(res);

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public StateFlowConfigVO updateAll(StateFlowConfigPayload stateFlowConfigPayload) {

        Assert.notNull(stateFlowConfigPayload.getId(), "id is null");
        StateFlowConfigVO res = save(stateFlowConfigPayload);
        return res;

    }


    @Override
    public StateFlowConfigVO get(Long id) {

        if (null == id) {
            return null;
        }
        StateFlowConfigVO res = stateFlowConfigDao.get(id);
        return res;

    }


    @Override
    public PagingVO<StateFlowConfigVO> page(StateFlowConfigQuery stateFlowConfigQuery) {

        PagingVO<StateFlowConfigVO> res = stateFlowConfigDao.page(stateFlowConfigQuery);
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {

        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = stateFlowConfigDao.del(ids);
        return res;

    }

    @Override
    public List<StateFlowConfigVO> getList(StateFlowConfigQuery stateFlowConfigQuery) {

        List<StateFlowConfigVO> res = stateFlowConfigDao.getList(stateFlowConfigQuery);
        return res;

    }


    /**
     * 数据校验
     *
     * @param stateFlowConfigPayload
     */
    private void checkData(StateFlowConfigPayload stateFlowConfigPayload) {
        Assert.notNull(stateFlowConfigPayload.getConfigFlowId(), "配置流id不能为空");
        Assert.notNull(stateFlowConfigPayload.getConfigFlowCode(), "配置流code不能为空");

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long update(StateFlowConfigPayload stateFlowConfigPayload) {
        Assert.notNull(stateFlowConfigPayload.getId(), "id不能为空");
        Long res = stateFlowConfigDao.update(stateFlowConfigPayload);
        return res;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean delByFlowId(Long flowId) {
        Long res = stateFlowConfigDao.delByFlowId(flowId);

        return res > 0;
    }


}

