package com.elitesland.tw.tw5.server.prd.pms.stateflow.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.server.common.GenerateSeqNumConstants;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.convert.StateFlowConvert;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.entity.StateFlowDO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.payload.StateFlowPayload;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.query.StateFlowConfigQuery;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.query.StateFlowQuery;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.vo.PmsStateFlowVersionVO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.vo.StateFlowConfigVO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.vo.StateFlowVO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.repo.StateFlowRepo;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.repo.dao.PmsStateFlowVersionDao;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.repo.dao.StateFlowDao;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.service.PmsStateFlowVersionService;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.service.StateFlowConfigService;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.service.StateFlowService;
import com.elitesland.tw.tw5.server.prd.taskpro.model.vo.TaskSceneVO;
import com.elitesland.tw.tw5.server.prd.taskpro.service.TaskSceneService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


/**
 * @author : WWW
 * @date : 2024-1-23
 * @desc : 状态流Service
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class StateFlowServiceImpl extends BaseServiceImpl implements StateFlowService {


    private final StateFlowDao stateFlowDao;

    private final StateFlowRepo stateFlowRepo;

    private final StateFlowConfigService stateFlowConfigService;

    private final TaskSceneService taskSceneService;

    @Lazy
    @Autowired
    private PmsStateFlowVersionDao pmsStateFlowVersionService;


//    @Autowired
//    @Lazy
//    private TaskProService taskProService;

    @Autowired
    @Lazy
    private TaskInfoService taskInfoService;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public StateFlowVO save(StateFlowPayload stateFlowPayload) {

        Assert.notNull(stateFlowPayload.getObjId(), "objId不能为空");
        // 查询状态流新增状态的版本
        PmsStateFlowVersionVO pmsStateFlowVersionVO = pmsStateFlowVersionService.getLastVersionNo(stateFlowPayload.getObjId(), null);
        if (null == pmsStateFlowVersionVO) {
            throw new BusinessException("该分类下没有流程版本");
        }
        stateFlowPayload.setVersionId(pmsStateFlowVersionVO.getId());
        stateFlowPayload.setVersionNo(pmsStateFlowVersionVO.getVersionNo());

        // 默认开始状态
        if (null == stateFlowPayload.getState()) {
            stateFlowPayload.setState(1);
        }
        checkData(stateFlowPayload);
        if (stateFlowPayload.getState() == 1) {
            stateFlowPayload.setProgressPercentage(BigDecimal.ZERO);
        }
        if (stateFlowPayload.getState() == 3) {
            stateFlowPayload.setProgressPercentage(BigDecimal.ONE);
        }
        // 状态流编码
        if (null == stateFlowPayload.getId()) {
            String code = generateSeqNum(GenerateSeqNumConstants.STATE_FLOW_NO);
            stateFlowPayload.setCode(code);
        }
        StateFlowQuery stateFlowQuery = new StateFlowQuery();
        stateFlowQuery.setName(stateFlowPayload.getName());
        stateFlowQuery.setType(stateFlowPayload.getType());
        stateFlowQuery.setObjId(stateFlowPayload.getObjId());
        stateFlowQuery.setVersionId(stateFlowPayload.getVersionId());
        Long count = stateFlowDao.count(stateFlowQuery);
        if (count > 0) {
            throw new BusinessException("已存在相同的名字: " + stateFlowPayload.getName());

        }

        StateFlowDO stateFlowDO = StateFlowConvert.INSTANCE.p2d(stateFlowPayload);
        StateFlowDO res = stateFlowRepo.save(stateFlowDO);

        // 循环自己本身的所有数据


        // 保存明细
//        stateFlowPayload.getStateFlowConfigPayloadList().forEach(x -> {
//            x.setFlowId(res.getId());
//            x.setState(1);
//            stateFlowConfigService.save(x);
//        });

        return StateFlowConvert.INSTANCE.d2v(res);

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public StateFlowVO updateAll(StateFlowPayload stateFlowPayload) {

        Assert.notNull(stateFlowPayload.getId(), "id is null");
        StateFlowVO res = save(stateFlowPayload);
        return res;

    }


    @Override
    public StateFlowVO get(Long id) {

        if (null == id) {
            return null;
        }
        StateFlowVO res = stateFlowDao.get(id);
        if (null == res) {
            return null;
        }

        // 查找可流转的流集合
        StateFlowConfigQuery stateFlowConfigQuery = new StateFlowConfigQuery();
        stateFlowConfigQuery.setFlowId(id);
        List<StateFlowConfigVO> list = stateFlowConfigService.getList(stateFlowConfigQuery);
        res.setStateFlowConfigVOList(list);
        return res;

    }


    @Override
    public PagingVO<StateFlowVO> page(StateFlowQuery stateFlowQuery) {

        PagingVO<StateFlowVO> res = stateFlowDao.page(stateFlowQuery);
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {

        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }

        Long taskCount = taskInfoService.countByFlowId(ids);
        if (taskCount > 0) {
            throw new BusinessException("请先移除任务下的状态后在进行删除操作");
        }
        Long res = stateFlowDao.del(ids);
        // 明细删除
        for (Long id : ids) {
            stateFlowConfigService.delByFlowId(id);
        }
        return res;

    }

    @Override
    public List<StateFlowVO> getList(StateFlowQuery stateFlowQuery) {

        if (stateFlowQuery.getVersionNo() == null && null == stateFlowQuery.getVersionId()) {
            Assert.notNull(stateFlowQuery.getObjId(), "objId不能为空");
            // 查询该分类下最新激活版本的状态流
            PmsStateFlowVersionVO lastVersionNo = pmsStateFlowVersionService.getLastVersionNo(stateFlowQuery.getObjId(), 3);
            if (null == lastVersionNo) {
                return new ArrayList<>();
            }
            stateFlowQuery.setVersionId(lastVersionNo.getId());
            stateFlowQuery.setVersionNo(lastVersionNo.getVersionNo());
        }

        List<StateFlowVO> res = stateFlowDao.getList(stateFlowQuery);
        return res;

    }


    /**
     * 数据校验
     *
     * @param stateFlowPayload
     */
    private void checkData(StateFlowPayload stateFlowPayload) {

        Assert.notNull(stateFlowPayload.getType(), "objId不能为空");
        Assert.notNull(stateFlowPayload.getType(), "类型不能为空");
        Assert.notEmpty(stateFlowPayload.getName(), "名称不能为空");
        Assert.notNull(stateFlowPayload.getState(), "状态不能为空");

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long update(StateFlowPayload stateFlowPayload) {
        Assert.notNull(stateFlowPayload.getId(), "id不能为空");
        if (stateFlowPayload.getState() == 1) {
            stateFlowPayload.setProgressPercentage(BigDecimal.ZERO);
        }
        if (stateFlowPayload.getState() == 3) {
            stateFlowPayload.setProgressPercentage(new BigDecimal("100"));
        }
        // 设置进行中默认进度10%
        if (stateFlowPayload.getState() == 2 && null == stateFlowPayload.getProgressPercentage()) {
            stateFlowPayload.setProgressPercentage(new BigDecimal("10"));
        }
        Long res = stateFlowDao.update(stateFlowPayload);
//        stateFlowConfigService.delByFlowId(res);
//        // 保存明细
//        stateFlowPayload.getStateFlowConfigPayloadList().forEach(x -> {
//            x.setFlowId(res);
//            x.setState(1);
//            stateFlowConfigService.save(x);
//        });
        return res;
    }

    @Override
    public List<StateFlowVO> getListByDtl(StateFlowQuery stateFlowQuery) {

        List<StateFlowVO> list = getList(stateFlowQuery);
        list.forEach(x -> {
            // 查找可流转的流集合
            StateFlowConfigQuery stateFlowConfigQuery = new StateFlowConfigQuery();
            stateFlowConfigQuery.setFlowId(x.getId());
            List<StateFlowConfigVO> dtlList = stateFlowConfigService.getList(stateFlowConfigQuery);
            x.setStateFlowConfigVOList(dtlList);
        });
        return list;
    }

    @Override
    public StateFlowVO getDefStateFlow(StateFlowQuery stateFlowQuery) {

        StateFlowVO stateFlowVO = stateFlowDao.getDefStateFlow(stateFlowQuery);
        return stateFlowVO;
    }

    @Override
    public StateFlowVO getDefStateFlowByScenId(Long sceneId) {

        TaskSceneVO taskSceneVO = taskSceneService.queryByKey(sceneId);
        StateFlowQuery stateFlowQuery = new StateFlowQuery();
        stateFlowQuery.setObjId(taskSceneVO.getCategoryId());
        StateFlowVO defStateFlow = this.getDefStateFlow(stateFlowQuery);

        return defStateFlow;
    }


}

