package com.elitesland.tw.tw5.server.prd.provacation.controller;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.scheduling.TimeUtil;
import com.elitesland.tw.tw5.server.prd.provacation.model.payload.ProVacationPayload;
import com.elitesland.tw.tw5.server.prd.provacation.model.query.ProVacationQuery;
import com.elitesland.tw.tw5.server.prd.provacation.model.vo.ProVacationVO;
import com.elitesland.tw.tw5.server.prd.provacation.service.ProVacationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.*;


/**
 * @author : WWW
 * @date : 2024-1-19
 * @desc : 项目假期
 */
@RestController
@RequestMapping("/api/proVacation")
@RequiredArgsConstructor
@Api(value = "项目假期", tags = {"项目假期"})
public class ProVacationController {

    private final ProVacationService proVacationService;


    @GetMapping("get")
    @ApiOperation("详情-项目假期")
    public TwOutputUtil<ProVacationVO> get(Long id) {

        ProVacationVO res = proVacationService.get(id);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("save")
    @ApiOperation("新增-项目假期")
    public TwOutputUtil<Boolean> save(@RequestBody ProVacationPayload proVacationPayload) {

        List<Map<String, BigDecimal>> list = proVacationPayload.getMapList();
        List<ProVacationPayload> vacationPlayloadList = new ArrayList<>();
        list.forEach(o -> {
            Map<String, BigDecimal> map = o;
            Set<String> keys = map.keySet();
            keys.forEach(key -> {
                ProVacationPayload vacationPlayload = new ProVacationPayload();
                vacationPlayload.setNaturalDate(TimeUtil.dateFromYmd(key));
                vacationPlayload.setWorkHours(map.get(key));
                vacationPlayload.setProjectId(proVacationPayload.getProjectId());
                vacationPlayload.setType(proVacationPayload.getType());
                vacationPlayloadList.add(vacationPlayload);
            });
        });

        Boolean res = proVacationService.saveAll(vacationPlayloadList, proVacationPayload.getProjectId(),proVacationPayload.getYear());
        return TwOutputUtil.ok(res);

    }


    @PostMapping("update")
    @ApiOperation("修改-项目假期")
    public TwOutputUtil<Long> update(@RequestBody ProVacationPayload proVacationPayload) {

        Long res = proVacationService.update(proVacationPayload);
        return TwOutputUtil.ok(res);

    }


    @DeleteMapping("del")
    @ApiOperation("删除-项目假期")
    public TwOutputUtil<Long> del(@RequestBody List<Long> ids) {

        Long res = proVacationService.del(ids);
        return TwOutputUtil.ok(res);

    }


    @GetMapping("/page")
    @UdcNameClass
    @ApiOperation("分页查询-项目假期")
    public TwOutputUtil<PagingVO<ProVacationVO>> page(@RequestBody ProVacationQuery proVacationQuery) {

        PagingVO<ProVacationVO> res = proVacationService.page(proVacationQuery);
        return TwOutputUtil.ok(res);

    }


    @GetMapping("getList")
    @ApiOperation("列表查询-项目假期")
    public TwOutputUtil<List<ProVacationVO>> getList(ProVacationQuery proVacationQuery) {

        List<ProVacationVO> res = proVacationService.getList(proVacationQuery);
        return TwOutputUtil.ok(res);

    }


    @GetMapping("/{year}/{projectId}")
    @ApiOperation("年度-项目假期查询")
    public TwOutputUtil<List<Map<String, BigDecimal>>> findVacation(@PathVariable int year, @PathVariable Long projectId) {

        Assert.notNull(projectId, "项目id不能为空");
        ProVacationQuery proVacationQuery = new ProVacationQuery();
        proVacationQuery.setYear(year);
        proVacationQuery.setProjectId(projectId);
        List<ProVacationVO> list = proVacationService.getList(proVacationQuery);
        List<Map<String, BigDecimal>> mapList = new ArrayList<>();
        list.forEach(twVacationView -> {
            HashMap<String, BigDecimal> map = new HashMap<>();
            map.put(TimeUtil.dateToYmd(twVacationView.getNaturalDate()), twVacationView.getWorkHours());
            mapList.add(map);
        });
        return TwOutputUtil.ok(mapList);
    }


}

