package com.elitesland.tw.tw5.server.prd.provacation.model.entity;

import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;

import org.hibernate.annotations.Where;
import com.elitescloud.boot.model.entity.BaseModel;


/**
 * @author : WWW
 * @date : 2024-1-19
 * @desc : 项目假期
 */
@Entity
@Table(name = "pro_vacation")
@org.hibernate.annotations.Table(appliesTo = "pro_vacation", comment = "项目假期")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class ProVacationDO extends BaseModel {


    /**
     * 项目id
     */
    @Column(name = "project_id", columnDefinition = "bigint(20) comment '项目id'")
    private Long projectId;

    /**
     * 日期
     */
    @Column(name = "natural_date", columnDefinition = "date comment '日期'")
    private LocalDate naturalDate;

    /**
     * 工作小时数
     */
    @Column(name = "work_hours", columnDefinition = "decimal(20,2) comment '工作小时数'")
    private BigDecimal workHours;

    /**
     * 类型 1项目
     */
    @Column(name = "type", columnDefinition = "int(11) comment '类型'")
    private Integer type;

}

