package com.elitesland.tw.tw5.server.prd.provacation.model.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.time.LocalDate;


/**
 * @author : WWW
 * @date : 2024-1-19
 * @desc : 项目假期
 */
@Data
@ApiModel(description = "项目假期")
public class ProVacationQuery extends TwQueryParam {


    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Long projectId;

    /**
     * 日期
     */
    @ApiModelProperty("日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate naturalDate;

    /**
     * 工作小时数
     */
    @ApiModelProperty("工作小时数")
    private BigDecimal workHours;


    /**
     * 类型
     */
    @ApiModelProperty("类型")
    private Integer type;


    /**
     * 年份
     */
    private Integer year;

    /**
     * 日期开始
     */
    @ApiModelProperty("日期开始")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate naturalDateStart;

    /**
     * 日期结束
     */
    @ApiModelProperty("日期结束")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate naturalDateEnd;

}

