package com.elitesland.tw.tw5.server.prd.provacation.repo.dao;


import com.elitesland.tw.tw5.server.prd.provacation.model.entity.ProVacationDO;
import com.elitesland.tw.tw5.server.prd.provacation.model.entity.QProVacationDO;
import com.elitesland.tw.tw5.server.prd.provacation.model.payload.ProVacationPayload;
import com.elitesland.tw.tw5.server.prd.provacation.model.query.ProVacationQuery;
import com.elitesland.tw.tw5.server.prd.provacation.model.vo.ProVacationVO;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.springframework.stereotype.Component;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.querydsl.core.types.Predicate;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;


import com.querydsl.core.types.ExpressionUtils;

import java.util.ArrayList;


/**
 * @author : WWW
 * @date : 2024-1-24
 * @desc : 项目假期RepoProc
 */
@Component
public class ProVacationDao extends BaseRepoProc<ProVacationDO> {

    private static final QProVacationDO qProVacationDO = QProVacationDO.proVacationDO;


    protected ProVacationDao() {

        super(qProVacationDO);

    }


    public PagingVO<ProVacationVO> page(ProVacationQuery proVacationQuery) {

        JPAQuery<ProVacationVO> query =
                select(ProVacationVO.class)
                        .where(bulidPredicate(proVacationQuery));
        proVacationQuery.setPaging(query);
        proVacationQuery.fillOrders(query, qProVacationDO);
        return PagingVO.<ProVacationVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }


    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(qProVacationDO)
                .set(qProVacationDO.deleteFlag, 1)
                .where(qProVacationDO.id.in(ids))
                .execute();

        return res;

    }


    public ProVacationVO get(Long id) {

        ProVacationVO proVacationVO = select(ProVacationVO.class)
                .where(qProVacationDO.id.eq(id))
                .fetchOne();

        return proVacationVO;

    }


    public List<ProVacationVO> getList(ProVacationQuery proVacationQuery) {

        List<ProVacationVO> res =
                select(ProVacationVO.class)
                        .where(bulidPredicate(proVacationQuery))
                        .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                        qProVacationDO.projectId,
                        qProVacationDO.naturalDate,
                        qProVacationDO.workHours,
                        qProVacationDO.type,
                        qProVacationDO.id,
                        qProVacationDO.createTime,
                        qProVacationDO.remark

                )).from(qProVacationDO);

    }


    private Predicate bulidPredicate(ProVacationQuery proVacationQuery) {

        Predicate predicate = PredicateBuilder.builder()
                .andEq(null != proVacationQuery.getProjectId(), qProVacationDO.projectId, proVacationQuery.getProjectId())
                .andEq(null != proVacationQuery.getNaturalDate(), qProVacationDO.naturalDate, proVacationQuery.getNaturalDate())
                .andEq(null != proVacationQuery.getWorkHours(), qProVacationDO.workHours, proVacationQuery.getWorkHours())
                .andEq(null != proVacationQuery.getType(), qProVacationDO.type, proVacationQuery.getType())
                .andEq(null != proVacationQuery.getYear(), qProVacationDO.naturalDate.year(), proVacationQuery.getYear())
                .andGoe(null != proVacationQuery.getNaturalDateStart(), qProVacationDO.naturalDate, proVacationQuery.getNaturalDateStart())
                .andLoe(null != proVacationQuery.getNaturalDateEnd(), qProVacationDO.naturalDate, proVacationQuery.getNaturalDateEnd())
                .build();

        return predicate;

    }


    private Predicate bulidPredicates(ProVacationQuery proVacationQuery) {

        List<Predicate> predicates = new ArrayList<>();
        // 项目id
        if (null != proVacationQuery.getProjectId()) {
            predicates.add(qProVacationDO.projectId.eq(proVacationQuery.getProjectId()));
        }
        // 日期
        if (null != proVacationQuery.getNaturalDate()) {
            predicates.add(qProVacationDO.naturalDate.eq(proVacationQuery.getNaturalDate()));
        }
        // 工作小时数
        if (null != proVacationQuery.getWorkHours()) {
            predicates.add(qProVacationDO.workHours.eq(proVacationQuery.getWorkHours()));
        }
        // 类型
        if (null != proVacationQuery.getType()) {
            predicates.add(qProVacationDO.type.eq(proVacationQuery.getType()));
        }

        Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicate;
    }


    public Long count(ProVacationQuery proVacationQuery) {

        long res = select(ProVacationVO.class)
                .where(bulidPredicates(proVacationQuery))
                .fetchCount();

        return res;


    }

    public Long update(ProVacationPayload proVacationPayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qProVacationDO);

        // 项目id
        if (null != proVacationPayload.getProjectId()) {
            update.set(qProVacationDO.projectId, proVacationPayload.getProjectId());
        }
        // 日期
        if (null != proVacationPayload.getNaturalDate()) {
            update.set(qProVacationDO.naturalDate, proVacationPayload.getNaturalDate());
        }
        // 工作小时数
        if (null != proVacationPayload.getWorkHours()) {
            update.set(qProVacationDO.workHours, proVacationPayload.getWorkHours());
        }
        // 类型
        if (null != proVacationPayload.getType()) {
            update.set(qProVacationDO.type, proVacationPayload.getType());
        }
        long res = update.where(qProVacationDO.id.eq(proVacationPayload.getId()))
                .execute();
        return res;

    }

    public Long updateVacationByDate(ProVacationDO proVacationDO) {
        JPAUpdateClause update = jpaQueryFactory.update(qProVacationDO);
        long res = update.set(qProVacationDO.workHours, proVacationDO.getWorkHours())
                .where(qProVacationDO.naturalDate.eq(proVacationDO.getNaturalDate()))
                .where(qProVacationDO.projectId.eq(proVacationDO.getProjectId()))
                .execute();
        return res;
    }

    public void delByProId(Long projectId, Integer year) {
        jpaQueryFactory.delete(qProVacationDO)
                .where(qProVacationDO.projectId.eq(projectId))
                .where(qProVacationDO.naturalDate.year().eq(year))
                .execute();
    }
}

