package com.elitesland.tw.tw5.server.prd.provacation.service;

import java.util.List;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.prd.provacation.model.payload.ProVacationPayload;
import com.elitesland.tw.tw5.server.prd.provacation.model.query.ProVacationQuery;
import com.elitesland.tw.tw5.server.prd.provacation.model.vo.ProVacationVO;


/**
 * @author : WWW
 * @date : 2024-1-19
 * @desc : 项目假期Service
 */
public interface ProVacationService {

    /**
     * 新增项目假期数据
     *
     * @param proVacationPayload
     * @return
     */
    ProVacationVO save(ProVacationPayload proVacationPayload);

    /**
     * 批量新增
     *
     * @param proVacationPayloadList
     * @return
     */
    Boolean saveAll(List<ProVacationPayload> proVacationPayloadList, Long projectId, Integer year);

    /**
     * 根据主键更新
     *
     * @param proVacationPayload
     * @return
     */
    ProVacationVO updateAll(ProVacationPayload proVacationPayload);

    /**
     * 根据主键获取详情
     *
     * @param id
     * @return
     */
    ProVacationVO get(Long id);

    /**
     * 分页查询列表
     *
     * @param proVacationQuery
     * @return
     */
    PagingVO<ProVacationVO> page(ProVacationQuery proVacationQuery);

    /**
     * 根据主键批量删除
     *
     * @param ids
     * @return
     */
    Long del(List<Long> ids);

    /**
     * 获取列表查询
     *
     * @param proVacationQuery
     * @return
     */
    List<ProVacationVO> getList(ProVacationQuery proVacationQuery);

    /**
     * 根据条件修改
     *
     * @param proVacationPayload
     * @return
     */
    Long update(ProVacationPayload proVacationPayload);

}

