package com.elitesland.tw.tw5.server.prd.provacation.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.prd.provacation.model.payload.ProVacationSettingPayload;
import com.elitesland.tw.tw5.server.prd.provacation.model.query.ProVacationSettingQuery;
import com.elitesland.tw.tw5.server.prd.provacation.model.vo.ProVacationSettingVO;

import java.util.List;


/**
 * @author : duwh
 * @date : 2024-1-19
 * @desc : 项目假期设置Service
 */
public interface ProVacationSettingService {

    /**
     * 新增项目假期数据
     *
     * @param proVacationPayload
     * @return
     */
    ProVacationSettingVO save(ProVacationSettingPayload proVacationPayload);

    /**
     * 根据主键获取详情
     *
     * @param id
     * @return
     */
    ProVacationSettingVO get(Long id);

    /**
     * 分页查询列表
     *
     * @param proVacationQuery
     * @return
     */
    PagingVO<ProVacationSettingVO> page(ProVacationSettingQuery proVacationQuery);

    /**
     * 根据主键批量删除
     *
     * @param ids
     * @return
     */
    Long del(List<Long> ids);

    /**
     * 获取列表查询
     *
     * @param proVacationQuery
     * @return
     */
    List<ProVacationSettingVO> getList(ProVacationSettingQuery proVacationQuery);

    /**
     * 根据条件修改
     *
     * @param proVacationPayload
     * @return
     */
    Long update(ProVacationSettingPayload proVacationPayload);

}

