package com.elitesland.tw.tw5.server.prd.provacation.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.prd.provacation.convert.ProVacationConvert;
import com.elitesland.tw.tw5.server.prd.provacation.model.entity.ProVacationDO;
import com.elitesland.tw.tw5.server.prd.provacation.model.payload.ProVacationPayload;
import com.elitesland.tw.tw5.server.prd.provacation.model.query.ProVacationQuery;
import com.elitesland.tw.tw5.server.prd.provacation.model.vo.ProVacationVO;
import com.elitesland.tw.tw5.server.prd.provacation.repo.ProVacationRepo;
import com.elitesland.tw.tw5.server.prd.provacation.repo.dao.ProVacationDao;
import com.elitesland.tw.tw5.server.prd.provacation.service.ProVacationService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


/**
 * @author : WWW
 * @date : 2024-1-19
 * @desc : 项目假期Service
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class ProVacationServiceImpl implements ProVacationService {


    private final ProVacationDao proVacationDao;

    private final ProVacationRepo proVacationRepo;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public ProVacationVO save(ProVacationPayload proVacationPayload) {

        checkData(proVacationPayload);
        if (null == proVacationPayload.getWorkHours()) {
            proVacationPayload.setWorkHours(new BigDecimal("8"));
        }

        ProVacationDO proVacationDO = new ProVacationDO();
        proVacationDO = ProVacationConvert.INSTANCE.p2d(proVacationPayload);

        Long count = proVacationDao.updateVacationByDate(proVacationDO);
        // 无更新则新增
        if (count == 0) {
            ProVacationDO res = proVacationRepo.save(proVacationDO);
        }

        return null;

    }

    @Override
//    @Async
    @Transactional
    public Boolean saveAll(List<ProVacationPayload> proVacationPayloadList, Long projectId, Integer year) {

        List<ProVacationDO> insertList = new ArrayList<>();
        Assert.notNull(year, "年份不能为空");
        proVacationDao.delByProId(projectId, year);
        proVacationPayloadList.forEach(x -> {
            checkData(x);
            if (null == x.getWorkHours()) {
                x.setWorkHours(new BigDecimal("8"));
            }

            ProVacationDO proVacationDO = new ProVacationDO();
            proVacationDO = ProVacationConvert.INSTANCE.p2d(x);
            insertList.add(proVacationDO);

        });
        if (CollUtil.isNotEmpty(insertList)) {
            // 批量新增
            proVacationRepo.saveAll(insertList);
        }
        return true;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public ProVacationVO updateAll(ProVacationPayload proVacationPayload) {

        Assert.notNull(proVacationPayload.getId(), "id is null");
        ProVacationVO res = save(proVacationPayload);
        return res;

    }


    @Override
    public ProVacationVO get(Long id) {

        if (null == id) {
            return null;
        }
        ProVacationVO res = proVacationDao.get(id);
        return res;

    }


    @Override
    public PagingVO<ProVacationVO> page(ProVacationQuery proVacationQuery) {

        PagingVO<ProVacationVO> res = proVacationDao.page(proVacationQuery);
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {

        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = proVacationDao.del(ids);
        return res;

    }

    @Override
    public List<ProVacationVO> getList(ProVacationQuery proVacationQuery) {
        Assert.notNull(proVacationQuery.getProjectId(), "项目id不能为空");
        List<ProVacationVO> res = proVacationDao.getList(proVacationQuery);
        return res;

    }


    /**
     * 数据校验
     *
     * @param proVacationPayload
     */
    private void checkData(ProVacationPayload proVacationPayload) {

        Assert.notNull(proVacationPayload.getType(), "类型不能为空");
//        Assert.notNull(proVacationPayload.getYear(), "年份不能为空");
        Assert.notNull(proVacationPayload.getProjectId(), "项目id不能为空");

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long update(ProVacationPayload proVacationPayload) {
        Assert.notNull(proVacationPayload.getId(), "id不能为空");
        Long res = proVacationDao.update(proVacationPayload);
        return res;
    }


}

