package com.elitesland.tw.tw5.server.prd.provacation.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.prd.provacation.convert.ProVacationSettingConvert;
import com.elitesland.tw.tw5.server.prd.provacation.model.entity.ProVacationSettingDO;
import com.elitesland.tw.tw5.server.prd.provacation.model.payload.ProVacationSettingPayload;
import com.elitesland.tw.tw5.server.prd.provacation.model.query.ProVacationSettingQuery;
import com.elitesland.tw.tw5.server.prd.provacation.model.vo.ProVacationSettingVO;
import com.elitesland.tw.tw5.server.prd.provacation.repo.ProVacationSettingRepo;
import com.elitesland.tw.tw5.server.prd.provacation.repo.dao.ProVacationSettingDao;
import com.elitesland.tw.tw5.server.prd.provacation.service.ProVacationSettingService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.List;


/**
 * @author : duwh
 * @date : 2024-1-19
 * @desc : 项目假期设置Service
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class ProVacationSettingServiceImpl implements ProVacationSettingService {


    private final ProVacationSettingDao proVacationSettingDao;

    private final ProVacationSettingRepo proVacationSettingRepo;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public ProVacationSettingVO save(ProVacationSettingPayload payload) {
        checkData(payload);
        if (null == payload.getWorkHours()) {
            payload.setWorkHours(new BigDecimal("8"));
        }
        ProVacationSettingDO entity = ProVacationSettingConvert.INSTANCE.p2d(payload);
        Long count = proVacationSettingDao.countByProjectId(payload.getProjectId(), payload.getYear());
        // 无更新则新增
        if (count == 0) {
            ProVacationSettingDO res = proVacationSettingRepo.save(entity);
            return ProVacationSettingConvert.INSTANCE.d2v(res);
        }
        return null;

    }

    @Override
    public ProVacationSettingVO get(Long id) {
        if (null == id) {
            return null;
        }
        ProVacationSettingVO res = proVacationSettingDao.get(id);
        return res;

    }


    @Override
    public PagingVO<ProVacationSettingVO> page(ProVacationSettingQuery proVacationQuery) {
        PagingVO<ProVacationSettingVO> res = proVacationSettingDao.page(proVacationQuery);
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = proVacationSettingDao.del(ids);
        return res;

    }

    @Override
    public List<ProVacationSettingVO> getList(ProVacationSettingQuery proVacationQuery) {
        Assert.notNull(proVacationQuery.getProjectId(), "项目id不能为空");
        List<ProVacationSettingVO> res = proVacationSettingDao.getList(proVacationQuery);
        return res;

    }


    /**
     * 数据校验
     *
     * @param proVacationPayload
     */
    private void checkData(ProVacationSettingPayload proVacationPayload) {
        Assert.notNull(proVacationPayload.getYear(), "年份不能为空");
        Assert.notNull(proVacationPayload.getProjectId(), "项目id不能为空");
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long update(ProVacationSettingPayload proVacationPayload) {
        Assert.notNull(proVacationPayload.getId(), "id不能为空");
        Long res = proVacationSettingDao.update(proVacationPayload);
        return res;
    }


}

