package com.elitesland.tw.tw5.server.prd.purchase.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 采购合同管理
 *
 * @author lipengfei
 * @date 2023-05-30
 */
@Entity
@Table(name = "t_purchase_contract_details", indexes = {
        @Index(name = "purchase_contract_id_index", columnList = "purchase_contract_id"),
})
@org.hibernate.annotations.Table(appliesTo = "t_purchase_contract_details", comment = "采购合同管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PurchaseContractDetailsDO extends BaseModel implements Serializable  {
    /** 关联产品 */
    @Comment("关联产品")
    @Column()
    private Long relatedProductId;
    /** 采购产品 */
    @Comment("采购产品")
    @Column()
    private String productName;
    /** 产品大类id */
    @Comment("产品大类id")
    @Column()
    private Long classId;
    /** 产品小类id */
    @Comment("产品小类id")
    @Column()
    private Long subClassId;
    /** 采购合同id */
    @Comment("采购合同id")
    @Column(name = "purchase_contract_id")
    private Long purchaseContractId;
    /** 采购合同编号 */
    @Comment("采购合同编号")
    @Column()
    private String purchaseContractNo;
    /** 数量 */
    @Comment("数量")
    @Column()
    private BigDecimal quantity;
    /** 含税单价 */
    @Comment("含税单价")
    @Column()
    private BigDecimal taxPrice;
    /** 税率 */
    @Comment("税率")
    @Column()
    private String taxRate;
    /** 含税总额 */
    @Comment("含税总额")
    @Column()
    private BigDecimal taxAmt;
    /** 不含税总额 */
    @Comment("不含税总额")
    @Column()
    private BigDecimal taxNotAmt;
    /** 交期 */
    @Comment("交期")
    @Column()
    private LocalDateTime deliveryDate;
    /** 说明 */
    @Comment("说明")
    @Column()
    private String note;

    @Comment("4.0采购合同明细id")
    @Column()
    private Long purchaseContractDetailIdV4;

    /**
     * 需求明细ID
     */
    @Comment("需求明细ID")
    @Column()
    private Long purchaseDemandId;

    /**
     * 渠道费用明细
     */
    @Comment("渠道费用明细")
    @Column()
    private Long conEpibolyCostConDId;

    public void copy(PurchaseContractDetailsDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
