package com.elitesland.tw.tw5.server.purchase.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseAgreementResPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseAgreementResQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseAgreementResService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseAgreementResVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseAgreementVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.purchase.convert.PurchaseAgreementResConvert;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PurchaseAgreementDAO;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PurchaseAgreementResDAO;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchaseAgreementEnum;
import com.elitesland.tw.tw5.server.prd.purchase.repo.PurchaseAgreementResRepo;
import com.elitesland.tw.tw5.server.prd.purchase.entity.PurchaseAgreementResDO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 采购协议关联资源
 *
 * @author lemon
 * @date 2023-11-02
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PurchaseAgreementResServiceImpl extends BaseServiceImpl implements PurchaseAgreementResService {

    private final PurchaseAgreementResRepo purchaseAgreementResRepo;
    private final PurchaseAgreementResDAO purchaseAgreementResDAO;
    private final PurchaseAgreementDAO purchaseAgreementDAO;

    private final CacheUtil cacheUtil;

    @Override
    public PagingVO<PurchaseAgreementResVO> queryPaging(PurchaseAgreementResQuery query){
        return purchaseAgreementResDAO.queryPaging(query);
    }

    @Override
    public List<PurchaseAgreementResVO> queryListDynamic(PurchaseAgreementResQuery query){
        return purchaseAgreementResDAO.queryListDynamic(query);
    }

    @Override
    public PurchaseAgreementResVO queryByKey(Long key) {
        PurchaseAgreementResDO entity = purchaseAgreementResRepo.findById(key).orElseGet(PurchaseAgreementResDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PurchaseAgreementResVO vo = PurchaseAgreementResConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PurchaseAgreementResVO insert(PurchaseAgreementResPayload payload) {
        //关联资源的资源日期不允许交叉检查
        String checkAgreementResResult = checkAgreementRes(Collections.singletonList(payload));
        if (StringUtils.hasText(checkAgreementResResult)) {
            throw TwException.error("", checkAgreementResResult);
        }
        PurchaseAgreementResDO entityDo = PurchaseAgreementResConvert.INSTANCE.toDo(payload);
        return PurchaseAgreementResConvert.INSTANCE.toVo(purchaseAgreementResRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PurchaseAgreementResVO update(PurchaseAgreementResPayload payload) {
        PurchaseAgreementResDO entity = purchaseAgreementResRepo.findById(payload.getId()).orElseGet(PurchaseAgreementResDO::new);
        Assert.notNull(entity.getId(), "不存在");
        //关联资源的资源日期不允许交叉检查
        String checkAgreementResResult = checkAgreementRes(Collections.singletonList(payload));
        if (StringUtils.hasText(checkAgreementResResult)) {
            throw TwException.error("", checkAgreementResResult);
        }
        PurchaseAgreementResDO entityDo = PurchaseAgreementResConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PurchaseAgreementResConvert.INSTANCE.toVo(purchaseAgreementResRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PurchaseAgreementResPayload payload) {
        PurchaseAgreementResDO entity = purchaseAgreementResRepo.findById(payload.getId()).orElseGet(PurchaseAgreementResDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = purchaseAgreementResDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            purchaseAgreementResDAO.deleteSoft(keys);
        }
    }

    @Override
    public void deleteSoftByDocumentIdList(List<Long> documentIdList) {
        purchaseAgreementResDAO.deleteSoftByDocumentIdList(documentIdList);
    }

    private String checkAgreementRes(List<PurchaseAgreementResPayload> payloadList) {
        StringBuilder checkAgreementResResult = new StringBuilder();
        String closeStatus = PurchaseAgreementEnum.AgreementStatus.CLOSE.getCode();
        for (PurchaseAgreementResPayload resPayload : payloadList) {
            Long resId = resPayload.getResId();
            PrdOrgEmployeeVO employee = cacheUtil.getEmployee(resId);
            PurchaseAgreementResQuery query = new PurchaseAgreementResQuery();
            query.setResId(resId);
            List<PurchaseAgreementResVO> purchaseAgreementResVOS = purchaseAgreementResDAO.queryListDynamic(query);
            //判断是否是自己,自己过滤
            Map<Long,List<PurchaseAgreementResVO>> resViewMaps = purchaseAgreementResVOS.stream().filter(resView-> !Objects.equals(resPayload.getId(),resView.getId()))
                    .collect(Collectors.groupingBy(PurchaseAgreementResVO::getDocumentId));
            for (Map.Entry<Long, List<PurchaseAgreementResVO>> entry : resViewMaps.entrySet()) {
                PurchaseAgreementVO purchaseAgreementVO = purchaseAgreementDAO.queryByKey(entry.getKey());
                if (!Objects.isNull(purchaseAgreementVO) && !Objects.equals(purchaseAgreementVO.getAgreementStatus(), closeStatus)) {
                    List<PurchaseAgreementResVO> resViews = entry.getValue();
                    for (PurchaseAgreementResVO resView : resViews) {
                        boolean checkIsAfterEntity = resPayload.getResStartDate().isBefore(resView.getResEndDate().plusDays(1));
                        boolean checkIsAfterView = resView.getResStartDate().isBefore(resPayload.getResEndDate().plusDays(1));
                        if (checkIsAfterEntity && checkIsAfterView) {
                            checkAgreementResResult.append(employee.getEmployeeName()).append("-").append(purchaseAgreementVO.getPurchaseAgreementName()).append("关联资源的期间存在交叉;");
                            break;
                        }
                    }
                }
            }
        }

        return String.valueOf(checkAgreementResResult);
    }
}
