package com.elitesland.tw.tw5.server.prd.salecon.controller;

import com.elitesland.tw.tw5.api.prd.salecon.payload.ConServicePricePayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConServicePriceQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConServicePriceVO;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConServicePriceService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 销售合同-T&M-服务价格
 *
 * @author sam.li
 * @date 2024-05-07
 */
@Api(tags = "销售合同-T&M-服务价格")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/conServicePrice")
@Slf4j
public class ConServicePriceController {

private final ConServicePriceService conServicePriceService;

    /**
     * 销售合同-T&M-服务价格-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("销售合同-T&M-服务价格-新增")
    public TwOutputUtil<ConServicePriceVO> insert(@RequestBody ConServicePricePayload payload){
         return TwOutputUtil.ok(conServicePriceService.insert(payload));
    }

    /**
     * 销售合同-T&M-服务价格-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("销售合同-T&M-服务价格-更新")
    public TwOutputUtil<ConServicePriceVO> update(@RequestBody ConServicePricePayload payload){
        return TwOutputUtil.ok(conServicePriceService.update(payload));
    }

    /**
     * 销售合同-T&M-服务价格-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("销售合同-T&M-服务价格-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody ConServicePricePayload payload){
        return TwOutputUtil.ok(conServicePriceService.updateByKeyDynamic(payload));
    }

    /**
     * 销售合同-T&M-服务价格-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("销售合同-T&M-服务价格-主键查询")
    public TwOutputUtil<ConServicePriceVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(conServicePriceService.queryByKey(key));
    }

    /**
     * 销售合同-T&M-服务价格-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("销售合同-T&M-服务价格-分页")
    public TwOutputUtil<PagingVO<ConServicePriceVO>> paging(ConServicePriceQuery query) {
        return TwOutputUtil.ok(conServicePriceService.queryPaging(query));
    }

    /**
     * 销售合同-T&M-服务价格-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("销售合同-T&M-服务价格-查询列表")
    public TwOutputUtil<List<ConServicePriceVO>> queryList(ConServicePriceQuery query) {
        return TwOutputUtil.ok(conServicePriceService.queryListDynamic(query));
    }

    /**
     * 销售合同-T&M-服务价格-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("销售合同-T&M-服务价格-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         conServicePriceService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping("/updateBySaleConId")
    @ApiOperation("销售合同-T&M-服务价格-通过合同id更新结算周期和方式")
    public TwOutputUtil updateBySaleConId(Long saleConId, String settlementCycle, String settlementMethod) {
        conServicePriceService.updateBySaleConId(saleConId,settlementCycle,settlementMethod);
        return TwOutputUtil.ok();
    }
}

