package com.elitesland.tw.tw5.server.prd.salecon.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseContractManagerVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.SaleConContractPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.SaleConContractQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractListVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.constants.SaleConContractPaperStatusEnum;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SaleConEnum;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOpportunityDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.QBusinessPartnerDO;
import com.elitesland.tw.tw5.server.prd.partner.identity.entity.QBusinessCustomerInfoDO;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectDO;
import com.elitesland.tw.tw5.server.prd.prj.entity.QPrjProjectDO;
import com.elitesland.tw.tw5.server.prd.product.entity.QPrdProductDO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.QPurchaseContractManagerDO;
import com.elitesland.tw.tw5.server.prd.salecon.convert.SaleConContractConvert;
import com.elitesland.tw.tw5.server.prd.salecon.entity.*;
import com.elitesland.tw.tw5.server.prd.salecon.repo.SaleConContractRepo;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemFinPeriodDO;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * 销售合同
 *
 * @author danting
 * @date 2023-03-30
 */
@Slf4j
@Repository
@RequiredArgsConstructor
public class SaleConContractDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final SaleConContractRepo repo;
    private final QSaleConContractDO qdo = QSaleConContractDO.saleConContractDO;
    //自连接一定要起一个别名
    //qdo1 是父表  qdo2 是关联合同表
    private final QSaleConContractDO qdo1 = new QSaleConContractDO("qdo1");
    private final QSaleConContractDO qdo2 = new QSaleConContractDO("qdo2");
    private final QCrmOpportunityDO qdoOppo = QCrmOpportunityDO.crmOpportunityDO;

    private final QPrjProjectDO qdoProj = QPrjProjectDO.prjProjectDO;

    // private final QPrdOrgCompanyDO qdoCompany = QPrdOrgCompanyDO.prdOrgCompanyDO;

    //财务期间表
    private final QPrdSystemFinPeriodDO qdoFinPeriod = QPrdSystemFinPeriodDO.prdSystemFinPeriodDO;
    //业绩统计表
    private final QConAchieveDO qConAchieve = QConAchieveDO.conAchieveDO;
    //业绩统计明细表
    private final QConAchieveDDO qConAchieveD = QConAchieveDDO.conAchieveDDO;

    private final QPrdOrgEmployeeRefDO qdoRef = QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;
    private final QPurchaseContractManagerDO purcConDao = QPurchaseContractManagerDO.purchaseContractManagerDO;
    private final QConPurchaseDemandDO demandDO = QConPurchaseDemandDO.conPurchaseDemandDO;
    private final QConPurchaseDemandDDO demandDDO = QConPurchaseDemandDDO.conPurchaseDemandDDO;
    private final QPrdProductDO productDO = QPrdProductDO.prdProductDO;
    private final QPmsProjectDO projectDO = QPmsProjectDO.pmsProjectDO;
    // private final QPrdAbDO prdAbDO = QPrdAbDO.prdAbDO;
    private final QSaleConExecConditionDO conConditionDO = QSaleConExecConditionDO.saleConExecConditionDO;

    private final QBusinessPartnerDO qBusinessPartnerDO = QBusinessPartnerDO.businessPartnerDO;
    private final QBusinessPartnerDO qBusinessPartnerOuDO = new QBusinessPartnerDO("qBusinessPartnerOuDO");
    private final QBusinessCustomerInfoDO qBusinessCustomerInfoDO = QBusinessCustomerInfoDO.businessCustomerInfoDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<SaleConContractVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(SaleConContractVO.class,
                        qdo.id,
                        qdo.remark,
                        qdo.createUserId,
                        qdo.creator,
                        qdo.createTime,
                        qdo.modifyUserId,
                        qdo.updater,
                        qdo.modifyTime,
                        // 附件
                        qdo.fileCodes,
                        // 合同编号
                        qdo.code,
                        // 合同名称
                        qdo.name,
                        // 合同状态
                        qdo.status,
                        // 签约公司ID
                        // qdo.ouId,
                        qdo.ouBookId,
                        // 签约公司名称
                        qBusinessPartnerOuDO.partnerName.as("ouName"),
                        // 参考合同号
                        qdo.referCode,
                        // 商机ID
                        qdo.oppoId,
                        // 商机名称
                        qdoProj.projectName.as("oppoName"),
                        // 商机编号
                        qdoProj.projectNo.as("oppoNo"),
                        projectDO.projName.as("projName"),
                        projectDO.id.as("projId"),
                        projectDO.projNo.as("projCode"),
                        // 客户ID
                        qdo.custId,
//                        // 业务伙伴ID
//                        qdo.partnerId,
                        // 签约时客户名称
                        qBusinessPartnerDO.partnerName.as("custName"),
                        // 关联合同ID
                        qdo.relatedContractId,
                        // 关联合同Code
                        qdo2.code.as("relatedContractCode"),
                        // 关联合同Name
                        qdo2.name.as("relatedContractName"),
                        // 新客户标志，0：新客户，1：老客户
                        qdo.custFlag,
                        // 签订日期
                        qdo.signDate,
                        // 特别关注点
                        qdo.specialConcerned,
                        // 币种
                        qdo.currCode,
                        // 关闭原因
                        qdo.closeReason,
                        // 客户项目
                        qdo.custProj,
                        // 销售内容
                        qdo.saleContent,
                        // 产品大类
                        qdo.productClass,
                        // 产品小类
                        qdo.productSubClass,
                        // 交付地点
                        qdo.deliveryAddress,
                        // 财务期间ID
                        qdo.finPeriodId,
                        // 财务期间Name
                        qdoFinPeriod.periodName.as("finPeriodName"),
                        // 合同总金额
                        qdo.amt,
                        // 其它费用
                        qdo.extraAmt,
                        // 有效合同金额
                        qdo.effectiveAmt,
                        // 毛利
                        qdo.grossProfit,
                        // 销售区域BU_ID
                        qdo.regionBuId,
                        // 销售区域负责人
                        qdo.regionUserId,
                        // 签单BU_ID
                        qdo.signBuId,
                        // 销售负责人ID
                        qdo.saleManUserId,
                        // 销售负责人的bu
                        qdoRef.orgId.as("saleManUserBuId"),
                        // 副签单BU_ID
                        qdo.coSignBuId,
                        // 副签单用户id
                        qdo.coSignUserId,
                        // 交付BU_ID
                        qdo.deliBuId,
                        // 交付用户id
                        qdo.deliUserId,
                        // 副交付BU_ID
                        qdo.codeliBuId,
                        // 副交付用户id
                        qdo.codeliUserId,
                        // 平台合同类型
                        qdo.platType,
                        // 主合同类型
                        qdo.mainType,
                        // PMO用户ID
                        qdo.pmoUserId,
                        // 来源类型
                        qdo.sourceType,
                        // 外部来源
                        qdo.externalIden,
                        // 外部来源人
                        qdo.externalName,
                        // 外部来源电话
                        qdo.externalPhone,
                        // 内部来源BU_ID
                        qdo.internalBuId,
                        // 利益承诺
                        qdo.profitDesc,
                        // 税率
                        qdo.taxRate,
                        // 内部来源用户ID
                        qdo.internalUserId,
                        // 合同开始日期
                        qdo.startDate,
                        // 合同结束日期
                        qdo.endDate,
                        // 纸质合同状态描述
                        qdo.paperDesc,
                        // 纸质合同状态
                        qdo.paperStatus,
                        // 合同激活时间
                        qdo.acitveDate,
                        // 产品
                        qdo.product,
                        // 简要说明
                        qdo.briefDesc,
                        // 工作类型
                        qdo.workType,
                        // 促销类型
                        qdo.promotionType,
                        // 范围性质
                        qdo.rangeProp,
                        // 半开口说明
                        qdo.halfOpenDesc,
                        // 供应主体类别
                        qdo.supplierType,
                        // 提成类别
                        qdo.commissionType,
                        // 交易方式
                        qdo.transactionMethod,
                        // 交易性质
                        qdo.transactionNature,
                        // 需求类别
                        qdo.demandType,
                        // 销售分类
                        qdo.saleClass,
                        // 客户承担差旅费
                        qdo.custBarExpense,
                        // 报销政策说明
                        qdo.reimbursementDesc,
                        // 额定当量
                        qdo.ratedEqva,
                        // 额定费用
                        qdo.ratedExpense,
                        // 合同打印方
                        qdo.contractPrinter,
                        // 打印份数
                        qdo.printCount,
                        // 盖章类型
                        qdo.sealType,
                        // 和发票一起邮寄，0：是，1：否
                        qdo.sendWithInvoiceFlag,
                        // 邮寄地址
                        qdo.mailingAddress,
                        // 父ID
                        qdo.parentId,
                        // 父合同名称
                        qdo1.name.as("parentName"),
                        qdo1.folderId.as("parentFolderId"),
                        // 业绩统计状态
                        qConAchieve.achieveStatus,
                        // 合同归档标志
                        qdo.filingFlag,
                        // SOW附件
                        qdo.sowFileCodes,
                        // 估算申请单附件
                        qdo.assessFileCodes,
                        // 合同关闭附件
                        qdo.closeFileCodes,
                        qdo.folderId,
                        qdo.closeDate,
                        qdo.preSaleBuId,
                        qdo.preSaleUserId,
                        qdo.finGross,
                        qdo.sysGross,
                        qdo.finRatedEqva,
                        qdo.netRate,
                        qdo.ratedCost,
                        qdo.procInstId,
                        qdo.jdeStatus,
                        qdo.jdeFailReason,
                        qdo.agentFlag,
                        qdo.agentProportion,
                        qdo.agentAmt,
                        // 平台提成比例
                        qdo.percentage,
                        qdo.ext1,
                        qdo.ext2,
                        qdo.ext3,
                        qdo.ext4,
                        qdo.ext5,
                        qdo.receiveTime
                )).from(qdo)
                .distinct()
//                .leftJoin(projectDO).on(qdo.id.longValue().eq(projectDO.contractId.longValue()).and(projectDO.deleteFlag.eq(0)))
                .leftJoin(qdoOppo).on(qdo.oppoId.longValue().eq(qdoOppo.id.longValue()).and(qdoOppo.deleteFlag.eq(0)))
                .leftJoin(qdoProj).on(qdoOppo.projectId.longValue().eq(qdoProj.id.longValue()).and(qdoProj.projectType.eq("opportunity")))
                .leftJoin(projectDO).on(projectDO.contractId.longValue().eq(qdo.id.longValue()))
                //todo wly
                .leftJoin(qBusinessPartnerOuDO).on(qBusinessPartnerOuDO.bookId.longValue().eq(qdo.ouBookId.longValue()))
                .leftJoin(qdo1).on(qdo1.id.longValue().eq(qdo.parentId.longValue()))
                .leftJoin(qdo2).on(qdo.relatedContractId.longValue().eq(qdo2.id.longValue()))
                // .leftJoin(prdAbDO).on(qdo.custId.longValue().eq(prdAbDO.id.longValue()))
                .leftJoin(qBusinessPartnerDO).on(qdo.custId.eq(qBusinessPartnerDO.bookId))
                .leftJoin(qdoFinPeriod).on(qdoFinPeriod.id.longValue().eq(qdo.finPeriodId.longValue()))
                .leftJoin(qConAchieve).on(qConAchieve.contractId.longValue().eq(qdo.id.longValue()))
                .leftJoin(qdoRef).on(qdo.saleManUserId.longValue().eq(qdoRef.userId.longValue()).and(qdoRef.isDefault.eq(0)).and(qdoRef.isCopy.eq(0)).and(qdoRef.deleteFlag.eq(0)))
                .leftJoin(conConditionDO).on(qdo.id.longValue().eq(conConditionDO.contractId.longValue()).and(conConditionDO.deleteFlag.eq(0)));
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<SaleConContractListVO> getJpaQuerySelectList() {
        return jpaQueryFactory.select(Projections.bean(SaleConContractListVO.class,
                qdo.id,
                // 合同编号
                qdo.code,
                // 合同名称
                qdo.name,
                // 合同状态
                qdo.status,
                qdo.workType,
                qdo.oppoId,
                //售前负责人
                qdo.preSaleUserId,
                //销售负责人
                qdo.saleManUserId,
                //合同总金额
                qdo.amt,
                //合同有效金额
                qdo.effectiveAmt,
                // 合同归档标志
                qdo.filingFlag
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<SaleConContractVO> getJpaQueryWhere(SaleConContractQuery query) {
        JPAQuery<SaleConContractVO> jpaQuery = getJpaQuerySelect();
        if (!ObjectUtils.isEmpty(query.getAchieveBuId()) || !ObjectUtils.isEmpty(query.getValueRole()) ||
                !ObjectUtils.isEmpty(query.getChargeResId())) {
            jpaQuery.leftJoin(qConAchieveD).on(qConAchieveD.achieveId.longValue().eq(qConAchieve.id.longValue()));
        }
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        jpaQuery.groupBy(qdo.id);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

//    /**
//     * 拼装查询字段
//     *
//     * @return jpaQuery对象
//     */
//    private JPAQuery<SaleConContractVO> getJpaQuerySelectPagingList() {
//        return jpaQueryFactory.select(Projections.bean(SaleConContractVO.class,
//                        qdo.id,
//                        qdo.remark,
//                        qdo.createUserId,
//                        qdo.creator,
//                        qdo.createTime,
//                        qdo.modifyUserId,
//                        qdo.updater,
//                        qdo.modifyTime,
//                        // 合同编号
//                        qdo.code,
//                        // 合同名称
//                        qdo.name,
//                        // 参考合同号
//                        qdo.referCode,
//                        // 客户ID
//                        qdo.custId,
//                        // 合同状态
//                        qdo.status,
//                        // 平台合同类型
//                        qdo.platType,
//                        // 合同类型
//                        qdo.mainType,
//                        // 合同金额
//                        qdo.amt,
//                        // 有效合同金额
//                        qdo.effectiveAmt,
//                        // 销售区域BU_ID
//                        qdo.regionBuId,
//                        // 签单BU_ID
//                        qdo.signBuId,
//                        // 交付BU_ID
//                        qdo.deliBuId,
//                        // 销售负责人ID
//                        qdo.saleManUserId,
//                        // 交付用户id
//                        qdo.deliUserId,
//                        // 纸质合同状态
//                        qdo.paperStatus,
//                        // PMO用户ID
//                        qdo.pmoUserId,
//                        // 签订日期
//                        qdo.signDate,
//                        // 合同归档标志
//                        qdo.filingFlag,
//                        // 商机ID
//                        qdo.oppoId,
//                        // 商机名称
//                        qdoProj.projectName.as("oppoName"),
//                        // 商机编号
//                        qdoProj.projectNo.as("oppoNo"),
//                        projectDO.projName.as("projName"),
//                        projectDO.projNo.as("projCode"),
//                        // 产品大类
//                        qdo.productClass,
//                        // 利益承诺
//                        qdo.profitDesc,
//                        // 业绩统计状态
//                        qConAchieve.achieveStatus,
//                        // 来源类型
//                        qdo.sourceType,
//                        // 客户名称
//                        prdAbDO.bookName.as("custName")
//                )).from(qdo)
//                .distinct()
//                .leftJoin(qdoOppo).on(qdo.oppoId.longValue().eq(qdoOppo.id.longValue()).and(qdoOppo.deleteFlag.eq(0)))
//                .leftJoin(qdoProj).on(qdoOppo.projectId.longValue().eq(qdoProj.id.longValue()).and(qdoProj.projectType.eq("opportunity")))
//                .leftJoin(projectDO).on(projectDO.contractId.longValue().eq(qdoProj.id.longValue()))
//                .leftJoin(qConAchieve).on(qConAchieve.contractId.longValue().eq(qdo.id.longValue()))
//                .leftJoin(prdAbDO).on(qdo.custId.longValue().eq(prdAbDO.id.longValue()));
//    }

//    /**
//     * 拼装查询条件
//     *
//     * @param query 查询参数
//     * @return jpaQuery对象
//     */
//    private JPAQuery<SaleConContractVO> getJpaQueryWhere(SaleConContractQuery query) {
//        JPAQuery<SaleConContractVO> jpaQuery = getJpaQuerySelectPagingList();
//        if (!ObjectUtils.isEmpty(query.getAchieveBuId()) || !ObjectUtils.isEmpty(query.getValueRole()) ||
//                !ObjectUtils.isEmpty(query.getChargeResId())) {
//            jpaQuery.leftJoin(qConAchieveD).on(qConAchieveD.achieveId.longValue().eq(qConAchieve.id.longValue()));
//        }
//        // 条件封装
//        jpaQuery.where(where(query));
//        // 常用基础查询条件拼装
//        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
//        jpaQuery.groupBy(qdo.id);
//        // 动态排序S
//        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
//        return jpaQuery;
//    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(SaleConContractQuery query) {
        long total = getJpaQueryWhere(query).fetch().size();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(SaleConContractQuery query) {
        log.info("销售合同分页dao层入参合同名称 is {},合同状态 is {}", query.getName(), query.getStatusList());
        List<Predicate> list = new ArrayList<>();
        list.add(qdo.deleteFlag.eq(0));
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 记录唯一ID 精确 */
        if (!CollectionUtils.isEmpty(query.getIds())) {
            list.add(qdo.id.in(query.getIds()));
        }
        /** 合同编号 模糊 */
        if (!ObjectUtils.isEmpty(query.getCode())) {
            list.add(qdo.code.like(SqlUtil.toSqlLikeString(query.getCode())));
        }
        /** 合同名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getName())) {
            log.info("query getName is {}", query.getName());
            list.add(qdo.name.like(SqlUtil.toSqlLikeString(query.getName())));
        }
        /** 合同名称 精确 */
        if (!ObjectUtils.isEmpty(query.getEqName())) {
            list.add(qdo.name.eq(SqlUtil.toSqlLikeString(query.getEqName())));
        }
        /** 合同状态 精确 */
        if (!ObjectUtils.isEmpty(query.getStatus())) {
            list.add(qdo.status.eq(query.getStatus()));
        }
        /** 合同状态 精确 */
        if (!CollectionUtils.isEmpty(query.getStatusList()) && query.getStatusList().size() == 2) {
            log.info("query getStatusList is {}", query.getStatusList());
            if ("0".equals(query.getStatusList().get(0))) {
                list.add(qdo.status.eq(query.getStatusList().get(1)));
            } else if ("1".equals(query.getStatusList().get(0))) {
                list.add(qdo.status.notEqualsIgnoreCase(query.getStatusList().get(1)));
            }
        }
        /** 签约公司ID 精确 */
        if (!ObjectUtils.isEmpty(query.getOuBookId())) {
            list.add(qdo.ouBookId.eq(query.getOuBookId()));
        }
        /** 参考合同号 模糊 */
        if (!ObjectUtils.isEmpty(query.getReferCode())) {
            list.add(qdo.referCode.like(SqlUtil.toSqlLikeString(query.getReferCode())));
        }
        /** 商机ID 精确 */
        if (!ObjectUtils.isEmpty(query.getOppoId())) {
            list.add(qdo.oppoId.eq(query.getOppoId()));
        }
        /** 客户ID 精确 */
        if (!ObjectUtils.isEmpty(query.getCustId())) {
            list.add(qdo.custId.eq(query.getCustId()));
        }
        /** 客户ID集合 精确 */
        if (!CollectionUtils.isEmpty(query.getCustIdList())) {
            list.add(qdo.custId.in(query.getCustIdList()));
        }

        /** 签约时客户名称 精确 */
        if (!ObjectUtils.isEmpty(query.getCustName())) {
            list.add(qdo.custName.eq(query.getCustName()));
        }
        /** 关联合同ID 精确 */
        if (!ObjectUtils.isEmpty(query.getRelatedContractId())) {
            list.add(qdo.relatedContractId.eq(query.getRelatedContractId()));
        }
        /** 新客户标志，0：新客户，1：老客户 精确 */
        if (!ObjectUtils.isEmpty(query.getCustFlag())) {
            list.add(qdo.custFlag.eq(query.getCustFlag()));
        }
        /** 签订日期 精确 */
        if (!ObjectUtils.isEmpty(query.getSignDate())) {
            list.add(qdo.signDate.eq(query.getSignDate()));
        }
        /** 签订日期范围 精确 */
        if (!ObjectUtils.isEmpty(query.getSignDateStart()) && !ObjectUtils.isEmpty(query.getSignDateEnd())) {
            list.add(qdo.signDate.between(query.getSignDateStart(), query.getSignDateEnd()));
        }
        /** 签订年度 精确 */
        if (!ObjectUtils.isEmpty(query.getSignYear())) {
            list.add(qdo.signDate.year().eq(query.getSignYear().intValue()));
        }
        /** 特别关注点 精确 */
        if (!ObjectUtils.isEmpty(query.getSpecialConcerned())) {
            list.add(qdo.specialConcerned.eq(query.getSpecialConcerned()));
        }
        /** 币种 精确 */
        if (!ObjectUtils.isEmpty(query.getCurrCode())) {
            list.add(qdo.currCode.eq(query.getCurrCode()));
        }
        /** 关闭原因 精确 */
        if (!ObjectUtils.isEmpty(query.getCloseReason())) {
            list.add(qdo.closeReason.eq(query.getCloseReason()));
        }
        /** 客户项目 精确 */
        if (!ObjectUtils.isEmpty(query.getCustProj())) {
            list.add(qdo.custProj.eq(query.getCustProj()));
        }
        /** 销售内容 精确 */
        if (!ObjectUtils.isEmpty(query.getSaleContent())) {
            list.add(qdo.saleContent.eq(query.getSaleContent()));
        }
        /** 产品大类 精确 */
        if (!ObjectUtils.isEmpty(query.getProductClass())) {
            list.add(qdo.productClass.eq(query.getProductClass()));
        }
        /** 产品小类 精确 */
        if (!ObjectUtils.isEmpty(query.getProductSubClass())) {
            list.add(qdo.productSubClass.eq(query.getProductSubClass()));
        }
        /** 交付地点 精确 */
        if (!ObjectUtils.isEmpty(query.getDeliveryAddress())) {
            list.add(qdo.deliveryAddress.eq(query.getDeliveryAddress()));
        }
        /** 财务期间ID 精确 */
        if (!ObjectUtils.isEmpty(query.getFinPeriodId())) {
            list.add(qdo.finPeriodId.eq(query.getFinPeriodId()));
        }
        /** 合同总金额 精确 */
        if (!ObjectUtils.isEmpty(query.getAmt())) {
            list.add(qdo.amt.eq(query.getAmt()));
        }
        /** 其它费用 精确 */
        if (!ObjectUtils.isEmpty(query.getExtraAmt())) {
            list.add(qdo.extraAmt.eq(query.getExtraAmt()));
        }
        /** 有效合同金额 精确 */
        if (!ObjectUtils.isEmpty(query.getEffectiveAmt())) {
            list.add(qdo.effectiveAmt.eq(query.getEffectiveAmt()));
        }
        /** 毛利 精确 */
        if (!ObjectUtils.isEmpty(query.getGrossProfit())) {
            list.add(qdo.grossProfit.eq(query.getGrossProfit()));
        }
        /** 销售区域BU_ID 精确 */
        if (!ObjectUtils.isEmpty(query.getRegionBuId())) {
            list.add(qdo.regionBuId.eq(query.getRegionBuId()));
        }
        /** 销售区域负责人 精确 */
        if (!ObjectUtils.isEmpty(query.getRegionUserId())) {
            list.add(qdo.regionUserId.eq(query.getRegionUserId()));
        }
        /** 签单BU_ID 精确 */
        if (!ObjectUtils.isEmpty(query.getSignBuId())) {
            list.add(qdo.signBuId.eq(query.getSignBuId()));
        }
        /** 销售人员用户ID 精确 */
        if (!ObjectUtils.isEmpty(query.getSaleManUserId())) {
            list.add(qdo.saleManUserId.eq(query.getSaleManUserId()));
        }
        /** 副签单BU_ID 精确 */
        if (!ObjectUtils.isEmpty(query.getCoSignBuId())) {
            list.add(qdo.coSignBuId.eq(query.getCoSignBuId()));
        }
        /** 副签单用户id 精确 */
        if (!ObjectUtils.isEmpty(query.getCoSignUserId())) {
            list.add(qdo.coSignUserId.eq(query.getCoSignUserId()));
        }
        /** 交付BU_ID 精确 */
        if (!ObjectUtils.isEmpty(query.getDeliBuId())) {
            list.add(qdo.deliBuId.eq(query.getDeliBuId()));
        }
        /** 交付用户id 精确 */
        if (!ObjectUtils.isEmpty(query.getDeliUserId())) {
            list.add(qdo.deliUserId.eq(query.getDeliUserId()));
        }
        /** 副交付BU_ID 精确 */
        if (!ObjectUtils.isEmpty(query.getCodeliBuId())) {
            list.add(qdo.codeliBuId.eq(query.getCodeliBuId()));
        }
        /** 副交付用户id 精确 */
        if (!ObjectUtils.isEmpty(query.getCodeliUserId())) {
            list.add(qdo.codeliUserId.eq(query.getCodeliUserId()));
        }
        /** 平台合同类型 精确 */
        if (!ObjectUtils.isEmpty(query.getPlatType())) {
            list.add(qdo.platType.eq(query.getPlatType()));
        } else {
            // 默认隐藏虚拟合同
            list.add(qdo.platType.ne(SaleConEnum.FICTITIOUS.getCode()));
        }
        /** 主合同类型 精确 */
        if (!ObjectUtils.isEmpty(query.getMainType())) {
            list.add(qdo.mainType.eq(query.getMainType()));
        }
        /** PMO用户ID 精确 */
        if (!ObjectUtils.isEmpty(query.getPmoUserId())) {
            list.add(qdo.pmoUserId.eq(query.getPmoUserId()));
        }
        /** 来源类型 精确 */
        if (!ObjectUtils.isEmpty(query.getSourceType())) {
            list.add(qdo.sourceType.eq(query.getSourceType()));
        }
        /** 外部来源 精确 */
        if (!ObjectUtils.isEmpty(query.getExternalIden())) {
            list.add(qdo.externalIden.eq(query.getExternalIden()));
        }
        /** 外部来源人 精确 */
        if (!ObjectUtils.isEmpty(query.getExternalName())) {
            list.add(qdo.externalName.eq(query.getExternalName()));
        }
        /** 外部来源电话 精确 */
        if (!ObjectUtils.isEmpty(query.getExternalPhone())) {
            list.add(qdo.externalPhone.eq(query.getExternalPhone()));
        }
        /** 内部来源BU_ID 精确 */
        if (!ObjectUtils.isEmpty(query.getInternalBuId())) {
            list.add(qdo.internalBuId.eq(query.getInternalBuId()));
        }
        /** 利益承诺 精确 */
        if (!ObjectUtils.isEmpty(query.getProfitDesc())) {
            list.add(qdo.profitDesc.eq(query.getProfitDesc()));
        }
        /** 税率 精确 */
        if (!ObjectUtils.isEmpty(query.getTaxRate())) {
            list.add(qdo.taxRate.eq(query.getTaxRate()));
        }
        /** 内部来源用户ID 精确 */
        if (!ObjectUtils.isEmpty(query.getInternalUserId())) {
            list.add(qdo.internalUserId.eq(query.getInternalUserId()));
        }
        /** 合同开始日期 精确 */
        if (!ObjectUtils.isEmpty(query.getStartDate())) {
            list.add(qdo.startDate.eq(query.getStartDate()));
        }
        /** 合同结束日期 精确 */
        if (!ObjectUtils.isEmpty(query.getEndDate())) {
            list.add(qdo.endDate.eq(query.getEndDate()));
        }
        /** 纸质合同状态描述 精确 */
        if (!ObjectUtils.isEmpty(query.getPaperDesc())) {
            list.add(qdo.paperDesc.eq(query.getPaperDesc()));
        }
        /** 纸质合同状态 精确 */
        if (!ObjectUtils.isEmpty(query.getPaperStatus())) {
            list.add(qdo.paperStatus.eq(query.getPaperStatus()));
        }
        /** 合同激活时间 精确 */
        if (!ObjectUtils.isEmpty(query.getAcitveDate())) {
            list.add(qdo.acitveDate.eq(query.getAcitveDate()));
        }
        /** 产品 精确 */
        if (!ObjectUtils.isEmpty(query.getProduct())) {
            list.add(qdo.product.eq(query.getProduct()));
        }
        /** 简要说明 精确 */
        if (!ObjectUtils.isEmpty(query.getBriefDesc())) {
            list.add(qdo.briefDesc.eq(query.getBriefDesc()));
        }
        /** 工作类型 精确 */
        if (!ObjectUtils.isEmpty(query.getWorkType())) {
            list.add(qdo.workType.eq(query.getWorkType()));
        }
        /** 促销类型 精确 */
        if (!ObjectUtils.isEmpty(query.getPromotionType())) {
            list.add(qdo.promotionType.eq(query.getPromotionType()));
        }
        /** 范围性质 精确 */
        if (!ObjectUtils.isEmpty(query.getRangeProp())) {
            list.add(qdo.rangeProp.eq(query.getRangeProp()));
        }
        /** 半开口说明 精确 */
        if (!ObjectUtils.isEmpty(query.getHalfOpenDesc())) {
            list.add(qdo.halfOpenDesc.eq(query.getHalfOpenDesc()));
        }
        /** 供应主体类别 精确 */
        if (!ObjectUtils.isEmpty(query.getSupplierType())) {
            list.add(qdo.supplierType.eq(query.getSupplierType()));
        }
        /** 提成类别 精确 */
        if (!ObjectUtils.isEmpty(query.getCommissionType())) {
            list.add(qdo.commissionType.eq(query.getCommissionType()));
        }
        /** 交易方式 精确 */
        if (!ObjectUtils.isEmpty(query.getTransactionMethod())) {
            list.add(qdo.transactionMethod.eq(query.getTransactionMethod()));
        }
        /** 交易性质 精确 */
        if (!ObjectUtils.isEmpty(query.getTransactionNature())) {
            list.add(qdo.transactionNature.eq(query.getTransactionNature()));
        }
        /** 需求类别 精确 */
        if (!ObjectUtils.isEmpty(query.getDemandType())) {
            list.add(qdo.demandType.eq(query.getDemandType()));
        }
        /** 销售分类 精确 */
        if (!ObjectUtils.isEmpty(query.getSaleClass())) {
            list.add(qdo.saleClass.eq(query.getSaleClass()));
        }
        /** 客户承担差旅费 精确 */
        if (!ObjectUtils.isEmpty(query.getCustBarExpense())) {
            list.add(qdo.custBarExpense.eq(query.getCustBarExpense()));
        }
        /** 报销政策说明 精确 */
        if (!ObjectUtils.isEmpty(query.getReimbursementDesc())) {
            list.add(qdo.reimbursementDesc.eq(query.getReimbursementDesc()));
        }
        /** 额定当量 精确 */
        if (!ObjectUtils.isEmpty(query.getRatedEqva())) {
            list.add(qdo.ratedEqva.eq(query.getRatedEqva()));
        }
        /** 额定费用 精确 */
        if (!ObjectUtils.isEmpty(query.getRatedExpense())) {
            list.add(qdo.ratedExpense.eq(query.getRatedExpense()));
        }
        /** 合同打印方 精确 */
        if (!ObjectUtils.isEmpty(query.getContractPrinter())) {
            list.add(qdo.contractPrinter.eq(query.getContractPrinter()));
        }
        /** 打印份数 精确 */
        if (!ObjectUtils.isEmpty(query.getPrintCount())) {
            list.add(qdo.printCount.eq(query.getPrintCount()));
        }
        /** 盖章类型 精确 */
        if (!ObjectUtils.isEmpty(query.getSealType())) {
            list.add(qdo.sealType.eq(query.getSealType()));
        }
        /** 和发票一起邮寄，0：是，1：否 精确 */
        if (!ObjectUtils.isEmpty(query.getSendWithInvoiceFlag())) {
            list.add(qdo.sendWithInvoiceFlag.eq(query.getSendWithInvoiceFlag()));
        }
        /** 邮寄地址 模糊 */
        if (!ObjectUtils.isEmpty(query.getMailingAddress())) {
            list.add(qdo.mailingAddress.like(SqlUtil.toSqlLikeString(query.getMailingAddress())));
        }
        /** 父ID 精确 */
        if (!ObjectUtils.isEmpty(query.getParentId())) {
            list.add(qdo.parentId.eq(query.getParentId()));
        }
        /** 关闭时间 精确 */
        if (!ObjectUtils.isEmpty(query.getCloseDate())) {
            list.add(qdo.closeDate.eq(query.getCloseDate()));
        }
        /** 售前BU 精确 */
        if (!ObjectUtils.isEmpty(query.getPreSaleBuId())) {
            list.add(qdo.preSaleBuId.eq(query.getPreSaleBuId()));
        }
        /** 售前负责人 精确 */
        if (!ObjectUtils.isEmpty(query.getPreSaleUserId())) {
            list.add(qdo.preSaleUserId.eq(query.getPreSaleUserId()));
        }
        /** 合同金额范围 区间 */
        if (!ObjectUtils.isEmpty(query.getAmtScope())) {
            list.add(qdo.amt.between(query.getAmtScope().get(0), query.getAmtScope().get(1)));
        }
        /** 业绩统计状态 精确 */
        if ("handled".equals(query.getAchieveStatus())) {
            list.add(qConAchieve.id.isNotNull());
        }
        /** 业绩统计状态 精确 */
        if ("unhandled".equals(query.getAchieveStatus())) {
            list.add(qConAchieve.id.isNull());
        }
        /** 业绩统计部门ID 精确 */
        if (!ObjectUtils.isEmpty(query.getAchieveBuId())) {
            list.add(qConAchieveD.buId.eq(query.getAchieveBuId()));
        }
        /** 价值角色 精确 */
        if (!ObjectUtils.isEmpty(query.getValueRole())) {
            list.add(qConAchieveD.valueRole.eq(query.getValueRole()));
        }
        /** 部门归属人员ID 精确 */
        if (!ObjectUtils.isEmpty(query.getChargeResId())) {
            list.add(qConAchieveD.chargeResId.eq(query.getChargeResId()));
        }
        /** 合同归档标志 精确 */
        if (!ObjectUtils.isEmpty(query.getFilingFlag())) {
            list.add(qdo.filingFlag.eq(query.getFilingFlag()));
        }
        /** 合同归档标志 精确 */
        if (!ObjectUtils.isEmpty(query.getJdeStatus())) {
            list.add(qdo.jdeStatus.eq(query.getJdeStatus()));
        }
        /** 合同收回时间开始 精确 */
        if (!ObjectUtils.isEmpty(query.getReceiveStartTime())) {
            list.add(qdo.receiveTime.goe(query.getReceiveStartTime()));
        }
        /** 合同收回时间结束 精确 */
        if (!ObjectUtils.isEmpty(query.getReceiveEndTime())) {
            list.add(qdo.receiveTime.loe(query.getReceiveEndTime()));
        }
        /** 是否有代理费 1是  0否 精确 */
        if (!ObjectUtils.isEmpty(query.getAgentFlag())) {
            list.add(qdo.agentFlag.eq(query.getAgentFlag()));
        }
        /** 代理费比例 精确 */
        if (!ObjectUtils.isEmpty(query.getAgentProportion())) {
            list.add(qdo.agentProportion.eq(query.getAgentProportion()));
        }
        /** 代理费金额 精确 */
        if (!ObjectUtils.isEmpty(query.getAgentAmt())) {
            list.add(qdo.agentAmt.eq(query.getAgentAmt()));
        }
        /** 拓展 精确 */
        if (!ObjectUtils.isEmpty(query.getExt1())) {
            list.add(qdo.ext1.eq(query.getExt1()));
        }
        /** 拓展 精确 */
        if (!ObjectUtils.isEmpty(query.getExt2())) {
            list.add(qdo.ext2.eq(query.getExt2()));
        }
        /** 拓展 精确 */
        if (!ObjectUtils.isEmpty(query.getExt3())) {
            list.add(qdo.ext3.eq(query.getExt3()));
        }
        /** 拓展 精确 */
        if (!ObjectUtils.isEmpty(query.getExt4())) {
            list.add(qdo.ext4.eq(query.getExt4()));
        }
        /** 拓展 精确 */
        if (!ObjectUtils.isEmpty(query.getExt5())) {
            list.add(qdo.ext5.eq(query.getExt5()));
        }
        /** 项目是否创建 */
        if (!ObjectUtils.isEmpty(query.getIsProjectCreate())) {
            if (Integer.valueOf(0).compareTo(query.getIsProjectCreate()) == 0) {
                list.add(projectDO.projNo.isNull());
            } else if (Integer.valueOf(1).compareTo(query.getIsProjectCreate()) == 0) {
                list.add(projectDO.projNo.isNotNull());
            }
        }
        // 合同是否创建执行情况
        if (!ObjectUtils.isEmpty(query.getConConditionFlag())) {
            if (0 == query.getConConditionFlag()) {
                list.add(conConditionDO.contractId.isNull());
            } else {
                list.add(conConditionDO.contractId.isNotNull());
            }
        }
        /**
         * 关于列表权限
         */
        if ((!CollectionUtils.isEmpty(query.getOrgIdsByPermission()) || (!CollectionUtils.isEmpty(query.getUserIdsByPermission())))) {
            list.add(qdo.deliBuId.in(query.getOrgIdsByPermission()).or(qdo.signBuId.in(query.getOrgIdsByPermission())).or(qdoRef.orgId.in(query.getOrgIdsByPermission()))
                    .or(qdo.saleManUserId.in(query.getUserIdsByPermission())).or(qdo.deliUserId.in(query.getUserIdsByPermission())).or(qdo.createUserId.in(query.getUserIdsByPermission()))
                    .or(qdo.coSignUserId.in(query.getUserIdsByPermission())).or(qdo.codeliUserId.in(query.getUserIdsByPermission())));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public SaleConContractVO queryByKey(Long id) {
        JPAQuery<SaleConContractVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }


    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<SaleConContractVO> queryContractListDynamic(SaleConContractQuery query) {
        JPAQuery<SaleConContractVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<SaleConContractListVO> queryListDynamic(SaleConContractQuery query) {
        JPAQuery<SaleConContractListVO> jpaQuery = getJpaQuerySelectList();
        if (!ObjectUtils.isEmpty(query.getIds())) {
            jpaQuery.where(qdo.id.in(query.getIds()));
        }
        if (!ObjectUtils.isEmpty(query.getMainType())) {
            jpaQuery.where(qdo.mainType.eq(query.getMainType()));
        }
        if (!ObjectUtils.isEmpty(query.getOppoIds())) {
            jpaQuery.where(qdo.oppoId.in(query.getOppoIds()));
        }
        if (!ObjectUtils.isEmpty(query.getCodeList())) {
            jpaQuery.where(qdo.code.in(query.getCodeList()));
        }
        /** 平台合同类型 精确 */
        if (!ObjectUtils.isEmpty(query.getPlatType())) {
            jpaQuery.where(qdo.platType.eq(query.getPlatType()));
        } else {
            // 默认隐藏虚拟合同
            jpaQuery.where(qdo.platType.ne(SaleConEnum.FICTITIOUS.getCode()));
        }
        jpaQuery.distinct().where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<SaleConContractVO> queryPaging(SaleConContractQuery query) {
        JPAQuery<SaleConContractVO> jpaQuery = getJpaQueryWhere(query);
        List<SaleConContractVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<SaleConContractVO>builder().records(result).total(jpaQuery.fetchCount()).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public SaleConContractDO save(SaleConContractDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<SaleConContractDO> saveAll(List<SaleConContractDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(SaleConContractPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 合同编号
        if (payload.getCode() != null) {
            update.set(qdo.code, payload.getCode());
        }
        // 合同名称
        if (payload.getName() != null) {
            update.set(qdo.name, payload.getName());
        }
        // 合同状态
        if (payload.getStatus() != null) {
            update.set(qdo.status, payload.getStatus());
        }
        // 签约公司ID
        if (payload.getOuBookId() != null) {
            update.set(qdo.ouBookId, payload.getOuBookId());
        }
        // 参考合同号
        if (payload.getReferCode() != null) {
            update.set(qdo.referCode, payload.getReferCode());
        }
        // 商机ID
        if (payload.getOppoId() != null) {
            update.set(qdo.oppoId, payload.getOppoId());
        }
        // 客户ID
        if (payload.getCustId() != null) {
            update.set(qdo.custId, payload.getCustId());
        }
        // 业务伙伴id
//        if (payload.getPartnerId() != null) {
//            update.set(qdo.partnerId, payload.getPartnerId());
//        }
        // 签约时客户名称
        if (payload.getCustName() != null) {
            update.set(qdo.custName, payload.getCustName());
        }
        // 关联合同ID
        if (payload.getRelatedContractId() != null) {
            update.set(qdo.relatedContractId, payload.getRelatedContractId());
        }
        // 新客户标志，0：新客户，1：老客户
        if (payload.getCustFlag() != null) {
            update.set(qdo.custFlag, payload.getCustFlag());
        }
        // 特别关注点
        if (payload.getSpecialConcerned() != null) {
            update.set(qdo.specialConcerned, payload.getSpecialConcerned());
        }
        // 币种
        if (payload.getCurrCode() != null) {
            update.set(qdo.currCode, payload.getCurrCode());
        }
        // 关闭原因
        if (payload.getCloseReason() != null) {
            update.set(qdo.closeReason, payload.getCloseReason());
        }
        // 客户项目
        if (payload.getCustProj() != null) {
            update.set(qdo.custProj, payload.getCustProj());
        }
        // 销售内容
        if (payload.getSaleContent() != null) {
            update.set(qdo.saleContent, payload.getSaleContent());
        }
        // 产品大类
        if (payload.getProductClass() != null) {
            update.set(qdo.productClass, payload.getProductClass());
        }
        // 产品小类
        if (payload.getProductSubClass() != null) {
            update.set(qdo.productSubClass, payload.getProductSubClass());
        }
        // 交付地点
        if (payload.getDeliveryAddress() != null) {
            update.set(qdo.deliveryAddress, payload.getDeliveryAddress());
        }
        // 财务期间ID
        if (payload.getFinPeriodId() != null) {
            update.set(qdo.finPeriodId, payload.getFinPeriodId());
        }
        // 合同总金额
        if (payload.getAmt() != null) {
            update.set(qdo.amt, payload.getAmt());
        }
        // 其它费用
        if (payload.getExtraAmt() != null) {
            update.set(qdo.extraAmt, payload.getExtraAmt());
        }
        // 有效合同金额
        if (payload.getEffectiveAmt() != null) {
            update.set(qdo.effectiveAmt, payload.getEffectiveAmt());
        }
        // 毛利
        if (payload.getGrossProfit() != null) {
            update.set(qdo.grossProfit, payload.getGrossProfit());
        }
        // 销售区域BU_ID
        if (payload.getRegionBuId() != null) {
            update.set(qdo.regionBuId, payload.getRegionBuId());
        }
        // 销售区域负责人
        if (payload.getRegionUserId() != null) {
            update.set(qdo.regionUserId, payload.getRegionUserId());
        }
        // 签单BU_ID
        if (payload.getSignBuId() != null) {
            update.set(qdo.signBuId, payload.getSignBuId());
        }
        // 副签单BU_ID
        if (payload.getCoSignBuId() != null) {
            update.set(qdo.coSignBuId, payload.getCoSignBuId());
        }
        // 副签单用户id
        if (payload.getCoSignUserId() != null) {
            update.set(qdo.coSignUserId, payload.getCoSignUserId());
        }
        // 交付BU_ID
        if (payload.getDeliBuId() != null) {
            update.set(qdo.deliBuId, payload.getDeliBuId());
        }
        // 交付用户id
        if (payload.getDeliUserId() != null) {
            update.set(qdo.deliUserId, payload.getDeliUserId());
        }
        // 副交付BU_ID
        if (payload.getCodeliBuId() != null) {
            update.set(qdo.codeliBuId, payload.getCodeliBuId());
        }
        // 副交付用户id
        if (payload.getCodeliUserId() != null) {
            update.set(qdo.codeliUserId, payload.getCodeliUserId());
        }
        // 平台合同类型
        if (payload.getPlatType() != null) {
            update.set(qdo.platType, payload.getPlatType());
        }
        // 主合同类型
        if (payload.getMainType() != null) {
            update.set(qdo.mainType, payload.getMainType());
        }
        // PMO用户ID
        if (payload.getPmoUserId() != null) {
            update.set(qdo.pmoUserId, payload.getPmoUserId());
        }
        // 来源类型
        if (payload.getSourceType() != null) {
            update.set(qdo.sourceType, payload.getSourceType());
        }
        // 外部来源
        if (payload.getExternalIden() != null) {
            update.set(qdo.externalIden, payload.getExternalIden());
        }
        // 外部来源人
        if (payload.getExternalName() != null) {
            update.set(qdo.externalName, payload.getExternalName());
        }
        // 外部来源电话
        if (payload.getExternalPhone() != null) {
            update.set(qdo.externalPhone, payload.getExternalPhone());
        }
        // 内部来源BU_ID
        if (payload.getInternalBuId() != null) {
            update.set(qdo.internalBuId, payload.getInternalBuId());
        }
        // 利益承诺
        if (payload.getProfitDesc() != null) {
            update.set(qdo.profitDesc, payload.getProfitDesc());
        }
        // 税率
        if (payload.getTaxRate() != null) {
            update.set(qdo.taxRate, payload.getTaxRate());
        }
        // 销售人员用户ID
        if (payload.getSaleManUserId() != null) {
            update.set(qdo.saleManUserId, payload.getSaleManUserId());
        }
        // 内部来源用户ID
        if (payload.getInternalUserId() != null) {
            update.set(qdo.internalUserId, payload.getInternalUserId());
        }
        // 合同开始日期
        if (payload.getStartDate() != null) {
            update.set(qdo.startDate, payload.getStartDate());
        }
        // 合同结束日期
        if (payload.getEndDate() != null) {
            update.set(qdo.endDate, payload.getEndDate());
        }
        // 纸质合同状态描述
        if (payload.getPaperDesc() != null) {
            update.set(qdo.paperDesc, payload.getPaperDesc());
        }
        // 纸质合同状态
        if (payload.getPaperStatus() != null) {
            update.set(qdo.paperStatus, payload.getPaperStatus());
        }
        // 合同激活时间
        if (payload.getAcitveDate() != null) {
            update.set(qdo.acitveDate, payload.getAcitveDate());
        }
        // 产品
        if (payload.getProduct() != null) {
            update.set(qdo.product, payload.getProduct());
        }
        // 简要说明
        if (payload.getBriefDesc() != null) {
            update.set(qdo.briefDesc, payload.getBriefDesc());
        }
        // 工作类型
        if (payload.getWorkType() != null) {
            update.set(qdo.workType, payload.getWorkType());
        }
        // 促销类型
        if (payload.getPromotionType() != null) {
            update.set(qdo.promotionType, payload.getPromotionType());
        }
        // 范围性质
        if (payload.getRangeProp() != null) {
            update.set(qdo.rangeProp, payload.getRangeProp());
        }
        // 半开口说明
        if (payload.getHalfOpenDesc() != null) {
            update.set(qdo.halfOpenDesc, payload.getHalfOpenDesc());
        }
        // 供应主体类别
        if (payload.getSupplierType() != null) {
            update.set(qdo.supplierType, payload.getSupplierType());
        }
        // 提成类别
        if (payload.getCommissionType() != null) {
            update.set(qdo.commissionType, payload.getCommissionType());
        }
        // 交易方式
        if (payload.getTransactionMethod() != null) {
            update.set(qdo.transactionMethod, payload.getTransactionMethod());
        }
        // 交易性质
        if (payload.getTransactionNature() != null) {
            update.set(qdo.transactionNature, payload.getTransactionNature());
        }
        // 需求类别
        if (payload.getDemandType() != null) {
            update.set(qdo.demandType, payload.getDemandType());
        }
        // 销售分类
        if (payload.getSaleClass() != null) {
            update.set(qdo.saleClass, payload.getSaleClass());
        }
        // 客户承担差旅费
        if (payload.getCustBarExpense() != null) {
            update.set(qdo.custBarExpense, payload.getCustBarExpense());
        }
        // 报销政策说明
        if (payload.getReimbursementDesc() != null) {
            update.set(qdo.reimbursementDesc, payload.getReimbursementDesc());
        }
        // 额定当量
        if (payload.getRatedEqva() != null) {
            update.set(qdo.ratedEqva, payload.getRatedEqva());
        }
        // 额定费用
        if (payload.getRatedExpense() != null) {
            update.set(qdo.ratedExpense, payload.getRatedExpense());
        }
        // 合同打印方
        if (payload.getContractPrinter() != null) {
            update.set(qdo.contractPrinter, payload.getContractPrinter());
        }
        // 打印份数
        if (payload.getPrintCount() != null) {
            update.set(qdo.printCount, payload.getPrintCount());
        }
        // 盖章类型
        if (payload.getSealType() != null) {
            update.set(qdo.sealType, payload.getSealType());
        }
        // 和发票一起邮寄，0：是，1：否
        if (payload.getSendWithInvoiceFlag() != null) {
            update.set(qdo.sendWithInvoiceFlag, payload.getSendWithInvoiceFlag());
        }
        // 邮寄地址
        if (payload.getMailingAddress() != null) {
            update.set(qdo.mailingAddress, payload.getMailingAddress());
        }
        // 父ID
        if (payload.getParentId() != null) {
            update.set(qdo.parentId, payload.getParentId());
        }
        // 备注
        if (payload.getRemark() != null) {
            update.set(qdo.remark, payload.getRemark());
        }
        // 附件
        if (payload.getFileCodes() != null) {
            update.set(qdo.fileCodes, payload.getFileCodes());
        }
        // sow附件
        if (payload.getSowFileCodes() != null) {
            update.set(qdo.sowFileCodes, payload.getSowFileCodes());
        }
        // 估算申请单附件
        if (payload.getAssessFileCodes() != null) {
            update.set(qdo.assessFileCodes, payload.getAssessFileCodes());
        }
        // 合同关闭附件
        if (payload.getCloseFileCodes() != null) {
            update.set(qdo.closeFileCodes, payload.getCloseFileCodes());
        }
        // 易道壳文件夹id
        if (payload.getFolderId() != null) {
            update.set(qdo.folderId, payload.getFolderId());
        }
        // 售前bu
        if (payload.getPreSaleBuId() != null) {
            update.set(qdo.preSaleBuId, payload.getPreSaleBuId());
        }
        // 售前负责人
        if (payload.getPreSaleUserId() != null) {
            update.set(qdo.preSaleUserId, payload.getPreSaleUserId());
        }
        // 关闭时间
        if (payload.getCloseDate() != null) {
            update.set(qdo.closeDate, payload.getCloseDate());
        }
        // 签订日期
        if (payload.getSignDate() != null) {
            update.set(qdo.signDate, payload.getSignDate());
        }

        if (payload.getProcInstId() != null) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        if (payload.getProcInstStatus() != null) {
            update.set(qdo.procInstStatus, payload.getProcInstStatus());
        }
        if (payload.getSubmitTime() != null) {
            update.set(qdo.submitTime, payload.getSubmitTime());
        }
        if (payload.getApprovedTime() != null) {
            update.set(qdo.approvedTime, payload.getApprovedTime());
        }
        if (payload.getFinGross() != null) {
            update.set(qdo.finGross, payload.getFinGross());
        }
        if (payload.getFinRatedEqva() != null) {
            update.set(qdo.finRatedEqva, payload.getFinRatedEqva());
        }
        if (payload.getSysGross() != null) {
            update.set(qdo.sysGross, payload.getSysGross());
        }
        if (payload.getNetRate() != null) {
            update.set(qdo.netRate, payload.getNetRate());
        }
        if (payload.getRatedCost() != null) {
            update.set(qdo.ratedCost, payload.getRatedCost());
        }
        if (payload.getChangeFlag() != null) {
            update.set(qdo.changeFlag, payload.getChangeFlag());
        }
        // 合同收回日期
        if (payload.getReceiveTime() != null) {
            update.set(qdo.receiveTime, payload.getReceiveTime());
        }
        // 是否有代理费 1是  0否
        if (payload.getAgentFlag() != null) {
            update.set(qdo.agentFlag, payload.getAgentFlag());
        }
        // 代理费比例
        if (payload.getAgentProportion() != null) {
            update.set(qdo.agentProportion, payload.getAgentProportion());
        }
        // 代理费金额
        if (payload.getAgentAmt() != null) {
            update.set(qdo.agentAmt, payload.getAgentAmt());
        }
        // 平台提成比例
        if (payload.getPercentage() != null) {
            update.set(qdo.percentage, payload.getPercentage());
        }
        // 拓展
        if (payload.getExt1() != null) {
            update.set(qdo.ext1, payload.getExt1());
        }
        // 拓展
        if (payload.getExt2() != null) {
            update.set(qdo.ext2, payload.getExt2());
        }
        // 拓展
        if (payload.getExt3() != null) {
            update.set(qdo.ext3, payload.getExt3());
        }
        // 拓展
        if (payload.getExt4() != null) {
            update.set(qdo.ext4, payload.getExt4());
        }
        // 拓展
        if (payload.getExt5() != null) {
            update.set(qdo.ext5, payload.getExt5());
        }

        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            if (nullFields.contains("finGross")) {
                update.setNull(qdo.finGross);
            }
            if (nullFields.contains("finRatedEqva")) {
                update.setNull(qdo.finRatedEqva);
            }
            if (nullFields.contains("sysGross")) {
                update.setNull(qdo.sysGross);
            }
            if (nullFields.contains("netRate")) {
                update.setNull(qdo.netRate);
            }
            if (nullFields.contains("ratedCost")) {
                update.setNull(qdo.ratedCost);
            }
            if (nullFields.contains("fileCodes")) {
                update.setNull(qdo.fileCodes);
            }
            if (nullFields.contains("assessFileCodes")) {
                update.setNull(qdo.assessFileCodes);
            }
            if (nullFields.contains("sowFileCodes")) {
                update.setNull(qdo.sowFileCodes);
            }
            if (nullFields.contains("closeFileCodes")) {
                update.setNull(qdo.closeFileCodes);
            }
            // 合同编号
            if (nullFields.contains("code")) {
                update.setNull(qdo.code);
            }
            // 合同名称
            if (nullFields.contains("name")) {
                update.setNull(qdo.name);
            }
            // 合同状态
            if (nullFields.contains("status")) {
                update.setNull(qdo.status);
            }
            // 签约公司ID
            if (nullFields.contains("ouBookId")) {
                update.setNull(qdo.ouBookId);
            }
            // 参考合同号
            if (nullFields.contains("referCode")) {
                update.setNull(qdo.referCode);
            }
            // 商机ID
            if (nullFields.contains("oppoId")) {
                update.setNull(qdo.oppoId);
            }
            // 客户ID
            if (nullFields.contains("custId")) {
                update.setNull(qdo.custId);
            }
            // 签约时客户名称
            if (nullFields.contains("custName")) {
                update.setNull(qdo.custName);
            }
            // 关联合同ID
            if (nullFields.contains("relatedContractId")) {
                update.setNull(qdo.relatedContractId);
            }
            // 新客户标志，0：新客户，1：老客户
            if (nullFields.contains("custFlag")) {
                update.setNull(qdo.custFlag);
            }
            // 签订日期
            if (nullFields.contains("signDate")) {
                update.setNull(qdo.signDate);
            }
            // 特别关注点
            if (nullFields.contains("specialConcerned")) {
                update.setNull(qdo.specialConcerned);
            }
            // 币种
            if (nullFields.contains("currCode")) {
                update.setNull(qdo.currCode);
            }
            // 关闭原因
            if (nullFields.contains("closeReason")) {
                update.setNull(qdo.closeReason);
            }
            // 客户项目
            if (nullFields.contains("custProj")) {
                update.setNull(qdo.custProj);
            }
            // 销售内容
            if (nullFields.contains("saleContent")) {
                update.setNull(qdo.saleContent);
            }
            // 产品大类
            if (nullFields.contains("productCategories")) {
                update.setNull(qdo.productClass);
            }
            // 产品小类
            if (nullFields.contains("productSubCategories")) {
                update.setNull(qdo.productSubClass);
            }
            // 交付地点
            if (nullFields.contains("deliveryAddress")) {
                update.setNull(qdo.deliveryAddress);
            }
            // 财务期间ID
            if (nullFields.contains("finPeriodId")) {
                update.setNull(qdo.finPeriodId);
            }
            // 合同总金额
            if (nullFields.contains("amt")) {
                update.setNull(qdo.amt);
            }
            // 其它费用
            if (nullFields.contains("extraAmt")) {
                update.setNull(qdo.extraAmt);
            }
            // 有效合同金额
            if (nullFields.contains("effectiveAmt")) {
                update.setNull(qdo.effectiveAmt);
            }
            // 毛利
            if (nullFields.contains("grossProfit")) {
                update.setNull(qdo.grossProfit);
            }
            // 销售区域BU_ID
            if (nullFields.contains("regionBuId")) {
                update.setNull(qdo.regionBuId);
            }
            // 销售区域负责人
            if (nullFields.contains("regionUserId")) {
                update.setNull(qdo.regionUserId);
            }
            // 签单BU_ID
            if (nullFields.contains("signBuId")) {
                update.setNull(qdo.signBuId);
            }
            // 副签单BU_ID
            if (nullFields.contains("coSignBuId")) {
                update.setNull(qdo.coSignBuId);
            }
            // 副签单用户id
            if (nullFields.contains("coSignUserId")) {
                update.setNull(qdo.coSignUserId);
            }
            // 交付BU_ID
            if (nullFields.contains("deliBuId")) {
                update.setNull(qdo.deliBuId);
            }
            // 交付用户id
            if (nullFields.contains("deliUserId")) {
                update.setNull(qdo.deliUserId);
            }
            // 副交付BU_ID
            if (nullFields.contains("codeliBuId")) {
                update.setNull(qdo.codeliBuId);
            }
            // 副交付用户id
            if (nullFields.contains("codeliUserId")) {
                update.setNull(qdo.codeliUserId);
            }
            // 平台合同类型
            if (nullFields.contains("platType")) {
                update.setNull(qdo.platType);
            }
            // 主合同类型
            if (nullFields.contains("mainType")) {
                update.setNull(qdo.mainType);
            }
            // PMO用户ID
            if (nullFields.contains("pmoUserId")) {
                update.setNull(qdo.pmoUserId);
            }
            // 来源类型
            if (nullFields.contains("sourceType")) {
                update.setNull(qdo.sourceType);
            }
            // 外部来源
            if (nullFields.contains("externalIden")) {
                update.setNull(qdo.externalIden);
            }
            // 外部来源人
            if (nullFields.contains("externalName")) {
                update.setNull(qdo.externalName);
            }
            // 外部来源电话
            if (nullFields.contains("externalPhone")) {
                update.setNull(qdo.externalPhone);
            }
            // 内部来源BU_ID
            if (nullFields.contains("internalBuId")) {
                update.setNull(qdo.internalBuId);
            }
            // 利益承诺
            if (nullFields.contains("profitDesc")) {
                update.setNull(qdo.profitDesc);
            }
            // 税率
            if (nullFields.contains("taxRate")) {
                update.setNull(qdo.taxRate);
            }
            // 销售人员用户ID
            if (nullFields.contains("saleManUserId")) {
                update.setNull(qdo.saleManUserId);
            }
            // 内部来源用户ID
            if (nullFields.contains("internalUserId")) {
                update.setNull(qdo.internalUserId);
            }
            // 合同开始日期
            if (nullFields.contains("startDate")) {
                update.setNull(qdo.startDate);
            }
            // 合同结束日期
            if (nullFields.contains("endDate")) {
                update.setNull(qdo.endDate);
            }
            // 纸质合同状态描述
            if (nullFields.contains("paperDesc")) {
                update.setNull(qdo.paperDesc);
            }
            // 纸质合同状态
            if (nullFields.contains("paperStatus")) {
                update.setNull(qdo.paperStatus);
            }
            // 合同激活时间
            if (nullFields.contains("acitveDate")) {
                update.setNull(qdo.acitveDate);
            }
            // 产品
            if (nullFields.contains("product")) {
                update.setNull(qdo.product);
            }
            // 简要说明
            if (nullFields.contains("briefDesc")) {
                update.setNull(qdo.briefDesc);
            }
            // 工作类型
            if (nullFields.contains("workType")) {
                update.setNull(qdo.workType);
            }
            // 促销类型
            if (nullFields.contains("promotionType")) {
                update.setNull(qdo.promotionType);
            }
            // 范围性质
            if (nullFields.contains("rangeProp")) {
                update.setNull(qdo.rangeProp);
            }
            // 半开口说明
            if (nullFields.contains("halfOpenDesc")) {
                update.setNull(qdo.halfOpenDesc);
            }
            // 供应主体类别
            if (nullFields.contains("supplierType")) {
                update.setNull(qdo.supplierType);
            }
            // 提成类别
            if (nullFields.contains("commissionType")) {
                update.setNull(qdo.commissionType);
            }
            // 交易方式
            if (nullFields.contains("transactionMethod")) {
                update.setNull(qdo.transactionMethod);
            }
            // 交易性质
            if (nullFields.contains("transactionNature")) {
                update.setNull(qdo.transactionNature);
            }
            // 需求类别
            if (nullFields.contains("demandType")) {
                update.setNull(qdo.demandType);
            }
            // 销售分类
            if (nullFields.contains("saleClass")) {
                update.setNull(qdo.saleClass);
            }
            // 客户承担差旅费
            if (nullFields.contains("custBarExpense")) {
                update.setNull(qdo.custBarExpense);
            }
            // 报销政策说明
            if (nullFields.contains("reimbursementDesc")) {
                update.setNull(qdo.reimbursementDesc);
            }
            // 额定当量
            if (nullFields.contains("ratedEqva")) {
                update.setNull(qdo.ratedEqva);
            }
            // 额定费用
            if (nullFields.contains("ratedExpense")) {
                update.setNull(qdo.ratedExpense);
            }
            // 合同打印方
            if (nullFields.contains("contractPrinter")) {
                update.setNull(qdo.contractPrinter);
            }
            // 打印份数
            if (nullFields.contains("printCount")) {
                update.setNull(qdo.printCount);
            }
            // 盖章类型
            if (nullFields.contains("sealType")) {
                update.setNull(qdo.sealType);
            }
            // 和发票一起邮寄，0：是，1：否
            if (nullFields.contains("sendWithInvoiceFlag")) {
                update.setNull(qdo.sendWithInvoiceFlag);
            }
            // 邮寄地址
            if (nullFields.contains("mailingAddress")) {
                update.setNull(qdo.mailingAddress);
            }
            // 父ID
            if (nullFields.contains("parentId")) {
                update.setNull(qdo.parentId);
            }
            // 备注
            if (nullFields.contains("remark")) {
                update.setNull(qdo.remark);
            }
            // 附件
            if (nullFields.contains("fileCodes")) {
                update.setNull(qdo.fileCodes);
            }
            // 售前bu
            if (nullFields.contains("preSaleBuId")) {
                update.setNull(qdo.preSaleBuId);
            }
            // 售前负责人
            if (nullFields.contains("preSaleUserId")) {
                update.setNull(qdo.preSaleUserId);
            }
            // 关闭时间
            if (nullFields.contains("closeDate")) {
                update.setNull(qdo.closeDate);
            }
            // 关闭时间
            if (nullFields.contains("changeFlag")) {
                update.setNull(qdo.changeFlag);
            }
            // 合同收回时间
            if (nullFields.contains("receiveTime")) {
                update.setNull(qdo.receiveTime);
            }
            // 是否有代理费 1是  0否
            if (nullFields.contains("agentFlag")) {
                update.setNull(qdo.agentFlag);
            }
            // 代理费比例
            if (nullFields.contains("agentProportion")) {
                update.setNull(qdo.agentProportion);
            }
            // 代理费金额
            if (nullFields.contains("agentAmt")) {
                update.setNull(qdo.agentAmt);
            }
            // 平台提成比例
            if (nullFields.contains("percentage")) {
                update.setNull(qdo.percentage);
            }
            // 拓展
            if (nullFields.contains("ext1")) {
                update.setNull(qdo.ext1);
            }
            // 拓展
            if (nullFields.contains("ext2")) {
                update.setNull(qdo.ext2);
            }
            // 拓展
            if (nullFields.contains("ext3")) {
                update.setNull(qdo.ext3);
            }
            // 拓展
            if (nullFields.contains("ext4")) {
                update.setNull(qdo.ext4);
            }
            // 拓展
            if (nullFields.contains("ext5")) {
                update.setNull(qdo.ext5);
            }

        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 更新状态
     *
     * @param ids
     * @param
     * @return
     */
    @Transactional
    public Long updataStatusByIds(List<Long> ids, String status) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.status, status)
                .where(qdo.id.in(ids));
        return update.execute();
    }

    /**
     * 合同关闭
     *
     * @param ids
     * @param
     * @return
     */
    public Long closeCon(List<Long> ids) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.status, "close")
                .set(qdo.closeDate, LocalDate.now())
//                .set(qdo.)
                .where(qdo.id.in(ids));
        return update.execute();
    }

    /**
     * 根据父Id查询子合同列表
     *
     * @param parentId
     * @return
     */
    public List<SaleConContractVO> queryListByConId(Long parentId) {
        JPAQuery<SaleConContractVO> jpaQuery = getJpaQuerySelect();
        if (parentId != null) {
            jpaQuery.where(qdo.parentId.eq(parentId));
        }
        return jpaQuery.fetch();
    }

    /**
     * 合同归档
     *
     * @param keys
     * @return
     */
    public Long conFiling(Long[] keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.filingFlag, 1)
                .set(qdo.paperStatus, SaleConContractPaperStatusEnum.BACK.getCode())
            .set(qdo.receiveTime, LocalDateTime.now())
                .where(qdo.id.in(keys));
        return update.execute();
    }

    public Long unConFiling(Long[] keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.filingFlag, 0)
            .set(qdo.paperStatus, SaleConContractPaperStatusEnum.UNBACK.getCode())
            .setNull(qdo.receiveTime)
            .where(qdo.id.in(keys));
        return update.execute();
    }

    /**
     * 根据销售合同ID查询采购合同信息
     *
     * @param saleconId
     * @return
     */
    public List<PurchaseContractManagerVO> queryPurchConList(Long saleconId) {
        JPAQuery<PurchaseContractManagerVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PurchaseContractManagerVO.class,
                        purcConDao.purchaseContractNo,
                        purcConDao.purchaseContractName,
                        purcConDao.amt,
                        purcConDao.taxRate,
                        purcConDao.purchaseBuId,
                        purcConDao.supplierBookId,
                        demandDDO.productClass,
                        demandDDO.productSubClass,
                        purcConDao.platType,
                        demandDDO.productId,
                        productDO.prodName.as("productName"),
                        demandDDO.demandSaid,
                        purcConDao.signDate,
                        purcConDao.id
                )).from(demandDO)
                .distinct()
                .leftJoin(demandDDO).on(demandDO.id.longValue().eq(demandDDO.purDemandId.longValue()).and(demandDDO.deleteFlag.eq(0)).and(demandDDO.purContractId.isNotNull()))
                .leftJoin(purcConDao).on(demandDDO.purContractId.longValue().eq(purcConDao.id.longValue()))
                .leftJoin(productDO).on(demandDDO.productId.longValue().eq(productDO.id.longValue()));
        jpaQuery.where(demandDO.saleConId.eq(saleconId));
        return jpaQuery.fetch();
    }

    /**
     * 主合同修改了副交付负责人与副签单负责人，同步子合同修改
     * 主合同修改 签单BU 销售负责人 签约公司后 子合同同步修改
     *
     * @param newEntity
     * @param subId     子合同id
     */
    public void updateSubContractInfoByMainContract(Long subId, SaleConContractDO newEntity) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(subId));
        // 副交付负责人
        if (!ObjectUtils.isEmpty(newEntity.getCodeliUserId())) {
            update.set(qdo.codeliUserId, newEntity.getCodeliUserId());
        }
        // 副签单负责人ID
        if (!ObjectUtils.isEmpty(newEntity.getCoSignUserId())) {
            update.set(qdo.coSignUserId, newEntity.getCoSignUserId());
        }
        // 签单Bu
        if (!ObjectUtils.isEmpty(newEntity.getSignBuId())) {
            update.set(qdo.signBuId, newEntity.getSignBuId());
        }
        // 销售负责人
        if (!ObjectUtils.isEmpty(newEntity.getSaleManUserId())) {
            update.set(qdo.saleManUserId, newEntity.getSaleManUserId());
        }
        // 签约公司ID
        // if (!ObjectUtils.isEmpty(newEntity.getOuId())) {
        //     update.set(qdo.ouId, newEntity.getOuId());
        // }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        update.execute();
    }

    /**
     * 根据类型和状态获取合同列表
     *
     * @param query
     * @return
     */
    @UdcNameClass
    public List<SaleConContractVO> queryListByMainTypeAndStatus(SaleConContractQuery query) {
        List<SaleConContractVO> saleConContractVOS = SaleConContractConvert.INSTANCE.toVoList(
                repo.findAll(
                        (root, criteriaQuery, criteriaBuilder)
                                -> QueryHelp.getPredicate(root, query, criteriaBuilder)
                        , query.getPageRequest().getSort()
                )
        );
        return saleConContractVOS;
    }

    /**
     * 通过合同编号查询合同Id
     *
     * @param conNo 合同编号
     * @return 合同Id
     */
    public Long findIdByNo(String conNo) {
        return jpaQueryFactory.select(qdo.id).from(qdo).where(qdo.deleteFlag.eq(0)
                .and(qdo.code.eq(conNo))).fetchFirst();
    }

    public List<SaleConContractVO> findSaleConAndProj(String workType, List<String> saleCodeList) {
        JPAQuery<SaleConContractVO> simpleJpaQuerySelect = jpaQueryFactory.select(Projections.bean(SaleConContractVO.class,
                        qdo.id,
                        // 合同编号
                        qdo.code,
                        // 合同名称
                        qdo.name,
                        // 合同状态
                        qdo.status,
                        qdo.closeDate,
                        qdo.taxRate,
                        qdo.ouBookId,
                        // 项目信息
                        projectDO.projName.as("projName"),
                        projectDO.id.as("projId"),
                        projectDO.projNo.as("projCode"),
                        projectDO.projStatus,
                        qBusinessCustomerInfoDO.customerNo
                )).from(qdo)
                .leftJoin(projectDO).on(projectDO.contractId.longValue().eq(qdo.id.longValue()))
                .leftJoin(qBusinessPartnerDO).on(qBusinessPartnerDO.bookId.eq(qdo.custId).and(qBusinessPartnerDO.deleteFlag.eq(0)))
                .leftJoin(qBusinessCustomerInfoDO).on(qBusinessCustomerInfoDO.partnerId.eq(qBusinessPartnerDO.id).and(qBusinessCustomerInfoDO.deleteFlag.eq(0)));

        simpleJpaQuerySelect.where(qdo.deleteFlag.eq(0));
        simpleJpaQuerySelect.where(qdo.workType.eq(workType));
        simpleJpaQuerySelect.where(projectDO.projStatus.eq(ProjectStatusEnum.ACTIVE.getCode()));
        simpleJpaQuerySelect.where(projectDO.deleteFlag.eq(0));
        if (!CollectionUtils.isEmpty(saleCodeList)) {
            simpleJpaQuerySelect.where(qdo.code.in(saleCodeList));
        }
//        simpleJpaQuerySelect.where(qdo.createTime.before(firstDayOfMonth));
        return simpleJpaQuerySelect.fetch();
    }
}

