package com.elitesland.tw.tw5.server.prd.salecon.service;


import com.elitesland.tw.tw5.api.prd.salecon.payload.ConInvSettingTypePayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConInvSettingTypeQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConInvSettingTypeService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvSettingMonthVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvSettingTypeVO;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConInvSettingConvert;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConInvSettingMonthConvert;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConInvSettingTypeConvert;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConInvSettingTypeDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConInvSettingMonthDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConInvSettingTypeDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConInvSettingTypeRepo;
import org.springframework.stereotype.Service;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * ConInvSettingTypeController
 *
 * @author zoey
 * @date 2024-03-14
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ConInvSettingTypeServiceImpl extends BaseServiceImpl implements ConInvSettingTypeService {

    private final ConInvSettingTypeRepo conInvSettingTypeRepo;
    private final ConInvSettingTypeDAO conInvSettingTypeDAO;

    @Override
    public PagingVO<ConInvSettingTypeVO> queryPaging(ConInvSettingTypeQuery query){
        return conInvSettingTypeDAO.queryPaging(query);
    }

    @Override
    public List<ConInvSettingTypeVO> queryListDynamic(ConInvSettingTypeQuery query){
        return conInvSettingTypeDAO.queryListDynamic(query);
    }

    @Override
    public ConInvSettingTypeVO queryByKey(Long key) {
        ConInvSettingTypeDO entity = conInvSettingTypeRepo.findById(key).orElseGet(ConInvSettingTypeDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ConInvSettingTypeVO vo = ConInvSettingTypeConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    public List<ConInvSettingTypeVO> queryByInvSettingId(Long invSettingId){
        List<ConInvSettingTypeVO> vo = new ArrayList<>();
        List<ConInvSettingTypeDO> entityList = conInvSettingTypeRepo.findByInvSettingId(invSettingId);
        if(!CollectionUtils.isEmpty(entityList)){
            vo = ConInvSettingTypeConvert.INSTANCE.toVoList(entityList);
        }
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ConInvSettingTypeVO insert(ConInvSettingTypePayload payload) {
        Assert.notNull(payload.getInvSettingId(),"配置主数据不存在，请先保存配置主数据！");
        ConInvSettingTypeDO entityDo = ConInvSettingTypeConvert.INSTANCE.toDo(payload);
        return ConInvSettingTypeConvert.INSTANCE.toVo(conInvSettingTypeRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ConInvSettingTypeVO update(ConInvSettingTypePayload payload) {
        ConInvSettingTypeDO entity = conInvSettingTypeRepo.findById(payload.getId()).orElseGet(ConInvSettingTypeDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ConInvSettingTypeDO entityDo = ConInvSettingTypeConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ConInvSettingTypeConvert.INSTANCE.toVo(conInvSettingTypeRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(ConInvSettingTypePayload payload) {
        ConInvSettingTypeDO entity = conInvSettingTypeRepo.findById(payload.getId()).orElseGet(ConInvSettingTypeDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = conInvSettingTypeDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            conInvSettingTypeDAO.deleteSoft(keys);
        }
    }

}
