package com.elitesland.tw.tw5.server.prd.system.controller;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemRoleGroupPayload;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemRolePayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemRoleGroupQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleGroupService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 角色组
 *
 * @Author Bill
 * @Date 2023/9/19 13:35
 **/
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/system")
@Slf4j
public class PrdSystemRoleGroupController {

    private final PrdSystemRoleGroupService service;

    /**
     * 角色组添加
     * @param payload
     * @return
     */
    @PostMapping("/roleGroup")
    public TwOutputUtil insert(PrdSystemRoleGroupPayload payload){
        return TwOutputUtil.ok(service.insert(payload));
    }

    /**
     * 角色组修改
     * @param payload
     * @return
     */
    @PutMapping("/roleGroup")
    public TwOutputUtil update(PrdSystemRoleGroupPayload payload){
        return TwOutputUtil.ok(service.update(payload));
    }

    /**
     * 角色组逻辑删除
     * @param keys
     * @return
     */
    @DeleteMapping("/roleGroup/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys){
        service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 角色组主键查询
     * @param id
     * @return
     */
    @GetMapping("/roleGroup/{id}")
    public TwOutputUtil get(@PathVariable Long id){
        return TwOutputUtil.ok(service.get(id));
    }

    /**
     * 角色组模糊分页
     * @param query
     * @return
     */
    @GetMapping("/roleGroup/listGroup")
    public TwOutputUtil listGroup(PrdSystemRoleGroupQuery query){
        return TwOutputUtil.ok(service.listGroup(query));
    }

    /**
     * 角色组列表查询全部
     * @Params roleGroupType 角色组类型
     * @return
     */
    @GetMapping("/roleGroup")
    public TwOutputUtil list(String roleGroupType){
        return TwOutputUtil.ok(service.list(roleGroupType));
    }

}
